/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import javax.swing.JPanel;
import org.openide.util.NbBundle;

public final class ClusterizeVisualPanel3 extends JPanel {
    ClusterizeWizardPanel3 panel;

    /** Creates new form ClusterizeVisualPanel3 */
    public ClusterizeVisualPanel3(ClusterizeWizardPanel3 panel) {
        initComponents();

        text.setText(
            NbBundle.getMessage(ClusterizeWizardPanel3.class,
                "MSG_ClusterizeGenerate", panel.settings.file,
                panel.settings.modules.getSelectedFilesCount()
            )
        );
        this.panel = panel;

        putClientProperty("WizardPanel_contentSelectedIndex", Integer.valueOf(2));
        putClientProperty("WizardPanel_contentData", panel.settings.getStep(2));
        putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
    }

    @Override
    public String getName() {
        if (panel == null || panel.settings == null) {
            return "";
        }
        return panel.settings.getStep(2);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        text = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(text, org.openide.util.NbBundle.getMessage(ClusterizeVisualPanel3.class, "ClusterizeVisualPanel3.text.text")); // NOI18N
        text.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(text, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(text, javax.swing.GroupLayout.DEFAULT_SIZE, 276, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel text;
    // End of variables declaration//GEN-END:variables
}

