/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;
import org.apache.olingo.odata2.core.uri.expression.ParameterSet;

public interface ParameterSetCombination {
    public void add(ParameterSet var1);

    public ParameterSet validate(List<EdmType> var1) throws ExpressionParserInternalError;

    public void addFirst(ParameterSet var1);

    public EdmType getReturnType();

    public static class PSCReturnTypeEqLastParameter
    implements ParameterSetCombination {
        @Override
        public void add(ParameterSet parameterSet) {
            throw new IllegalStateException();
        }

        @Override
        public void addFirst(ParameterSet parameterSet) {
            throw new IllegalStateException();
        }

        @Override
        public ParameterSet validate(List<EdmType> actualParameterTypes) throws ExpressionParserInternalError {
            EdmType xxx = actualParameterTypes.get(actualParameterTypes.size() - 1);
            return new ParameterSet(xxx, null);
        }

        @Override
        public EdmType getReturnType() {
            return null;
        }
    }

    public static class PSCflex
    implements ParameterSetCombination {
        private List<ParameterSet> combinations = new ArrayList<ParameterSet>();

        @Override
        public void add(ParameterSet parameterSet) {
            this.combinations.add(parameterSet);
        }

        @Override
        public EdmType getReturnType() {
            int parameterCount = this.combinations.size();
            if (parameterCount == 0) {
                return null;
            }
            if (parameterCount == 1) {
                return this.combinations.get(0).getReturnType();
            }
            EdmType returnType = this.combinations.get(0).getReturnType();
            for (int i = 1; i < parameterCount; ++i) {
                if (returnType == this.combinations.get(i)) continue;
                return null;
            }
            return returnType;
        }

        @Override
        public void addFirst(ParameterSet parameterSet) {
            List<ParameterSet> oldCombinations = this.combinations;
            this.combinations = new ArrayList<ParameterSet>();
            this.combinations.add(parameterSet);
            for (ParameterSet parameterSet1 : oldCombinations) {
                this.combinations.add(parameterSet1);
            }
        }

        @Override
        public ParameterSet validate(List<EdmType> actualParameterTypes) throws ExpressionParserInternalError {
            boolean s;
            if (this.combinations.isEmpty()) {
                return new ParameterSet(null, null);
            }
            for (ParameterSet parameterSet : this.combinations) {
                s = parameterSet.equals(actualParameterTypes, false);
                if (!s) continue;
                return parameterSet;
            }
            for (ParameterSet parameterSet : this.combinations) {
                s = parameterSet.equals(actualParameterTypes, true);
                if (!s) continue;
                return parameterSet;
            }
            return null;
        }
    }
}

