# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import datetime
import enum
import typing

@typing.final
class Entry:
    r"""
    Entry.

    An entry representing a path and its associated metadata.

    Notes
    -----
    If this entry is a directory, ``path`` **must** end with ``/``.
    Otherwise, ``path`` **must not** end with ``/``.
    """

    @property
    def path(self) -> builtins.str:
        r"""The path of entry relative to the operator's root."""
    @property
    def name(self) -> builtins.str:
        r"""The name of entry, representing the last segment of the path."""
    @property
    def metadata(self) -> Metadata:
        r"""The metadata of this entry."""

@typing.final
class Metadata:
    r"""
    The metadata of an ``Entry``.

    The metadata is always tied to a specific context and is not a global
    state. For example, two versions of the same path might have different
    content lengths.

    Notes
    -----
    In systems that support versioning, such as AWS S3, the metadata may
    represent a specific version of a file. Use :attr:`version` to get
    the version of a file if it is available.
    """

    @property
    def content_disposition(self) -> builtins.str | None:
        r"""The content disposition of this entry."""
    @property
    def content_length(self) -> builtins.int:
        r"""The content length of this entry."""
    @property
    def content_md5(self) -> builtins.str | None:
        r"""The content MD5 of this entry."""
    @property
    def content_type(self) -> builtins.str | None:
        r"""The content type of this entry."""
    @property
    def content_encoding(self) -> builtins.str | None:
        r"""The content encoding of this entry."""
    @property
    def etag(self) -> builtins.str | None:
        r"""The ETag of this entry."""
    @property
    def mode(self) -> EntryMode:
        r"""The mode of this entry."""
    @property
    def is_file(self) -> builtins.bool:
        r"""Whether this entry is a file."""
    @property
    def is_dir(self) -> builtins.bool:
        r"""Whether this entry is a directory."""
    @property
    def last_modified(self) -> datetime.datetime:
        r"""The last modified timestamp of this entry."""
    @property
    def version(self) -> builtins.str | None:
        r"""The version of this entry."""
    @property
    def user_metadata(self) -> builtins.dict[builtins.str, builtins.str] | None:
        r"""The user-defined metadata of this entry."""

@typing.final
class PresignedRequest:
    r"""
    A presigned request.

    This contains the information required to make a request to the
    underlying service, including the URL, method, and headers.
    """

    @property
    def url(self) -> builtins.str:
        r"""The URL of this request."""
    @property
    def method(self) -> builtins.str:
        r"""The HTTP method of this request."""
    @property
    def headers(self) -> builtins.dict[builtins.str, builtins.str]:
        r"""
        The HTTP headers of this request.

        Returns
        -------
        dict
            The HTTP headers of this request.
        """

@typing.final
class EntryMode(enum.Enum):
    r"""
    EntryMode.

    The mode of an entry, indicating if it is a file or a directory.
    """

    File = ...
    r"""
    The entry is a file and has data to read.
    """
    Dir = ...
    r"""
    The entry is a directory and can be listed.
    """
    Unknown = ...
    r"""
    The mode of the entry is unknown.
    """

    def is_file(self) -> builtins.bool:
        r"""
        Check if the entry mode is `File`.

        Returns
        -------
        bool
            True if the entry is a file.
        """
    def is_dir(self) -> builtins.bool:
        r"""
        Check if the entry mode is `Dir`.

        Returns
        -------
        bool
            True if the entry is a directory.
        """
