/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcWriter;
import org.netpreserve.jwarc.net.Browser;
import org.netpreserve.jwarc.net.CaptureIndex;
import org.netpreserve.jwarc.net.WarcServer;

public class WarcRenderer
implements Closeable {
    private static final DateTimeFormatter ARC_TIME = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    private final ServerSocket proxySocket = new ServerSocket(0, -1, InetAddress.getLoopbackAddress());
    private final WarcServer server;
    private final String browserExecutable;

    public WarcRenderer(CaptureIndex index) throws IOException {
        this(index, System.getenv().getOrDefault("BROWSER", "google-chrome"));
    }

    public WarcRenderer(CaptureIndex index, String browserExecutable) throws IOException {
        this.server = new WarcServer(this.proxySocket, index);
        this.browserExecutable = browserExecutable;
        new Thread(this.server::listen).start();
    }

    public void screenshot(URI uri, Instant date, WarcWriter warcWriter) throws IOException {
        this.screenshot(uri.toString(), date, warcWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenshot(String url, Instant date, WarcWriter warcWriter) throws IOException {
        Path screenshot = Files.createTempFile("jwarc-screenshot", ".png", new FileAttribute[0]);
        try {
            Browser browser = new Browser(this.browserExecutable, (InetSocketAddress)this.proxySocket.getLocalSocketAddress(), "WarcRenderer (arctime/" + ARC_TIME.format(date) + ")");
            browser.screenshot(url, screenshot);
            try (FileChannel channel = FileChannel.open(screenshot, new OpenOption[0]);){
                long size = channel.size();
                if (size == 0L) {
                    return;
                }
                warcWriter.write(((WarcResource.Builder)((WarcResource.Builder)new WarcResource.Builder(URI.create("screenshot:" + url)).date(date)).body(MediaType.parse("image/png"), channel, size)).build());
            }
        }
        finally {
            Files.deleteIfExists(screenshot);
        }
    }

    @Override
    public void close() throws IOException {
        this.proxySocket.close();
    }
}

