/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.AbstractRetryable;
import org.jodconverter.core.office.TemporaryException;
import org.jodconverter.local.office.VerboseProcess;

public class ExitCodeRetryable
extends AbstractRetryable<RuntimeException> {
    private int exitCode;
    private final VerboseProcess process;

    public ExitCodeRetryable(@NonNull VerboseProcess process) {
        this.process = process;
    }

    protected void attempt() throws TemporaryException {
        Integer code = this.process.getExitCode();
        if (code == null) {
            throw new TemporaryException("The process has not yet terminated");
        }
        this.exitCode = code;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

