/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.http2;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.http2.IPushBuilder;
import org.apache.wicket.markup.head.http2.PushBuilder;
import org.apache.wicket.markup.head.http2.PushItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class PushHeaderItem
extends HeaderItem {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter headerDateFormat_RFC1123 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.ENGLISH).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter headerDateFormat_RFC1036 = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss zzz").withLocale(Locale.ENGLISH).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter headerDateFormat_ASCTIME = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy").withLocale(Locale.ENGLISH).withZone(ZoneOffset.UTC);
    public static final String HTTP2_PROTOCOL = "http/2";
    private static final String TOKEN_SUFFIX = "http/2_pushed";
    private Set<PushItem> pushItems = ConcurrentHashMap.newKeySet();
    private WebResponse pageWebResponse;
    private WebRequest pageWebRequest;
    private Page page;
    private final IPushBuilder pushBuilder;

    public PushHeaderItem(Page page, Request pageRequest, Response pageResponse) {
        this(page, pageRequest, pageResponse, new PushBuilder());
    }

    public PushHeaderItem(Page page, Request pageRequest, Response pageResponse, IPushBuilder pushBuilder) {
        if (!(page instanceof WebPage && pageRequest instanceof WebRequest && pageResponse instanceof WebResponse)) {
            throw new WicketRuntimeException("Please hand over the web page, the web request and the web response to the push header item like \"new PushHeaderItem(page, webRequest, webResponse)\" - The webResponse / webRequest can be obtained via \"getRequestCycle().getRequest()\" / \"getRequestCycle().getResponse()\" and placed into the page as fields \"private transient Response webPageResponse;\" / \"private transient Request webPageRequest;\"");
        }
        this.pageWebRequest = (WebRequest)pageRequest;
        this.pageWebResponse = (WebResponse)pageResponse;
        this.page = page;
        this.pushBuilder = (IPushBuilder)Args.notNull((Object)pushBuilder, (String)"pushBuilder");
    }

    @Override
    public Iterable<?> getRenderTokens() {
        TreeSet<CallSite> tokens = new TreeSet<CallSite>();
        for (PushItem pushItem : this.pushItems) {
            tokens.add((CallSite)((Object)(pushItem.getUrl() + TOKEN_SUFFIX)));
        }
        return tokens;
    }

    protected Instant getPageModificationTime() {
        URL resource = this.page.getClass().getResource(this.page.getClass().getSimpleName() + ".html");
        if (resource == null) {
            throw new WicketRuntimeException("The markup to the page couldn't be found: " + this.page.getClass().getName());
        }
        try {
            return Instant.ofEpochMilli(resource.openConnection().getLastModified());
        }
        catch (IOException e) {
            throw new WicketRuntimeException("The time couln't be determined of the markup file of the page: " + this.page.getClass().getName(), e);
        }
    }

    protected void applyPageCacheHeader() {
        Instant pageModificationTime = this.getPageModificationTime();
        this.pageWebResponse.setDateHeader("Date", Instant.now());
        this.pageWebResponse.setLastModifiedTime(pageModificationTime);
        this.pageWebResponse.setHeader("Expires", "-1");
        this.pageWebResponse.setHeader("Cache-Control", "max-age=0, public, must-revalidate, proxy-revalidate");
    }

    @Override
    public void render(Response response) {
        this.applyPageCacheHeader();
        HttpServletRequest request = this.getContainerRequest(RequestCycle.get().getRequest());
        if (this.isHttp2(request)) {
            Instant pageModificationTime = this.getPageModificationTime();
            String ifModifiedSinceHeader = this.pageWebRequest.getHeader("If-Modified-Since");
            if (ifModifiedSinceHeader != null) {
                Instant ifModifiedSinceFromRequestTime = this.parseIfModifiedSinceHeader(ifModifiedSinceHeader, headerDateFormat_RFC1123);
                if (ifModifiedSinceFromRequestTime == null) {
                    ifModifiedSinceFromRequestTime = this.parseIfModifiedSinceHeader(ifModifiedSinceHeader, headerDateFormat_ASCTIME);
                }
                if (ifModifiedSinceFromRequestTime == null) {
                    ifModifiedSinceFromRequestTime = this.parseIfModifiedSinceHeader(ifModifiedSinceHeader, headerDateFormat_RFC1036);
                }
                if (ifModifiedSinceFromRequestTime == null || ifModifiedSinceFromRequestTime.isBefore(pageModificationTime)) {
                    this.push(request);
                }
            } else {
                this.push(request);
            }
        }
    }

    private Instant parseIfModifiedSinceHeader(String ifModifiedSinceHeader, DateTimeFormatter dateTimeFormatter) {
        try {
            return LocalDateTime.parse(ifModifiedSinceHeader, dateTimeFormatter).toInstant(ZoneOffset.UTC);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }

    protected void push(HttpServletRequest request) {
        this.pushBuilder.push(request, this.pushItems.toArray(new PushItem[0]));
    }

    public PushHeaderItem push(List<PushItem> pushItems) {
        RequestCycle requestCycle = RequestCycle.get();
        if (this.isHttp2(this.getContainerRequest(requestCycle.getRequest()))) {
            for (PushItem pushItem : pushItems) {
                String filterPath;
                Object url;
                Object object = pushItem.getObject();
                PageParameters parameters = pushItem.getPageParameters();
                if (object == null) {
                    throw new WicketRuntimeException("Please provide an object to the items to be pushed, so that the url can be created for the given resource.");
                }
                if (object instanceof ResourceReference) {
                    url = requestCycle.urlFor((ResourceReference)object, parameters);
                } else if (Page.class.isAssignableFrom(object.getClass())) {
                    url = requestCycle.urlFor((Class)object, parameters);
                } else if (object instanceof IRequestHandler) {
                    url = requestCycle.urlFor((IRequestHandler)object);
                } else if (pushItem.getUrl() != null) {
                    url = pushItem.getUrl();
                } else {
                    Url encoded = new PageParametersEncoder().encodePageParameters(parameters);
                    String queryString = encoded.getQueryString();
                    url = object.toString() + (String)(queryString != null ? "?" + queryString : "");
                }
                if (url.toString().equals(".")) {
                    url = "/";
                } else if (url.toString().startsWith(".")) {
                    url = url.toString().substring(1);
                }
                StringBuilder partialUrl = new StringBuilder();
                String contextPath = WebApplication.get().getServletContext().getContextPath();
                partialUrl.append(contextPath);
                if (!"/".equals(contextPath)) {
                    partialUrl.append('/');
                }
                if ("/".equals(filterPath = WebApplication.get().getWicketFilter().getFilterPath())) {
                    filterPath = "";
                } else if (filterPath.endsWith("/")) {
                    filterPath = filterPath.substring(0, filterPath.length() - 1);
                }
                partialUrl.append(filterPath);
                partialUrl.append((CharSequence)url);
                pushItem.setUrl(partialUrl.toString());
                this.pushItems.add(pushItem);
            }
        }
        return this;
    }

    public HttpServletRequest getContainerRequest(Request request) {
        return this.checkHttpServletRequest(request);
    }

    public boolean isHttp2(HttpServletRequest request) {
        return request.getProtocol().toLowerCase(Locale.ROOT).contains(HTTP2_PROTOCOL);
    }

    public HttpServletRequest checkHttpServletRequest(Request request) {
        Object assumedHttpServletRequest = request.getContainerRequest();
        if (!(assumedHttpServletRequest instanceof HttpServletRequest)) {
            throw new WicketRuntimeException("The request is not a HttpServletRequest - the usage of PushHeaderItem is not support in the current environment: " + request.getClass().getName());
        }
        return (HttpServletRequest)assumedHttpServletRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushHeaderItem that = (PushHeaderItem)o;
        return Objects.equals(this.pushItems, that.pushItems) && Objects.equals(this.pageWebResponse, that.pageWebResponse) && Objects.equals(this.pageWebRequest, that.pageWebRequest) && Objects.equals(this.page, that.page);
    }

    public int hashCode() {
        return Objects.hash(this.pushItems, this.pageWebResponse, this.pageWebRequest, this.page);
    }
}

