/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheSyncListenerCompleter;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.cache.impl.ClientCacheProxySupport;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

class ClientCacheProxySyncListenerCompleter
extends AbstractCacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    private final ClientCacheProxySupport clientCacheProxy;

    ClientCacheProxySyncListenerCompleter(ClientCacheProxySupport clientCacheProxy) {
        this.clientCacheProxy = clientCacheProxy;
    }

    @Override
    protected void awaitLatch(CountDownLatch countDownLatch, InternalCompletableFuture future) throws ExecutionException {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                if (future != null && future.isDone()) {
                    future.get();
                }
                if (!this.clientCacheProxy.getContext().isActive()) {
                    throw new HazelcastClientNotActiveException();
                }
                if (!this.clientCacheProxy.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.clientCacheProxy.getPrefixedName() + ") is closed!");
            }
            if (countDownLatch.getCount() > 0L) {
                this.clientCacheProxy.getLogger().finest("Countdown latch wait timeout after " + MAX_COMPLETION_LATCH_WAIT_TIME + " milliseconds!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ExceptionUtil.sneakyThrow(e);
        }
    }
}

