/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.function;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface BiPredicateEx<T, U>
extends BiPredicate<T, U>,
Serializable {
    public boolean testEx(T var1, U var2) throws Exception;

    @Override
    default public boolean test(T t, U u) {
        try {
            return this.testEx(t, u);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    default public BiPredicateEx<T, U> and(BiPredicateEx<? super T, ? super U> other) {
        Preconditions.checkNotNull(other, "other");
        return (t, u) -> this.test(t, u) && other.test(t, u);
    }

    @Override
    default public BiPredicateEx<T, U> negate() {
        return (t, u) -> !this.test(t, u);
    }

    @Override
    default public BiPredicateEx<T, U> or(BiPredicateEx<? super T, ? super U> other) {
        Preconditions.checkNotNull(other, "other");
        return (t, u) -> this.test(t, u) || other.test(t, u);
    }
}

