/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import javax.annotation.Nonnull;

public class GlobalMapStatefulTransform<T, S, R>
extends AbstractTransform {
    private static final long serialVersionUID = 1L;
    private final ToLongFunctionEx<? super T> timestampFn;
    private final SupplierEx<? extends S> createFn;
    private final TriFunction<? super S, Object, ? super T, ? extends R> statefulMapFn;

    public GlobalMapStatefulTransform(@Nonnull Transform upstream, @Nonnull ToLongFunctionEx<? super T> timestampFn, @Nonnull SupplierEx<? extends S> createFn, @Nonnull TriFunction<? super S, Object, ? super T, ? extends R> statefulMapFn) {
        super("map-stateful-global", upstream);
        this.timestampFn = timestampFn;
        this.createFn = createFn;
        this.statefulMapFn = statefulMapFn;
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        this.determinedLocalParallelism(1);
        ConstantFunctionEx keyFn = new ConstantFunctionEx(this.name().hashCode());
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), Processors.mapStatefulP(Long.MAX_VALUE, keyFn, this.timestampFn, this.createFn, this.statefulMapFn, null));
        p.addEdges((Transform)this, pv.v, edge -> edge.partitioned(keyFn).distributed());
    }
}

