/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.test;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.pipeline.test.AssertionP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import javax.annotation.Nonnull;

public final class AssertionSinkBuilder<S, T> {
    private final SupplierEx<? extends S> createFn;
    private final String name;
    private BiConsumerEx<? super S, ? super T> receiveFn;
    private ConsumerEx<? super S> timerFn = ConsumerEx.noop();
    private ConsumerEx<? super S> completeFn = ConsumerEx.noop();

    private AssertionSinkBuilder(@Nonnull String name, @Nonnull SupplierEx<? extends S> createFn) {
        Util.checkSerializable(createFn, "createFn");
        this.name = name;
        this.createFn = createFn;
    }

    @Nonnull
    public static <S> AssertionSinkBuilder<S, Void> assertionSink(@Nonnull String name, @Nonnull SupplierEx<? extends S> createFn) {
        return new AssertionSinkBuilder(name, createFn);
    }

    @Nonnull
    public <T_NEW> AssertionSinkBuilder<S, T_NEW> receiveFn(@Nonnull BiConsumerEx<? super S, ? super T_NEW> receiveFn) {
        Util.checkSerializable(receiveFn, "receiveFn");
        AssertionSinkBuilder newThis = this;
        newThis.receiveFn = receiveFn;
        return newThis;
    }

    @Nonnull
    public AssertionSinkBuilder<S, T> timerFn(@Nonnull ConsumerEx<? super S> timerFn) {
        Util.checkSerializable(timerFn, "timerFn");
        this.timerFn = timerFn;
        return this;
    }

    @Nonnull
    public AssertionSinkBuilder<S, T> completeFn(@Nonnull ConsumerEx<? super S> completeFn) {
        Util.checkSerializable(completeFn, "completeFn");
        this.completeFn = completeFn;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        Preconditions.checkNotNull(this.receiveFn, "receiveFn must be set");
        return new SinkImpl(this.name, AssertionP.assertionP(this.name, this.createFn, this.receiveFn, this.timerFn, this.completeFn), SinkImpl.Type.TOTAL_PARALLELISM_ONE);
    }
}

