/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.operation.steps.RemoveIfSameOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class RemoveIfSameOperation
extends BaseRemoveOperation {
    private Data expect;
    private boolean successful;

    public RemoveIfSameOperation() {
    }

    public RemoveIfSameOperation(String name, Data dataKey, Data value) {
        super(name, dataKey);
        this.expect = value;
    }

    @Override
    protected void runInternal() {
        this.successful = this.recordStore.remove(this.dataKey, this.expect);
    }

    @Override
    public void afterRunInternal() {
        if (this.successful) {
            this.dataOldValue = this.expect;
            super.afterRunInternal();
        }
    }

    @Override
    public State createState() {
        return super.createState().setExpect(this.expect);
    }

    @Override
    public void applyState(State state) {
        super.applyState(state);
        this.successful = (Boolean)state.getResult();
        if (this.successful) {
            this.dataOldValue = this.getOldValue(state);
        }
    }

    @Override
    protected Data getOldValue(State state) {
        if (this.successful) {
            this.dataOldValue = this.mapServiceContext.toData(state.getOldValue());
        }
        return null;
    }

    @Override
    public Step getStartingStep() {
        return RemoveIfSameOpSteps.READ;
    }

    @Override
    public Object getResponse() {
        return this.successful;
    }

    @Override
    public boolean shouldBackup() {
        return this.successful;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.expect);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expect = IOUtil.readData(in);
    }

    @Override
    public int getClassId() {
        return 23;
    }
}

