/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const AdsDiscoveryBlockAmsNetId_AMSNETIDLENGTH uint16 = 0x0006

// AdsDiscoveryBlockAmsNetId is the corresponding interface of AdsDiscoveryBlockAmsNetId
type AdsDiscoveryBlockAmsNetId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AdsDiscoveryBlock
	// GetAmsNetId returns AmsNetId (property field)
	GetAmsNetId() AmsNetId
	// IsAdsDiscoveryBlockAmsNetId is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAdsDiscoveryBlockAmsNetId()
	// CreateBuilder creates a AdsDiscoveryBlockAmsNetIdBuilder
	CreateAdsDiscoveryBlockAmsNetIdBuilder() AdsDiscoveryBlockAmsNetIdBuilder
}

// _AdsDiscoveryBlockAmsNetId is the data-structure of this message
type _AdsDiscoveryBlockAmsNetId struct {
	AdsDiscoveryBlockContract
	AmsNetId AmsNetId
}

var _ AdsDiscoveryBlockAmsNetId = (*_AdsDiscoveryBlockAmsNetId)(nil)
var _ AdsDiscoveryBlockRequirements = (*_AdsDiscoveryBlockAmsNetId)(nil)

// NewAdsDiscoveryBlockAmsNetId factory function for _AdsDiscoveryBlockAmsNetId
func NewAdsDiscoveryBlockAmsNetId(amsNetId AmsNetId) *_AdsDiscoveryBlockAmsNetId {
	if amsNetId == nil {
		panic("amsNetId of type AmsNetId for AdsDiscoveryBlockAmsNetId must not be nil")
	}
	_result := &_AdsDiscoveryBlockAmsNetId{
		AdsDiscoveryBlockContract: NewAdsDiscoveryBlock(),
		AmsNetId:                  amsNetId,
	}
	_result.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AdsDiscoveryBlockAmsNetIdBuilder is a builder for AdsDiscoveryBlockAmsNetId
type AdsDiscoveryBlockAmsNetIdBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(amsNetId AmsNetId) AdsDiscoveryBlockAmsNetIdBuilder
	// WithAmsNetId adds AmsNetId (property field)
	WithAmsNetId(AmsNetId) AdsDiscoveryBlockAmsNetIdBuilder
	// WithAmsNetIdBuilder adds AmsNetId (property field) which is build by the builder
	WithAmsNetIdBuilder(func(AmsNetIdBuilder) AmsNetIdBuilder) AdsDiscoveryBlockAmsNetIdBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AdsDiscoveryBlockBuilder
	// Build builds the AdsDiscoveryBlockAmsNetId or returns an error if something is wrong
	Build() (AdsDiscoveryBlockAmsNetId, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AdsDiscoveryBlockAmsNetId
}

// NewAdsDiscoveryBlockAmsNetIdBuilder() creates a AdsDiscoveryBlockAmsNetIdBuilder
func NewAdsDiscoveryBlockAmsNetIdBuilder() AdsDiscoveryBlockAmsNetIdBuilder {
	return &_AdsDiscoveryBlockAmsNetIdBuilder{_AdsDiscoveryBlockAmsNetId: new(_AdsDiscoveryBlockAmsNetId)}
}

type _AdsDiscoveryBlockAmsNetIdBuilder struct {
	*_AdsDiscoveryBlockAmsNetId

	parentBuilder *_AdsDiscoveryBlockBuilder

	collectedErr []error
}

var _ (AdsDiscoveryBlockAmsNetIdBuilder) = (*_AdsDiscoveryBlockAmsNetIdBuilder)(nil)

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) setParent(contract AdsDiscoveryBlockContract) {
	b.AdsDiscoveryBlockContract = contract
	contract.(*_AdsDiscoveryBlock)._SubType = b._AdsDiscoveryBlockAmsNetId
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) WithMandatoryFields(amsNetId AmsNetId) AdsDiscoveryBlockAmsNetIdBuilder {
	return b.WithAmsNetId(amsNetId)
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) WithAmsNetId(amsNetId AmsNetId) AdsDiscoveryBlockAmsNetIdBuilder {
	b.AmsNetId = amsNetId
	return b
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) WithAmsNetIdBuilder(builderSupplier func(AmsNetIdBuilder) AmsNetIdBuilder) AdsDiscoveryBlockAmsNetIdBuilder {
	builder := builderSupplier(b.AmsNetId.CreateAmsNetIdBuilder())
	var err error
	b.AmsNetId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "AmsNetIdBuilder failed"))
	}
	return b
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) Build() (AdsDiscoveryBlockAmsNetId, error) {
	if b.AmsNetId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'amsNetId' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AdsDiscoveryBlockAmsNetId.deepCopy(), nil
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) MustBuild() AdsDiscoveryBlockAmsNetId {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) Done() AdsDiscoveryBlockBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAdsDiscoveryBlockBuilder().(*_AdsDiscoveryBlockBuilder)
	}
	return b.parentBuilder
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) buildForAdsDiscoveryBlock() (AdsDiscoveryBlock, error) {
	return b.Build()
}

func (b *_AdsDiscoveryBlockAmsNetIdBuilder) DeepCopy() any {
	_copy := b.CreateAdsDiscoveryBlockAmsNetIdBuilder().(*_AdsDiscoveryBlockAmsNetIdBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAdsDiscoveryBlockAmsNetIdBuilder creates a AdsDiscoveryBlockAmsNetIdBuilder
func (b *_AdsDiscoveryBlockAmsNetId) CreateAdsDiscoveryBlockAmsNetIdBuilder() AdsDiscoveryBlockAmsNetIdBuilder {
	if b == nil {
		return NewAdsDiscoveryBlockAmsNetIdBuilder()
	}
	return &_AdsDiscoveryBlockAmsNetIdBuilder{_AdsDiscoveryBlockAmsNetId: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdsDiscoveryBlockAmsNetId) GetBlockType() AdsDiscoveryBlockType {
	return AdsDiscoveryBlockType_AMS_NET_ID
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdsDiscoveryBlockAmsNetId) GetParent() AdsDiscoveryBlockContract {
	return m.AdsDiscoveryBlockContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdsDiscoveryBlockAmsNetId) GetAmsNetId() AmsNetId {
	return m.AmsNetId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_AdsDiscoveryBlockAmsNetId) GetAmsNetIdLength() uint16 {
	return AdsDiscoveryBlockAmsNetId_AMSNETIDLENGTH
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAdsDiscoveryBlockAmsNetId(structType any) AdsDiscoveryBlockAmsNetId {
	if casted, ok := structType.(AdsDiscoveryBlockAmsNetId); ok {
		return casted
	}
	if casted, ok := structType.(*AdsDiscoveryBlockAmsNetId); ok {
		return *casted
	}
	return nil
}

func (m *_AdsDiscoveryBlockAmsNetId) GetTypeName() string {
	return "AdsDiscoveryBlockAmsNetId"
}

func (m *_AdsDiscoveryBlockAmsNetId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock).getLengthInBits(ctx))

	// Const Field (amsNetIdLength)
	lengthInBits += 16

	// Simple field (amsNetId)
	lengthInBits += m.AmsNetId.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AdsDiscoveryBlockAmsNetId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AdsDiscoveryBlockAmsNetId) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AdsDiscoveryBlock) (__adsDiscoveryBlockAmsNetId AdsDiscoveryBlockAmsNetId, err error) {
	m.AdsDiscoveryBlockContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AdsDiscoveryBlockAmsNetId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsDiscoveryBlockAmsNetId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	amsNetIdLength, err := ReadConstField[uint16](ctx, "amsNetIdLength", ReadUnsignedShort(readBuffer, uint8(16)), AdsDiscoveryBlockAmsNetId_AMSNETIDLENGTH)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'amsNetIdLength' field"))
	}
	_ = amsNetIdLength

	amsNetId, err := ReadSimpleField[AmsNetId](ctx, "amsNetId", ReadComplex[AmsNetId](AmsNetIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'amsNetId' field"))
	}
	m.AmsNetId = amsNetId

	if closeErr := readBuffer.CloseContext("AdsDiscoveryBlockAmsNetId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsDiscoveryBlockAmsNetId")
	}

	return m, nil
}

func (m *_AdsDiscoveryBlockAmsNetId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsDiscoveryBlockAmsNetId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdsDiscoveryBlockAmsNetId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdsDiscoveryBlockAmsNetId")
		}

		if err := WriteConstField(ctx, "amsNetIdLength", AdsDiscoveryBlockAmsNetId_AMSNETIDLENGTH, WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'amsNetIdLength' field")
		}

		if err := WriteSimpleField[AmsNetId](ctx, "amsNetId", m.GetAmsNetId(), WriteComplex[AmsNetId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'amsNetId' field")
		}

		if popErr := writeBuffer.PopContext("AdsDiscoveryBlockAmsNetId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdsDiscoveryBlockAmsNetId")
		}
		return nil
	}
	return m.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdsDiscoveryBlockAmsNetId) IsAdsDiscoveryBlockAmsNetId() {}

func (m *_AdsDiscoveryBlockAmsNetId) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AdsDiscoveryBlockAmsNetId) deepCopy() *_AdsDiscoveryBlockAmsNetId {
	if m == nil {
		return nil
	}
	_AdsDiscoveryBlockAmsNetIdCopy := &_AdsDiscoveryBlockAmsNetId{
		m.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock).deepCopy(),
		utils.DeepCopy[AmsNetId](m.AmsNetId),
	}
	_AdsDiscoveryBlockAmsNetIdCopy.AdsDiscoveryBlockContract.(*_AdsDiscoveryBlock)._SubType = m
	return _AdsDiscoveryBlockAmsNetIdCopy
}

func (m *_AdsDiscoveryBlockAmsNetId) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
