/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDeviceType is the corresponding interface of BACnetConstructedDataDeviceType
type BACnetConstructedDataDeviceType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDeviceType returns DeviceType (property field)
	GetDeviceType() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
	// IsBACnetConstructedDataDeviceType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDeviceType()
	// CreateBuilder creates a BACnetConstructedDataDeviceTypeBuilder
	CreateBACnetConstructedDataDeviceTypeBuilder() BACnetConstructedDataDeviceTypeBuilder
}

// _BACnetConstructedDataDeviceType is the data-structure of this message
type _BACnetConstructedDataDeviceType struct {
	BACnetConstructedDataContract
	DeviceType BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataDeviceType = (*_BACnetConstructedDataDeviceType)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDeviceType)(nil)

// NewBACnetConstructedDataDeviceType factory function for _BACnetConstructedDataDeviceType
func NewBACnetConstructedDataDeviceType(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, deviceType BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDeviceType {
	if deviceType == nil {
		panic("deviceType of type BACnetApplicationTagCharacterString for BACnetConstructedDataDeviceType must not be nil")
	}
	_result := &_BACnetConstructedDataDeviceType{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DeviceType:                    deviceType,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDeviceTypeBuilder is a builder for BACnetConstructedDataDeviceType
type BACnetConstructedDataDeviceTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(deviceType BACnetApplicationTagCharacterString) BACnetConstructedDataDeviceTypeBuilder
	// WithDeviceType adds DeviceType (property field)
	WithDeviceType(BACnetApplicationTagCharacterString) BACnetConstructedDataDeviceTypeBuilder
	// WithDeviceTypeBuilder adds DeviceType (property field) which is build by the builder
	WithDeviceTypeBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataDeviceTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDeviceType or returns an error if something is wrong
	Build() (BACnetConstructedDataDeviceType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDeviceType
}

// NewBACnetConstructedDataDeviceTypeBuilder() creates a BACnetConstructedDataDeviceTypeBuilder
func NewBACnetConstructedDataDeviceTypeBuilder() BACnetConstructedDataDeviceTypeBuilder {
	return &_BACnetConstructedDataDeviceTypeBuilder{_BACnetConstructedDataDeviceType: new(_BACnetConstructedDataDeviceType)}
}

type _BACnetConstructedDataDeviceTypeBuilder struct {
	*_BACnetConstructedDataDeviceType

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDeviceTypeBuilder) = (*_BACnetConstructedDataDeviceTypeBuilder)(nil)

func (b *_BACnetConstructedDataDeviceTypeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDeviceType
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) WithMandatoryFields(deviceType BACnetApplicationTagCharacterString) BACnetConstructedDataDeviceTypeBuilder {
	return b.WithDeviceType(deviceType)
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) WithDeviceType(deviceType BACnetApplicationTagCharacterString) BACnetConstructedDataDeviceTypeBuilder {
	b.DeviceType = deviceType
	return b
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) WithDeviceTypeBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataDeviceTypeBuilder {
	builder := builderSupplier(b.DeviceType.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.DeviceType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) Build() (BACnetConstructedDataDeviceType, error) {
	if b.DeviceType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'deviceType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDeviceType.deepCopy(), nil
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) MustBuild() BACnetConstructedDataDeviceType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDeviceTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDeviceTypeBuilder().(*_BACnetConstructedDataDeviceTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDeviceTypeBuilder creates a BACnetConstructedDataDeviceTypeBuilder
func (b *_BACnetConstructedDataDeviceType) CreateBACnetConstructedDataDeviceTypeBuilder() BACnetConstructedDataDeviceTypeBuilder {
	if b == nil {
		return NewBACnetConstructedDataDeviceTypeBuilder()
	}
	return &_BACnetConstructedDataDeviceTypeBuilder{_BACnetConstructedDataDeviceType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDeviceType) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDeviceType) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DEVICE_TYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDeviceType) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDeviceType) GetDeviceType() BACnetApplicationTagCharacterString {
	return m.DeviceType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDeviceType) GetActualValue() BACnetApplicationTagCharacterString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagCharacterString(m.GetDeviceType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDeviceType(structType any) BACnetConstructedDataDeviceType {
	if casted, ok := structType.(BACnetConstructedDataDeviceType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDeviceType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDeviceType) GetTypeName() string {
	return "BACnetConstructedDataDeviceType"
}

func (m *_BACnetConstructedDataDeviceType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (deviceType)
	lengthInBits += m.DeviceType.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDeviceType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDeviceType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDeviceType BACnetConstructedDataDeviceType, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDeviceType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDeviceType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	deviceType, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "deviceType", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceType' field"))
	}
	m.DeviceType = deviceType

	actualValue, err := ReadVirtualField[BACnetApplicationTagCharacterString](ctx, "actualValue", (*BACnetApplicationTagCharacterString)(nil), deviceType)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDeviceType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDeviceType")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDeviceType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDeviceType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDeviceType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDeviceType")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "deviceType", m.GetDeviceType(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deviceType' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDeviceType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDeviceType")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDeviceType) IsBACnetConstructedDataDeviceType() {}

func (m *_BACnetConstructedDataDeviceType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDeviceType) deepCopy() *_BACnetConstructedDataDeviceType {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDeviceTypeCopy := &_BACnetConstructedDataDeviceType{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.DeviceType),
	}
	_BACnetConstructedDataDeviceTypeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDeviceTypeCopy
}

func (m *_BACnetConstructedDataDeviceType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
