/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataIPAddress is the corresponding interface of BACnetConstructedDataIPAddress
type BACnetConstructedDataIPAddress interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetIpAddress returns IpAddress (property field)
	GetIpAddress() BACnetApplicationTagOctetString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagOctetString
	// IsBACnetConstructedDataIPAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataIPAddress()
	// CreateBuilder creates a BACnetConstructedDataIPAddressBuilder
	CreateBACnetConstructedDataIPAddressBuilder() BACnetConstructedDataIPAddressBuilder
}

// _BACnetConstructedDataIPAddress is the data-structure of this message
type _BACnetConstructedDataIPAddress struct {
	BACnetConstructedDataContract
	IpAddress BACnetApplicationTagOctetString
}

var _ BACnetConstructedDataIPAddress = (*_BACnetConstructedDataIPAddress)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataIPAddress)(nil)

// NewBACnetConstructedDataIPAddress factory function for _BACnetConstructedDataIPAddress
func NewBACnetConstructedDataIPAddress(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, ipAddress BACnetApplicationTagOctetString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataIPAddress {
	if ipAddress == nil {
		panic("ipAddress of type BACnetApplicationTagOctetString for BACnetConstructedDataIPAddress must not be nil")
	}
	_result := &_BACnetConstructedDataIPAddress{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		IpAddress:                     ipAddress,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataIPAddressBuilder is a builder for BACnetConstructedDataIPAddress
type BACnetConstructedDataIPAddressBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(ipAddress BACnetApplicationTagOctetString) BACnetConstructedDataIPAddressBuilder
	// WithIpAddress adds IpAddress (property field)
	WithIpAddress(BACnetApplicationTagOctetString) BACnetConstructedDataIPAddressBuilder
	// WithIpAddressBuilder adds IpAddress (property field) which is build by the builder
	WithIpAddressBuilder(func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetConstructedDataIPAddressBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataIPAddress or returns an error if something is wrong
	Build() (BACnetConstructedDataIPAddress, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataIPAddress
}

// NewBACnetConstructedDataIPAddressBuilder() creates a BACnetConstructedDataIPAddressBuilder
func NewBACnetConstructedDataIPAddressBuilder() BACnetConstructedDataIPAddressBuilder {
	return &_BACnetConstructedDataIPAddressBuilder{_BACnetConstructedDataIPAddress: new(_BACnetConstructedDataIPAddress)}
}

type _BACnetConstructedDataIPAddressBuilder struct {
	*_BACnetConstructedDataIPAddress

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataIPAddressBuilder) = (*_BACnetConstructedDataIPAddressBuilder)(nil)

func (b *_BACnetConstructedDataIPAddressBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataIPAddress
}

func (b *_BACnetConstructedDataIPAddressBuilder) WithMandatoryFields(ipAddress BACnetApplicationTagOctetString) BACnetConstructedDataIPAddressBuilder {
	return b.WithIpAddress(ipAddress)
}

func (b *_BACnetConstructedDataIPAddressBuilder) WithIpAddress(ipAddress BACnetApplicationTagOctetString) BACnetConstructedDataIPAddressBuilder {
	b.IpAddress = ipAddress
	return b
}

func (b *_BACnetConstructedDataIPAddressBuilder) WithIpAddressBuilder(builderSupplier func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetConstructedDataIPAddressBuilder {
	builder := builderSupplier(b.IpAddress.CreateBACnetApplicationTagOctetStringBuilder())
	var err error
	b.IpAddress, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagOctetStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataIPAddressBuilder) Build() (BACnetConstructedDataIPAddress, error) {
	if b.IpAddress == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ipAddress' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataIPAddress.deepCopy(), nil
}

func (b *_BACnetConstructedDataIPAddressBuilder) MustBuild() BACnetConstructedDataIPAddress {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataIPAddressBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataIPAddressBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataIPAddressBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataIPAddressBuilder().(*_BACnetConstructedDataIPAddressBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataIPAddressBuilder creates a BACnetConstructedDataIPAddressBuilder
func (b *_BACnetConstructedDataIPAddress) CreateBACnetConstructedDataIPAddressBuilder() BACnetConstructedDataIPAddressBuilder {
	if b == nil {
		return NewBACnetConstructedDataIPAddressBuilder()
	}
	return &_BACnetConstructedDataIPAddressBuilder{_BACnetConstructedDataIPAddress: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataIPAddress) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataIPAddress) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_IP_ADDRESS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataIPAddress) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataIPAddress) GetIpAddress() BACnetApplicationTagOctetString {
	return m.IpAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataIPAddress) GetActualValue() BACnetApplicationTagOctetString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagOctetString(m.GetIpAddress())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataIPAddress(structType any) BACnetConstructedDataIPAddress {
	if casted, ok := structType.(BACnetConstructedDataIPAddress); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataIPAddress); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataIPAddress) GetTypeName() string {
	return "BACnetConstructedDataIPAddress"
}

func (m *_BACnetConstructedDataIPAddress) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (ipAddress)
	lengthInBits += m.IpAddress.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataIPAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataIPAddress) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataIPAddress BACnetConstructedDataIPAddress, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataIPAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataIPAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	ipAddress, err := ReadSimpleField[BACnetApplicationTagOctetString](ctx, "ipAddress", ReadComplex[BACnetApplicationTagOctetString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagOctetString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ipAddress' field"))
	}
	m.IpAddress = ipAddress

	actualValue, err := ReadVirtualField[BACnetApplicationTagOctetString](ctx, "actualValue", (*BACnetApplicationTagOctetString)(nil), ipAddress)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataIPAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataIPAddress")
	}

	return m, nil
}

func (m *_BACnetConstructedDataIPAddress) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataIPAddress) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataIPAddress"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataIPAddress")
		}

		if err := WriteSimpleField[BACnetApplicationTagOctetString](ctx, "ipAddress", m.GetIpAddress(), WriteComplex[BACnetApplicationTagOctetString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'ipAddress' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataIPAddress"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataIPAddress")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataIPAddress) IsBACnetConstructedDataIPAddress() {}

func (m *_BACnetConstructedDataIPAddress) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataIPAddress) deepCopy() *_BACnetConstructedDataIPAddress {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataIPAddressCopy := &_BACnetConstructedDataIPAddress{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagOctetString](m.IpAddress),
	}
	_BACnetConstructedDataIPAddressCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataIPAddressCopy
}

func (m *_BACnetConstructedDataIPAddress) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
