/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLightingOutputAll is the corresponding interface of BACnetConstructedDataLightingOutputAll
type BACnetConstructedDataLightingOutputAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataLightingOutputAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLightingOutputAll()
	// CreateBuilder creates a BACnetConstructedDataLightingOutputAllBuilder
	CreateBACnetConstructedDataLightingOutputAllBuilder() BACnetConstructedDataLightingOutputAllBuilder
}

// _BACnetConstructedDataLightingOutputAll is the data-structure of this message
type _BACnetConstructedDataLightingOutputAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataLightingOutputAll = (*_BACnetConstructedDataLightingOutputAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLightingOutputAll)(nil)

// NewBACnetConstructedDataLightingOutputAll factory function for _BACnetConstructedDataLightingOutputAll
func NewBACnetConstructedDataLightingOutputAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLightingOutputAll {
	_result := &_BACnetConstructedDataLightingOutputAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLightingOutputAllBuilder is a builder for BACnetConstructedDataLightingOutputAll
type BACnetConstructedDataLightingOutputAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataLightingOutputAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLightingOutputAll or returns an error if something is wrong
	Build() (BACnetConstructedDataLightingOutputAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLightingOutputAll
}

// NewBACnetConstructedDataLightingOutputAllBuilder() creates a BACnetConstructedDataLightingOutputAllBuilder
func NewBACnetConstructedDataLightingOutputAllBuilder() BACnetConstructedDataLightingOutputAllBuilder {
	return &_BACnetConstructedDataLightingOutputAllBuilder{_BACnetConstructedDataLightingOutputAll: new(_BACnetConstructedDataLightingOutputAll)}
}

type _BACnetConstructedDataLightingOutputAllBuilder struct {
	*_BACnetConstructedDataLightingOutputAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLightingOutputAllBuilder) = (*_BACnetConstructedDataLightingOutputAllBuilder)(nil)

func (b *_BACnetConstructedDataLightingOutputAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLightingOutputAll
}

func (b *_BACnetConstructedDataLightingOutputAllBuilder) WithMandatoryFields() BACnetConstructedDataLightingOutputAllBuilder {
	return b
}

func (b *_BACnetConstructedDataLightingOutputAllBuilder) Build() (BACnetConstructedDataLightingOutputAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLightingOutputAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataLightingOutputAllBuilder) MustBuild() BACnetConstructedDataLightingOutputAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLightingOutputAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLightingOutputAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLightingOutputAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLightingOutputAllBuilder().(*_BACnetConstructedDataLightingOutputAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLightingOutputAllBuilder creates a BACnetConstructedDataLightingOutputAllBuilder
func (b *_BACnetConstructedDataLightingOutputAll) CreateBACnetConstructedDataLightingOutputAllBuilder() BACnetConstructedDataLightingOutputAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataLightingOutputAllBuilder()
	}
	return &_BACnetConstructedDataLightingOutputAllBuilder{_BACnetConstructedDataLightingOutputAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLightingOutputAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_LIGHTING_OUTPUT
}

func (m *_BACnetConstructedDataLightingOutputAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLightingOutputAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLightingOutputAll(structType any) BACnetConstructedDataLightingOutputAll {
	if casted, ok := structType.(BACnetConstructedDataLightingOutputAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLightingOutputAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLightingOutputAll) GetTypeName() string {
	return "BACnetConstructedDataLightingOutputAll"
}

func (m *_BACnetConstructedDataLightingOutputAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataLightingOutputAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLightingOutputAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLightingOutputAll BACnetConstructedDataLightingOutputAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLightingOutputAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLightingOutputAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLightingOutputAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLightingOutputAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLightingOutputAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLightingOutputAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLightingOutputAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLightingOutputAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLightingOutputAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLightingOutputAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLightingOutputAll) IsBACnetConstructedDataLightingOutputAll() {}

func (m *_BACnetConstructedDataLightingOutputAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLightingOutputAll) deepCopy() *_BACnetConstructedDataLightingOutputAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLightingOutputAllCopy := &_BACnetConstructedDataLightingOutputAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataLightingOutputAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLightingOutputAllCopy
}

func (m *_BACnetConstructedDataLightingOutputAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
