/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataListOfObjectPropertyReferences is the corresponding interface of BACnetConstructedDataListOfObjectPropertyReferences
type BACnetConstructedDataListOfObjectPropertyReferences interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetReferences returns References (property field)
	GetReferences() []BACnetDeviceObjectPropertyReference
	// IsBACnetConstructedDataListOfObjectPropertyReferences is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataListOfObjectPropertyReferences()
	// CreateBuilder creates a BACnetConstructedDataListOfObjectPropertyReferencesBuilder
	CreateBACnetConstructedDataListOfObjectPropertyReferencesBuilder() BACnetConstructedDataListOfObjectPropertyReferencesBuilder
}

// _BACnetConstructedDataListOfObjectPropertyReferences is the data-structure of this message
type _BACnetConstructedDataListOfObjectPropertyReferences struct {
	BACnetConstructedDataContract
	References []BACnetDeviceObjectPropertyReference
}

var _ BACnetConstructedDataListOfObjectPropertyReferences = (*_BACnetConstructedDataListOfObjectPropertyReferences)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataListOfObjectPropertyReferences)(nil)

// NewBACnetConstructedDataListOfObjectPropertyReferences factory function for _BACnetConstructedDataListOfObjectPropertyReferences
func NewBACnetConstructedDataListOfObjectPropertyReferences(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, references []BACnetDeviceObjectPropertyReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataListOfObjectPropertyReferences {
	_result := &_BACnetConstructedDataListOfObjectPropertyReferences{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		References:                    references,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataListOfObjectPropertyReferencesBuilder is a builder for BACnetConstructedDataListOfObjectPropertyReferences
type BACnetConstructedDataListOfObjectPropertyReferencesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(references []BACnetDeviceObjectPropertyReference) BACnetConstructedDataListOfObjectPropertyReferencesBuilder
	// WithReferences adds References (property field)
	WithReferences(...BACnetDeviceObjectPropertyReference) BACnetConstructedDataListOfObjectPropertyReferencesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataListOfObjectPropertyReferences or returns an error if something is wrong
	Build() (BACnetConstructedDataListOfObjectPropertyReferences, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataListOfObjectPropertyReferences
}

// NewBACnetConstructedDataListOfObjectPropertyReferencesBuilder() creates a BACnetConstructedDataListOfObjectPropertyReferencesBuilder
func NewBACnetConstructedDataListOfObjectPropertyReferencesBuilder() BACnetConstructedDataListOfObjectPropertyReferencesBuilder {
	return &_BACnetConstructedDataListOfObjectPropertyReferencesBuilder{_BACnetConstructedDataListOfObjectPropertyReferences: new(_BACnetConstructedDataListOfObjectPropertyReferences)}
}

type _BACnetConstructedDataListOfObjectPropertyReferencesBuilder struct {
	*_BACnetConstructedDataListOfObjectPropertyReferences

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataListOfObjectPropertyReferencesBuilder) = (*_BACnetConstructedDataListOfObjectPropertyReferencesBuilder)(nil)

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataListOfObjectPropertyReferences
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) WithMandatoryFields(references []BACnetDeviceObjectPropertyReference) BACnetConstructedDataListOfObjectPropertyReferencesBuilder {
	return b.WithReferences(references...)
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) WithReferences(references ...BACnetDeviceObjectPropertyReference) BACnetConstructedDataListOfObjectPropertyReferencesBuilder {
	b.References = references
	return b
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) Build() (BACnetConstructedDataListOfObjectPropertyReferences, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataListOfObjectPropertyReferences.deepCopy(), nil
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) MustBuild() BACnetConstructedDataListOfObjectPropertyReferences {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataListOfObjectPropertyReferencesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataListOfObjectPropertyReferencesBuilder().(*_BACnetConstructedDataListOfObjectPropertyReferencesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataListOfObjectPropertyReferencesBuilder creates a BACnetConstructedDataListOfObjectPropertyReferencesBuilder
func (b *_BACnetConstructedDataListOfObjectPropertyReferences) CreateBACnetConstructedDataListOfObjectPropertyReferencesBuilder() BACnetConstructedDataListOfObjectPropertyReferencesBuilder {
	if b == nil {
		return NewBACnetConstructedDataListOfObjectPropertyReferencesBuilder()
	}
	return &_BACnetConstructedDataListOfObjectPropertyReferencesBuilder{_BACnetConstructedDataListOfObjectPropertyReferences: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetReferences() []BACnetDeviceObjectPropertyReference {
	return m.References
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataListOfObjectPropertyReferences(structType any) BACnetConstructedDataListOfObjectPropertyReferences {
	if casted, ok := structType.(BACnetConstructedDataListOfObjectPropertyReferences); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataListOfObjectPropertyReferences); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetTypeName() string {
	return "BACnetConstructedDataListOfObjectPropertyReferences"
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.References) > 0 {
		for _, element := range m.References {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataListOfObjectPropertyReferences BACnetConstructedDataListOfObjectPropertyReferences, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataListOfObjectPropertyReferences"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataListOfObjectPropertyReferences")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	references, err := ReadTerminatedArrayField[BACnetDeviceObjectPropertyReference](ctx, "references", ReadComplex[BACnetDeviceObjectPropertyReference](BACnetDeviceObjectPropertyReferenceParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'references' field"))
	}
	m.References = references

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataListOfObjectPropertyReferences"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataListOfObjectPropertyReferences")
	}

	return m, nil
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataListOfObjectPropertyReferences"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataListOfObjectPropertyReferences")
		}

		if err := WriteComplexTypeArrayField(ctx, "references", m.GetReferences(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'references' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataListOfObjectPropertyReferences"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataListOfObjectPropertyReferences")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) IsBACnetConstructedDataListOfObjectPropertyReferences() {
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) deepCopy() *_BACnetConstructedDataListOfObjectPropertyReferences {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataListOfObjectPropertyReferencesCopy := &_BACnetConstructedDataListOfObjectPropertyReferences{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetDeviceObjectPropertyReference, BACnetDeviceObjectPropertyReference](m.References),
	}
	_BACnetConstructedDataListOfObjectPropertyReferencesCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataListOfObjectPropertyReferencesCopy
}

func (m *_BACnetConstructedDataListOfObjectPropertyReferences) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
