/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLocation is the corresponding interface of BACnetConstructedDataLocation
type BACnetConstructedDataLocation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLocation returns Location (property field)
	GetLocation() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
	// IsBACnetConstructedDataLocation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLocation()
	// CreateBuilder creates a BACnetConstructedDataLocationBuilder
	CreateBACnetConstructedDataLocationBuilder() BACnetConstructedDataLocationBuilder
}

// _BACnetConstructedDataLocation is the data-structure of this message
type _BACnetConstructedDataLocation struct {
	BACnetConstructedDataContract
	Location BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataLocation = (*_BACnetConstructedDataLocation)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLocation)(nil)

// NewBACnetConstructedDataLocation factory function for _BACnetConstructedDataLocation
func NewBACnetConstructedDataLocation(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, location BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLocation {
	if location == nil {
		panic("location of type BACnetApplicationTagCharacterString for BACnetConstructedDataLocation must not be nil")
	}
	_result := &_BACnetConstructedDataLocation{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Location:                      location,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLocationBuilder is a builder for BACnetConstructedDataLocation
type BACnetConstructedDataLocationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(location BACnetApplicationTagCharacterString) BACnetConstructedDataLocationBuilder
	// WithLocation adds Location (property field)
	WithLocation(BACnetApplicationTagCharacterString) BACnetConstructedDataLocationBuilder
	// WithLocationBuilder adds Location (property field) which is build by the builder
	WithLocationBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataLocationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLocation or returns an error if something is wrong
	Build() (BACnetConstructedDataLocation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLocation
}

// NewBACnetConstructedDataLocationBuilder() creates a BACnetConstructedDataLocationBuilder
func NewBACnetConstructedDataLocationBuilder() BACnetConstructedDataLocationBuilder {
	return &_BACnetConstructedDataLocationBuilder{_BACnetConstructedDataLocation: new(_BACnetConstructedDataLocation)}
}

type _BACnetConstructedDataLocationBuilder struct {
	*_BACnetConstructedDataLocation

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLocationBuilder) = (*_BACnetConstructedDataLocationBuilder)(nil)

func (b *_BACnetConstructedDataLocationBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLocation
}

func (b *_BACnetConstructedDataLocationBuilder) WithMandatoryFields(location BACnetApplicationTagCharacterString) BACnetConstructedDataLocationBuilder {
	return b.WithLocation(location)
}

func (b *_BACnetConstructedDataLocationBuilder) WithLocation(location BACnetApplicationTagCharacterString) BACnetConstructedDataLocationBuilder {
	b.Location = location
	return b
}

func (b *_BACnetConstructedDataLocationBuilder) WithLocationBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataLocationBuilder {
	builder := builderSupplier(b.Location.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.Location, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLocationBuilder) Build() (BACnetConstructedDataLocation, error) {
	if b.Location == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'location' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLocation.deepCopy(), nil
}

func (b *_BACnetConstructedDataLocationBuilder) MustBuild() BACnetConstructedDataLocation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLocationBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLocationBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLocationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLocationBuilder().(*_BACnetConstructedDataLocationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLocationBuilder creates a BACnetConstructedDataLocationBuilder
func (b *_BACnetConstructedDataLocation) CreateBACnetConstructedDataLocationBuilder() BACnetConstructedDataLocationBuilder {
	if b == nil {
		return NewBACnetConstructedDataLocationBuilder()
	}
	return &_BACnetConstructedDataLocationBuilder{_BACnetConstructedDataLocation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLocation) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLocation) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOCATION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLocation) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLocation) GetLocation() BACnetApplicationTagCharacterString {
	return m.Location
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLocation) GetActualValue() BACnetApplicationTagCharacterString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagCharacterString(m.GetLocation())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLocation(structType any) BACnetConstructedDataLocation {
	if casted, ok := structType.(BACnetConstructedDataLocation); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLocation); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLocation) GetTypeName() string {
	return "BACnetConstructedDataLocation"
}

func (m *_BACnetConstructedDataLocation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (location)
	lengthInBits += m.Location.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLocation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLocation) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLocation BACnetConstructedDataLocation, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLocation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLocation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	location, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "location", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'location' field"))
	}
	m.Location = location

	actualValue, err := ReadVirtualField[BACnetApplicationTagCharacterString](ctx, "actualValue", (*BACnetApplicationTagCharacterString)(nil), location)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLocation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLocation")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLocation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLocation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLocation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLocation")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "location", m.GetLocation(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'location' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLocation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLocation")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLocation) IsBACnetConstructedDataLocation() {}

func (m *_BACnetConstructedDataLocation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLocation) deepCopy() *_BACnetConstructedDataLocation {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLocationCopy := &_BACnetConstructedDataLocation{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.Location),
	}
	_BACnetConstructedDataLocationCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLocationCopy
}

func (m *_BACnetConstructedDataLocation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
