/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventSummariesList is the corresponding interface of BACnetEventSummariesList
type BACnetEventSummariesList interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfEventSummaries returns ListOfEventSummaries (property field)
	GetListOfEventSummaries() []BACnetEventSummary
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetEventSummariesList is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventSummariesList()
	// CreateBuilder creates a BACnetEventSummariesListBuilder
	CreateBACnetEventSummariesListBuilder() BACnetEventSummariesListBuilder
}

// _BACnetEventSummariesList is the data-structure of this message
type _BACnetEventSummariesList struct {
	OpeningTag           BACnetOpeningTag
	ListOfEventSummaries []BACnetEventSummary
	ClosingTag           BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetEventSummariesList = (*_BACnetEventSummariesList)(nil)

// NewBACnetEventSummariesList factory function for _BACnetEventSummariesList
func NewBACnetEventSummariesList(openingTag BACnetOpeningTag, listOfEventSummaries []BACnetEventSummary, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetEventSummariesList {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetEventSummariesList must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetEventSummariesList must not be nil")
	}
	return &_BACnetEventSummariesList{OpeningTag: openingTag, ListOfEventSummaries: listOfEventSummaries, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventSummariesListBuilder is a builder for BACnetEventSummariesList
type BACnetEventSummariesListBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, listOfEventSummaries []BACnetEventSummary, closingTag BACnetClosingTag) BACnetEventSummariesListBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetEventSummariesListBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventSummariesListBuilder
	// WithListOfEventSummaries adds ListOfEventSummaries (property field)
	WithListOfEventSummaries(...BACnetEventSummary) BACnetEventSummariesListBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetEventSummariesListBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventSummariesListBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEventSummariesListBuilder
	// Build builds the BACnetEventSummariesList or returns an error if something is wrong
	Build() (BACnetEventSummariesList, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventSummariesList
}

// NewBACnetEventSummariesListBuilder() creates a BACnetEventSummariesListBuilder
func NewBACnetEventSummariesListBuilder() BACnetEventSummariesListBuilder {
	return &_BACnetEventSummariesListBuilder{_BACnetEventSummariesList: new(_BACnetEventSummariesList)}
}

type _BACnetEventSummariesListBuilder struct {
	*_BACnetEventSummariesList

	collectedErr []error
}

var _ (BACnetEventSummariesListBuilder) = (*_BACnetEventSummariesListBuilder)(nil)

func (b *_BACnetEventSummariesListBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, listOfEventSummaries []BACnetEventSummary, closingTag BACnetClosingTag) BACnetEventSummariesListBuilder {
	return b.WithOpeningTag(openingTag).WithListOfEventSummaries(listOfEventSummaries...).WithClosingTag(closingTag)
}

func (b *_BACnetEventSummariesListBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetEventSummariesListBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetEventSummariesListBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventSummariesListBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummariesListBuilder) WithListOfEventSummaries(listOfEventSummaries ...BACnetEventSummary) BACnetEventSummariesListBuilder {
	b.ListOfEventSummaries = listOfEventSummaries
	return b
}

func (b *_BACnetEventSummariesListBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetEventSummariesListBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetEventSummariesListBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventSummariesListBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventSummariesListBuilder) WithArgTagNumber(tagNumber uint8) BACnetEventSummariesListBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetEventSummariesListBuilder) Build() (BACnetEventSummariesList, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventSummariesList.deepCopy(), nil
}

func (b *_BACnetEventSummariesListBuilder) MustBuild() BACnetEventSummariesList {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventSummariesListBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventSummariesListBuilder().(*_BACnetEventSummariesListBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventSummariesListBuilder creates a BACnetEventSummariesListBuilder
func (b *_BACnetEventSummariesList) CreateBACnetEventSummariesListBuilder() BACnetEventSummariesListBuilder {
	if b == nil {
		return NewBACnetEventSummariesListBuilder()
	}
	return &_BACnetEventSummariesListBuilder{_BACnetEventSummariesList: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventSummariesList) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetEventSummariesList) GetListOfEventSummaries() []BACnetEventSummary {
	return m.ListOfEventSummaries
}

func (m *_BACnetEventSummariesList) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventSummariesList(structType any) BACnetEventSummariesList {
	if casted, ok := structType.(BACnetEventSummariesList); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventSummariesList); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventSummariesList) GetTypeName() string {
	return "BACnetEventSummariesList"
}

func (m *_BACnetEventSummariesList) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfEventSummaries) > 0 {
		for _, element := range m.ListOfEventSummaries {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventSummariesList) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventSummariesListParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetEventSummariesList, error) {
	return BACnetEventSummariesListParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetEventSummariesListParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventSummariesList, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventSummariesList, error) {
		return BACnetEventSummariesListParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetEventSummariesListParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetEventSummariesList, error) {
	v, err := (&_BACnetEventSummariesList{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEventSummariesList) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetEventSummariesList BACnetEventSummariesList, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventSummariesList"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventSummariesList")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfEventSummaries, err := ReadTerminatedArrayField[BACnetEventSummary](ctx, "listOfEventSummaries", ReadComplex[BACnetEventSummary](BACnetEventSummaryParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfEventSummaries' field"))
	}
	m.ListOfEventSummaries = listOfEventSummaries

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetEventSummariesList"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventSummariesList")
	}

	return m, nil
}

func (m *_BACnetEventSummariesList) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventSummariesList) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventSummariesList"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventSummariesList")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfEventSummaries", m.GetListOfEventSummaries(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfEventSummaries' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventSummariesList"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventSummariesList")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEventSummariesList) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetEventSummariesList) IsBACnetEventSummariesList() {}

func (m *_BACnetEventSummariesList) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventSummariesList) deepCopy() *_BACnetEventSummariesList {
	if m == nil {
		return nil
	}
	_BACnetEventSummariesListCopy := &_BACnetEventSummariesList{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetEventSummary, BACnetEventSummary](m.ListOfEventSummaries),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetEventSummariesListCopy
}

func (m *_BACnetEventSummariesList) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
