/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLoggingTypeTagged is the corresponding interface of BACnetLoggingTypeTagged
type BACnetLoggingTypeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetLoggingType
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetLoggingTypeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLoggingTypeTagged()
	// CreateBuilder creates a BACnetLoggingTypeTaggedBuilder
	CreateBACnetLoggingTypeTaggedBuilder() BACnetLoggingTypeTaggedBuilder
}

// _BACnetLoggingTypeTagged is the data-structure of this message
type _BACnetLoggingTypeTagged struct {
	Header           BACnetTagHeader
	Value            BACnetLoggingType
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLoggingTypeTagged = (*_BACnetLoggingTypeTagged)(nil)

// NewBACnetLoggingTypeTagged factory function for _BACnetLoggingTypeTagged
func NewBACnetLoggingTypeTagged(header BACnetTagHeader, value BACnetLoggingType, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetLoggingTypeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLoggingTypeTagged must not be nil")
	}
	return &_BACnetLoggingTypeTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLoggingTypeTaggedBuilder is a builder for BACnetLoggingTypeTagged
type BACnetLoggingTypeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetLoggingType, proprietaryValue uint32) BACnetLoggingTypeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLoggingTypeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLoggingTypeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetLoggingType) BACnetLoggingTypeTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetLoggingTypeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLoggingTypeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLoggingTypeTaggedBuilder
	// Build builds the BACnetLoggingTypeTagged or returns an error if something is wrong
	Build() (BACnetLoggingTypeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLoggingTypeTagged
}

// NewBACnetLoggingTypeTaggedBuilder() creates a BACnetLoggingTypeTaggedBuilder
func NewBACnetLoggingTypeTaggedBuilder() BACnetLoggingTypeTaggedBuilder {
	return &_BACnetLoggingTypeTaggedBuilder{_BACnetLoggingTypeTagged: new(_BACnetLoggingTypeTagged)}
}

type _BACnetLoggingTypeTaggedBuilder struct {
	*_BACnetLoggingTypeTagged

	collectedErr []error
}

var _ (BACnetLoggingTypeTaggedBuilder) = (*_BACnetLoggingTypeTaggedBuilder)(nil)

func (b *_BACnetLoggingTypeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetLoggingType, proprietaryValue uint32) BACnetLoggingTypeTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetLoggingTypeTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLoggingTypeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLoggingTypeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLoggingTypeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLoggingTypeTaggedBuilder) WithValue(value BACnetLoggingType) BACnetLoggingTypeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetLoggingTypeTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetLoggingTypeTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetLoggingTypeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLoggingTypeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLoggingTypeTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLoggingTypeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLoggingTypeTaggedBuilder) Build() (BACnetLoggingTypeTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLoggingTypeTagged.deepCopy(), nil
}

func (b *_BACnetLoggingTypeTaggedBuilder) MustBuild() BACnetLoggingTypeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLoggingTypeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLoggingTypeTaggedBuilder().(*_BACnetLoggingTypeTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLoggingTypeTaggedBuilder creates a BACnetLoggingTypeTaggedBuilder
func (b *_BACnetLoggingTypeTagged) CreateBACnetLoggingTypeTaggedBuilder() BACnetLoggingTypeTaggedBuilder {
	if b == nil {
		return NewBACnetLoggingTypeTaggedBuilder()
	}
	return &_BACnetLoggingTypeTaggedBuilder{_BACnetLoggingTypeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLoggingTypeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLoggingTypeTagged) GetValue() BACnetLoggingType {
	return m.Value
}

func (m *_BACnetLoggingTypeTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetLoggingTypeTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetLoggingType_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLoggingTypeTagged(structType any) BACnetLoggingTypeTagged {
	if casted, ok := structType.(BACnetLoggingTypeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLoggingTypeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLoggingTypeTagged) GetTypeName() string {
	return "BACnetLoggingTypeTagged"
}

func (m *_BACnetLoggingTypeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetLoggingTypeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLoggingTypeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLoggingTypeTagged, error) {
	return BACnetLoggingTypeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLoggingTypeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLoggingTypeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLoggingTypeTagged, error) {
		return BACnetLoggingTypeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLoggingTypeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLoggingTypeTagged, error) {
	v, err := (&_BACnetLoggingTypeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLoggingTypeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLoggingTypeTagged BACnetLoggingTypeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLoggingTypeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLoggingTypeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetLoggingType](ctx, "value", readBuffer, EnsureType[BACnetLoggingType](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetLoggingType_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetLoggingType_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetLoggingTypeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLoggingTypeTagged")
	}

	return m, nil
}

func (m *_BACnetLoggingTypeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLoggingTypeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLoggingTypeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLoggingTypeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetLoggingType](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLoggingTypeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLoggingTypeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLoggingTypeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLoggingTypeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLoggingTypeTagged) IsBACnetLoggingTypeTagged() {}

func (m *_BACnetLoggingTypeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLoggingTypeTagged) deepCopy() *_BACnetLoggingTypeTagged {
	if m == nil {
		return nil
	}
	_BACnetLoggingTypeTaggedCopy := &_BACnetLoggingTypeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLoggingTypeTaggedCopy
}

func (m *_BACnetLoggingTypeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
