/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAck is the corresponding interface of BACnetServiceAck
type BACnetServiceAck interface {
	BACnetServiceAckContract
	BACnetServiceAckRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetServiceAck is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetServiceAck()
	// CreateBuilder creates a BACnetServiceAckBuilder
	CreateBACnetServiceAckBuilder() BACnetServiceAckBuilder
}

// BACnetServiceAckContract provides a set of functions which can be overwritten by a sub struct
type BACnetServiceAckContract interface {
	// GetServiceAckPayloadLength returns ServiceAckPayloadLength (virtual field)
	GetServiceAckPayloadLength() uint32
	// GetServiceAckLength() returns a parser argument
	GetServiceAckLength() uint32
	// IsBACnetServiceAck is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetServiceAck()
	// CreateBuilder creates a BACnetServiceAckBuilder
	CreateBACnetServiceAckBuilder() BACnetServiceAckBuilder
}

// BACnetServiceAckRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetServiceAckRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetServiceChoice returns ServiceChoice (discriminator field)
	GetServiceChoice() BACnetConfirmedServiceChoice
}

// _BACnetServiceAck is the data-structure of this message
type _BACnetServiceAck struct {
	_SubType interface {
		BACnetServiceAckContract
		BACnetServiceAckRequirements
	}

	// Arguments.
	ServiceAckLength uint32
}

var _ BACnetServiceAckContract = (*_BACnetServiceAck)(nil)

// NewBACnetServiceAck factory function for _BACnetServiceAck
func NewBACnetServiceAck(serviceAckLength uint32) *_BACnetServiceAck {
	return &_BACnetServiceAck{ServiceAckLength: serviceAckLength}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetServiceAckBuilder is a builder for BACnetServiceAck
type BACnetServiceAckBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetServiceAckBuilder
	// WithArgServiceAckLength sets a parser argument
	WithArgServiceAckLength(uint32) BACnetServiceAckBuilder
	// AsBACnetServiceAckGetAlarmSummary converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckGetAlarmSummary() BACnetServiceAckGetAlarmSummaryBuilder
	// AsBACnetServiceAckGetEnrollmentSummary converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckGetEnrollmentSummary() BACnetServiceAckGetEnrollmentSummaryBuilder
	// AsBACnetServiceAckGetEventInformation converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckGetEventInformation() BACnetServiceAckGetEventInformationBuilder
	// AsBACnetServiceAckAtomicReadFile converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckAtomicReadFile() BACnetServiceAckAtomicReadFileBuilder
	// AsBACnetServiceAckAtomicWriteFile converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckAtomicWriteFile() BACnetServiceAckAtomicWriteFileBuilder
	// AsBACnetServiceAckCreateObject converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckCreateObject() BACnetServiceAckCreateObjectBuilder
	// AsBACnetServiceAckReadProperty converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckReadProperty() BACnetServiceAckReadPropertyBuilder
	// AsBACnetServiceAckReadPropertyMultiple converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckReadPropertyMultiple() BACnetServiceAckReadPropertyMultipleBuilder
	// AsBACnetServiceAckReadRange converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckReadRange() BACnetServiceAckReadRangeBuilder
	// AsBACnetServiceAckConfirmedPrivateTransfer converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckConfirmedPrivateTransfer() BACnetServiceAckConfirmedPrivateTransferBuilder
	// AsBACnetServiceAckVTOpen converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckVTOpen() BACnetServiceAckVTOpenBuilder
	// AsBACnetServiceAckVTData converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckVTData() BACnetServiceAckVTDataBuilder
	// AsBACnetServiceAckAuthenticate converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckAuthenticate() BACnetServiceAckAuthenticateBuilder
	// AsBACnetServiceAckRequestKey converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckRequestKey() BACnetServiceAckRequestKeyBuilder
	// AsBACnetServiceAckReadPropertyConditional converts this build to a subType of BACnetServiceAck. It is always possible to return to current builder using Done()
	AsBACnetServiceAckReadPropertyConditional() BACnetServiceAckReadPropertyConditionalBuilder
	// Build builds the BACnetServiceAck or returns an error if something is wrong
	PartialBuild() (BACnetServiceAckContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetServiceAckContract
	// Build builds the BACnetServiceAck or returns an error if something is wrong
	Build() (BACnetServiceAck, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetServiceAck
}

// NewBACnetServiceAckBuilder() creates a BACnetServiceAckBuilder
func NewBACnetServiceAckBuilder() BACnetServiceAckBuilder {
	return &_BACnetServiceAckBuilder{_BACnetServiceAck: new(_BACnetServiceAck)}
}

type _BACnetServiceAckChildBuilder interface {
	utils.Copyable
	setParent(BACnetServiceAckContract)
	buildForBACnetServiceAck() (BACnetServiceAck, error)
}

type _BACnetServiceAckBuilder struct {
	*_BACnetServiceAck

	childBuilder _BACnetServiceAckChildBuilder

	collectedErr []error
}

var _ (BACnetServiceAckBuilder) = (*_BACnetServiceAckBuilder)(nil)

func (b *_BACnetServiceAckBuilder) WithMandatoryFields() BACnetServiceAckBuilder {
	return b
}

func (b *_BACnetServiceAckBuilder) WithArgServiceAckLength(serviceAckLength uint32) BACnetServiceAckBuilder {
	b.ServiceAckLength = serviceAckLength
	return b
}

func (b *_BACnetServiceAckBuilder) PartialBuild() (BACnetServiceAckContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetServiceAck.deepCopy(), nil
}

func (b *_BACnetServiceAckBuilder) PartialMustBuild() BACnetServiceAckContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckGetAlarmSummary() BACnetServiceAckGetAlarmSummaryBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckGetAlarmSummaryBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckGetAlarmSummaryBuilder().(*_BACnetServiceAckGetAlarmSummaryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckGetEnrollmentSummary() BACnetServiceAckGetEnrollmentSummaryBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckGetEnrollmentSummaryBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckGetEnrollmentSummaryBuilder().(*_BACnetServiceAckGetEnrollmentSummaryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckGetEventInformation() BACnetServiceAckGetEventInformationBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckGetEventInformationBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckGetEventInformationBuilder().(*_BACnetServiceAckGetEventInformationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckAtomicReadFile() BACnetServiceAckAtomicReadFileBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckAtomicReadFileBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckAtomicReadFileBuilder().(*_BACnetServiceAckAtomicReadFileBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckAtomicWriteFile() BACnetServiceAckAtomicWriteFileBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckAtomicWriteFileBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckAtomicWriteFileBuilder().(*_BACnetServiceAckAtomicWriteFileBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckCreateObject() BACnetServiceAckCreateObjectBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckCreateObjectBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckCreateObjectBuilder().(*_BACnetServiceAckCreateObjectBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckReadProperty() BACnetServiceAckReadPropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckReadPropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckReadPropertyBuilder().(*_BACnetServiceAckReadPropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckReadPropertyMultiple() BACnetServiceAckReadPropertyMultipleBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckReadPropertyMultipleBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckReadPropertyMultipleBuilder().(*_BACnetServiceAckReadPropertyMultipleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckReadRange() BACnetServiceAckReadRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckReadRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckReadRangeBuilder().(*_BACnetServiceAckReadRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckConfirmedPrivateTransfer() BACnetServiceAckConfirmedPrivateTransferBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckConfirmedPrivateTransferBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckConfirmedPrivateTransferBuilder().(*_BACnetServiceAckConfirmedPrivateTransferBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckVTOpen() BACnetServiceAckVTOpenBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckVTOpenBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckVTOpenBuilder().(*_BACnetServiceAckVTOpenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckVTData() BACnetServiceAckVTDataBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckVTDataBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckVTDataBuilder().(*_BACnetServiceAckVTDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckAuthenticate() BACnetServiceAckAuthenticateBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckAuthenticateBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckAuthenticateBuilder().(*_BACnetServiceAckAuthenticateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckRequestKey() BACnetServiceAckRequestKeyBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckRequestKeyBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckRequestKeyBuilder().(*_BACnetServiceAckRequestKeyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) AsBACnetServiceAckReadPropertyConditional() BACnetServiceAckReadPropertyConditionalBuilder {
	if cb, ok := b.childBuilder.(BACnetServiceAckReadPropertyConditionalBuilder); ok {
		return cb
	}
	cb := NewBACnetServiceAckReadPropertyConditionalBuilder().(*_BACnetServiceAckReadPropertyConditionalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetServiceAckBuilder) Build() (BACnetServiceAck, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetServiceAck()
}

func (b *_BACnetServiceAckBuilder) MustBuild() BACnetServiceAck {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetServiceAckBuilder) DeepCopy() any {
	_copy := b.CreateBACnetServiceAckBuilder().(*_BACnetServiceAckBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetServiceAckChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetServiceAckBuilder creates a BACnetServiceAckBuilder
func (b *_BACnetServiceAck) CreateBACnetServiceAckBuilder() BACnetServiceAckBuilder {
	if b == nil {
		return NewBACnetServiceAckBuilder()
	}
	return &_BACnetServiceAckBuilder{_BACnetServiceAck: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetServiceAck) GetServiceAckPayloadLength() uint32 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint32(utils.InlineIf((bool((m.GetServiceAckLength()) > (0))), func() any { return uint32((uint32(m.GetServiceAckLength()) - uint32(uint32(1)))) }, func() any { return uint32(uint32(0)) }).(uint32))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetServiceAck(structType any) BACnetServiceAck {
	if casted, ok := structType.(BACnetServiceAck); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAck); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAck) GetTypeName() string {
	return "BACnetServiceAck"
}

func (m *_BACnetServiceAck) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (serviceChoice)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetServiceAck) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetServiceAck) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetServiceAckParse[T BACnetServiceAck](ctx context.Context, theBytes []byte, serviceAckLength uint32) (T, error) {
	return BACnetServiceAckParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), serviceAckLength)
}

func BACnetServiceAckParseWithBufferProducer[T BACnetServiceAck](serviceAckLength uint32) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetServiceAckParseWithBuffer[T](ctx, readBuffer, serviceAckLength)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetServiceAckParseWithBuffer[T BACnetServiceAck](ctx context.Context, readBuffer utils.ReadBuffer, serviceAckLength uint32) (T, error) {
	v, err := (&_BACnetServiceAck{ServiceAckLength: serviceAckLength}).parse(ctx, readBuffer, serviceAckLength)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetServiceAck) parse(ctx context.Context, readBuffer utils.ReadBuffer, serviceAckLength uint32) (__bACnetServiceAck BACnetServiceAck, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetServiceAck"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAck")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	serviceChoice, err := ReadDiscriminatorEnumField[BACnetConfirmedServiceChoice](ctx, "serviceChoice", "BACnetConfirmedServiceChoice", ReadEnum(BACnetConfirmedServiceChoiceByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceChoice' field"))
	}

	serviceAckPayloadLength, err := ReadVirtualField[uint32](ctx, "serviceAckPayloadLength", (*uint32)(nil), utils.InlineIf((bool((serviceAckLength) > (0))), func() any { return uint32((uint32(serviceAckLength) - uint32(uint32(1)))) }, func() any { return uint32(uint32(0)) }).(uint32))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceAckPayloadLength' field"))
	}
	_ = serviceAckPayloadLength

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetServiceAck
	switch {
	case serviceChoice == BACnetConfirmedServiceChoice_GET_ALARM_SUMMARY: // BACnetServiceAckGetAlarmSummary
		if _child, err = new(_BACnetServiceAckGetAlarmSummary).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckGetAlarmSummary for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_GET_ENROLLMENT_SUMMARY: // BACnetServiceAckGetEnrollmentSummary
		if _child, err = new(_BACnetServiceAckGetEnrollmentSummary).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckGetEnrollmentSummary for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_GET_EVENT_INFORMATION: // BACnetServiceAckGetEventInformation
		if _child, err = new(_BACnetServiceAckGetEventInformation).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckGetEventInformation for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_ATOMIC_READ_FILE: // BACnetServiceAckAtomicReadFile
		if _child, err = new(_BACnetServiceAckAtomicReadFile).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckAtomicReadFile for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_ATOMIC_WRITE_FILE: // BACnetServiceAckAtomicWriteFile
		if _child, err = new(_BACnetServiceAckAtomicWriteFile).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckAtomicWriteFile for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CREATE_OBJECT: // BACnetServiceAckCreateObject
		if _child, err = new(_BACnetServiceAckCreateObject).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckCreateObject for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY: // BACnetServiceAckReadProperty
		if _child, err = new(_BACnetServiceAckReadProperty).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckReadProperty for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY_MULTIPLE: // BACnetServiceAckReadPropertyMultiple
		if _child, err = new(_BACnetServiceAckReadPropertyMultiple).parse(ctx, readBuffer, m, serviceAckPayloadLength, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckReadPropertyMultiple for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_RANGE: // BACnetServiceAckReadRange
		if _child, err = new(_BACnetServiceAckReadRange).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckReadRange for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_CONFIRMED_PRIVATE_TRANSFER: // BACnetServiceAckConfirmedPrivateTransfer
		if _child, err = new(_BACnetServiceAckConfirmedPrivateTransfer).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckConfirmedPrivateTransfer for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_VT_OPEN: // BACnetServiceAckVTOpen
		if _child, err = new(_BACnetServiceAckVTOpen).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckVTOpen for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_VT_DATA: // BACnetServiceAckVTData
		if _child, err = new(_BACnetServiceAckVTData).parse(ctx, readBuffer, m, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckVTData for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_AUTHENTICATE: // BACnetServiceAckAuthenticate
		if _child, err = new(_BACnetServiceAckAuthenticate).parse(ctx, readBuffer, m, serviceAckPayloadLength, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckAuthenticate for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_REQUEST_KEY: // BACnetServiceAckRequestKey
		if _child, err = new(_BACnetServiceAckRequestKey).parse(ctx, readBuffer, m, serviceAckPayloadLength, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckRequestKey for type-switch of BACnetServiceAck")
		}
	case serviceChoice == BACnetConfirmedServiceChoice_READ_PROPERTY_CONDITIONAL: // BACnetServiceAckReadPropertyConditional
		if _child, err = new(_BACnetServiceAckReadPropertyConditional).parse(ctx, readBuffer, m, serviceAckPayloadLength, serviceAckLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetServiceAckReadPropertyConditional for type-switch of BACnetServiceAck")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [serviceChoice=%v]", serviceChoice)
	}

	if closeErr := readBuffer.CloseContext("BACnetServiceAck"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAck")
	}

	return _child, nil
}

func (pm *_BACnetServiceAck) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetServiceAck, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetServiceAck"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetServiceAck")
	}

	if err := WriteDiscriminatorEnumField(ctx, "serviceChoice", "BACnetConfirmedServiceChoice", m.GetServiceChoice(), WriteEnum[BACnetConfirmedServiceChoice, uint8](BACnetConfirmedServiceChoice.GetValue, BACnetConfirmedServiceChoice.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'serviceChoice' field")
	}
	// Virtual field
	serviceAckPayloadLength := m.GetServiceAckPayloadLength()
	_ = serviceAckPayloadLength
	if _serviceAckPayloadLengthErr := writeBuffer.WriteVirtual(ctx, "serviceAckPayloadLength", m.GetServiceAckPayloadLength()); _serviceAckPayloadLengthErr != nil {
		return errors.Wrap(_serviceAckPayloadLengthErr, "Error serializing 'serviceAckPayloadLength' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetServiceAck"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetServiceAck")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetServiceAck) GetServiceAckLength() uint32 {
	return m.ServiceAckLength
}

//
////

func (m *_BACnetServiceAck) IsBACnetServiceAck() {}

func (m *_BACnetServiceAck) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetServiceAck) deepCopy() *_BACnetServiceAck {
	if m == nil {
		return nil
	}
	_BACnetServiceAckCopy := &_BACnetServiceAck{
		nil, // will be set by child
		m.ServiceAckLength,
	}
	return _BACnetServiceAckCopy
}
