/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CALDataAcknowledge is the corresponding interface of CALDataAcknowledge
type CALDataAcknowledge interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CALData
	// GetParamNo returns ParamNo (property field)
	GetParamNo() Parameter
	// GetCode returns Code (property field)
	GetCode() uint8
	// IsCALDataAcknowledge is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCALDataAcknowledge()
	// CreateBuilder creates a CALDataAcknowledgeBuilder
	CreateCALDataAcknowledgeBuilder() CALDataAcknowledgeBuilder
}

// _CALDataAcknowledge is the data-structure of this message
type _CALDataAcknowledge struct {
	CALDataContract
	ParamNo Parameter
	Code    uint8
}

var _ CALDataAcknowledge = (*_CALDataAcknowledge)(nil)
var _ CALDataRequirements = (*_CALDataAcknowledge)(nil)

// NewCALDataAcknowledge factory function for _CALDataAcknowledge
func NewCALDataAcknowledge(commandTypeContainer CALCommandTypeContainer, additionalData CALData, paramNo Parameter, code uint8, requestContext RequestContext) *_CALDataAcknowledge {
	_result := &_CALDataAcknowledge{
		CALDataContract: NewCALData(commandTypeContainer, additionalData, requestContext),
		ParamNo:         paramNo,
		Code:            code,
	}
	_result.CALDataContract.(*_CALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CALDataAcknowledgeBuilder is a builder for CALDataAcknowledge
type CALDataAcknowledgeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(paramNo Parameter, code uint8) CALDataAcknowledgeBuilder
	// WithParamNo adds ParamNo (property field)
	WithParamNo(Parameter) CALDataAcknowledgeBuilder
	// WithCode adds Code (property field)
	WithCode(uint8) CALDataAcknowledgeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CALDataBuilder
	// Build builds the CALDataAcknowledge or returns an error if something is wrong
	Build() (CALDataAcknowledge, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CALDataAcknowledge
}

// NewCALDataAcknowledgeBuilder() creates a CALDataAcknowledgeBuilder
func NewCALDataAcknowledgeBuilder() CALDataAcknowledgeBuilder {
	return &_CALDataAcknowledgeBuilder{_CALDataAcknowledge: new(_CALDataAcknowledge)}
}

type _CALDataAcknowledgeBuilder struct {
	*_CALDataAcknowledge

	parentBuilder *_CALDataBuilder

	collectedErr []error
}

var _ (CALDataAcknowledgeBuilder) = (*_CALDataAcknowledgeBuilder)(nil)

func (b *_CALDataAcknowledgeBuilder) setParent(contract CALDataContract) {
	b.CALDataContract = contract
	contract.(*_CALData)._SubType = b._CALDataAcknowledge
}

func (b *_CALDataAcknowledgeBuilder) WithMandatoryFields(paramNo Parameter, code uint8) CALDataAcknowledgeBuilder {
	return b.WithParamNo(paramNo).WithCode(code)
}

func (b *_CALDataAcknowledgeBuilder) WithParamNo(paramNo Parameter) CALDataAcknowledgeBuilder {
	b.ParamNo = paramNo
	return b
}

func (b *_CALDataAcknowledgeBuilder) WithCode(code uint8) CALDataAcknowledgeBuilder {
	b.Code = code
	return b
}

func (b *_CALDataAcknowledgeBuilder) Build() (CALDataAcknowledge, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CALDataAcknowledge.deepCopy(), nil
}

func (b *_CALDataAcknowledgeBuilder) MustBuild() CALDataAcknowledge {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CALDataAcknowledgeBuilder) Done() CALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCALDataBuilder().(*_CALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_CALDataAcknowledgeBuilder) buildForCALData() (CALData, error) {
	return b.Build()
}

func (b *_CALDataAcknowledgeBuilder) DeepCopy() any {
	_copy := b.CreateCALDataAcknowledgeBuilder().(*_CALDataAcknowledgeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCALDataAcknowledgeBuilder creates a CALDataAcknowledgeBuilder
func (b *_CALDataAcknowledge) CreateCALDataAcknowledgeBuilder() CALDataAcknowledgeBuilder {
	if b == nil {
		return NewCALDataAcknowledgeBuilder()
	}
	return &_CALDataAcknowledgeBuilder{_CALDataAcknowledge: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CALDataAcknowledge) GetParent() CALDataContract {
	return m.CALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CALDataAcknowledge) GetParamNo() Parameter {
	return m.ParamNo
}

func (m *_CALDataAcknowledge) GetCode() uint8 {
	return m.Code
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCALDataAcknowledge(structType any) CALDataAcknowledge {
	if casted, ok := structType.(CALDataAcknowledge); ok {
		return casted
	}
	if casted, ok := structType.(*CALDataAcknowledge); ok {
		return *casted
	}
	return nil
}

func (m *_CALDataAcknowledge) GetTypeName() string {
	return "CALDataAcknowledge"
}

func (m *_CALDataAcknowledge) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CALDataContract.(*_CALData).getLengthInBits(ctx))

	// Simple field (paramNo)
	lengthInBits += 8

	// Simple field (code)
	lengthInBits += 8

	return lengthInBits
}

func (m *_CALDataAcknowledge) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CALDataAcknowledge) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CALData, requestContext RequestContext) (__cALDataAcknowledge CALDataAcknowledge, err error) {
	m.CALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CALDataAcknowledge"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CALDataAcknowledge")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	paramNo, err := ReadEnumField[Parameter](ctx, "paramNo", "Parameter", ReadEnum(ParameterByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'paramNo' field"))
	}
	m.ParamNo = paramNo

	code, err := ReadSimpleField(ctx, "code", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'code' field"))
	}
	m.Code = code

	if closeErr := readBuffer.CloseContext("CALDataAcknowledge"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CALDataAcknowledge")
	}

	return m, nil
}

func (m *_CALDataAcknowledge) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CALDataAcknowledge) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CALDataAcknowledge"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CALDataAcknowledge")
		}

		if err := WriteSimpleEnumField[Parameter](ctx, "paramNo", "Parameter", m.GetParamNo(), WriteEnum[Parameter, uint8](Parameter.GetValue, Parameter.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'paramNo' field")
		}

		if err := WriteSimpleField[uint8](ctx, "code", m.GetCode(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'code' field")
		}

		if popErr := writeBuffer.PopContext("CALDataAcknowledge"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CALDataAcknowledge")
		}
		return nil
	}
	return m.CALDataContract.(*_CALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CALDataAcknowledge) IsCALDataAcknowledge() {}

func (m *_CALDataAcknowledge) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CALDataAcknowledge) deepCopy() *_CALDataAcknowledge {
	if m == nil {
		return nil
	}
	_CALDataAcknowledgeCopy := &_CALDataAcknowledge{
		m.CALDataContract.(*_CALData).deepCopy(),
		m.ParamNo,
		m.Code,
	}
	_CALDataAcknowledgeCopy.CALDataContract.(*_CALData)._SubType = m
	return _CALDataAcknowledgeCopy
}

func (m *_CALDataAcknowledge) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
