/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LevelInformationCorrupted is the corresponding interface of LevelInformationCorrupted
type LevelInformationCorrupted interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	LevelInformation
	// GetCorruptedNibble1 returns CorruptedNibble1 (property field)
	GetCorruptedNibble1() uint8
	// GetCorruptedNibble2 returns CorruptedNibble2 (property field)
	GetCorruptedNibble2() uint8
	// GetCorruptedNibble3 returns CorruptedNibble3 (property field)
	GetCorruptedNibble3() uint8
	// GetCorruptedNibble4 returns CorruptedNibble4 (property field)
	GetCorruptedNibble4() uint8
	// IsLevelInformationCorrupted is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLevelInformationCorrupted()
	// CreateBuilder creates a LevelInformationCorruptedBuilder
	CreateLevelInformationCorruptedBuilder() LevelInformationCorruptedBuilder
}

// _LevelInformationCorrupted is the data-structure of this message
type _LevelInformationCorrupted struct {
	LevelInformationContract
	CorruptedNibble1 uint8
	CorruptedNibble2 uint8
	CorruptedNibble3 uint8
	CorruptedNibble4 uint8
}

var _ LevelInformationCorrupted = (*_LevelInformationCorrupted)(nil)
var _ LevelInformationRequirements = (*_LevelInformationCorrupted)(nil)

// NewLevelInformationCorrupted factory function for _LevelInformationCorrupted
func NewLevelInformationCorrupted(raw uint16, corruptedNibble1 uint8, corruptedNibble2 uint8, corruptedNibble3 uint8, corruptedNibble4 uint8) *_LevelInformationCorrupted {
	_result := &_LevelInformationCorrupted{
		LevelInformationContract: NewLevelInformation(raw),
		CorruptedNibble1:         corruptedNibble1,
		CorruptedNibble2:         corruptedNibble2,
		CorruptedNibble3:         corruptedNibble3,
		CorruptedNibble4:         corruptedNibble4,
	}
	_result.LevelInformationContract.(*_LevelInformation)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LevelInformationCorruptedBuilder is a builder for LevelInformationCorrupted
type LevelInformationCorruptedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(corruptedNibble1 uint8, corruptedNibble2 uint8, corruptedNibble3 uint8, corruptedNibble4 uint8) LevelInformationCorruptedBuilder
	// WithCorruptedNibble1 adds CorruptedNibble1 (property field)
	WithCorruptedNibble1(uint8) LevelInformationCorruptedBuilder
	// WithCorruptedNibble2 adds CorruptedNibble2 (property field)
	WithCorruptedNibble2(uint8) LevelInformationCorruptedBuilder
	// WithCorruptedNibble3 adds CorruptedNibble3 (property field)
	WithCorruptedNibble3(uint8) LevelInformationCorruptedBuilder
	// WithCorruptedNibble4 adds CorruptedNibble4 (property field)
	WithCorruptedNibble4(uint8) LevelInformationCorruptedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() LevelInformationBuilder
	// Build builds the LevelInformationCorrupted or returns an error if something is wrong
	Build() (LevelInformationCorrupted, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LevelInformationCorrupted
}

// NewLevelInformationCorruptedBuilder() creates a LevelInformationCorruptedBuilder
func NewLevelInformationCorruptedBuilder() LevelInformationCorruptedBuilder {
	return &_LevelInformationCorruptedBuilder{_LevelInformationCorrupted: new(_LevelInformationCorrupted)}
}

type _LevelInformationCorruptedBuilder struct {
	*_LevelInformationCorrupted

	parentBuilder *_LevelInformationBuilder

	collectedErr []error
}

var _ (LevelInformationCorruptedBuilder) = (*_LevelInformationCorruptedBuilder)(nil)

func (b *_LevelInformationCorruptedBuilder) setParent(contract LevelInformationContract) {
	b.LevelInformationContract = contract
	contract.(*_LevelInformation)._SubType = b._LevelInformationCorrupted
}

func (b *_LevelInformationCorruptedBuilder) WithMandatoryFields(corruptedNibble1 uint8, corruptedNibble2 uint8, corruptedNibble3 uint8, corruptedNibble4 uint8) LevelInformationCorruptedBuilder {
	return b.WithCorruptedNibble1(corruptedNibble1).WithCorruptedNibble2(corruptedNibble2).WithCorruptedNibble3(corruptedNibble3).WithCorruptedNibble4(corruptedNibble4)
}

func (b *_LevelInformationCorruptedBuilder) WithCorruptedNibble1(corruptedNibble1 uint8) LevelInformationCorruptedBuilder {
	b.CorruptedNibble1 = corruptedNibble1
	return b
}

func (b *_LevelInformationCorruptedBuilder) WithCorruptedNibble2(corruptedNibble2 uint8) LevelInformationCorruptedBuilder {
	b.CorruptedNibble2 = corruptedNibble2
	return b
}

func (b *_LevelInformationCorruptedBuilder) WithCorruptedNibble3(corruptedNibble3 uint8) LevelInformationCorruptedBuilder {
	b.CorruptedNibble3 = corruptedNibble3
	return b
}

func (b *_LevelInformationCorruptedBuilder) WithCorruptedNibble4(corruptedNibble4 uint8) LevelInformationCorruptedBuilder {
	b.CorruptedNibble4 = corruptedNibble4
	return b
}

func (b *_LevelInformationCorruptedBuilder) Build() (LevelInformationCorrupted, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._LevelInformationCorrupted.deepCopy(), nil
}

func (b *_LevelInformationCorruptedBuilder) MustBuild() LevelInformationCorrupted {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LevelInformationCorruptedBuilder) Done() LevelInformationBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewLevelInformationBuilder().(*_LevelInformationBuilder)
	}
	return b.parentBuilder
}

func (b *_LevelInformationCorruptedBuilder) buildForLevelInformation() (LevelInformation, error) {
	return b.Build()
}

func (b *_LevelInformationCorruptedBuilder) DeepCopy() any {
	_copy := b.CreateLevelInformationCorruptedBuilder().(*_LevelInformationCorruptedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateLevelInformationCorruptedBuilder creates a LevelInformationCorruptedBuilder
func (b *_LevelInformationCorrupted) CreateLevelInformationCorruptedBuilder() LevelInformationCorruptedBuilder {
	if b == nil {
		return NewLevelInformationCorruptedBuilder()
	}
	return &_LevelInformationCorruptedBuilder{_LevelInformationCorrupted: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LevelInformationCorrupted) GetParent() LevelInformationContract {
	return m.LevelInformationContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LevelInformationCorrupted) GetCorruptedNibble1() uint8 {
	return m.CorruptedNibble1
}

func (m *_LevelInformationCorrupted) GetCorruptedNibble2() uint8 {
	return m.CorruptedNibble2
}

func (m *_LevelInformationCorrupted) GetCorruptedNibble3() uint8 {
	return m.CorruptedNibble3
}

func (m *_LevelInformationCorrupted) GetCorruptedNibble4() uint8 {
	return m.CorruptedNibble4
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLevelInformationCorrupted(structType any) LevelInformationCorrupted {
	if casted, ok := structType.(LevelInformationCorrupted); ok {
		return casted
	}
	if casted, ok := structType.(*LevelInformationCorrupted); ok {
		return *casted
	}
	return nil
}

func (m *_LevelInformationCorrupted) GetTypeName() string {
	return "LevelInformationCorrupted"
}

func (m *_LevelInformationCorrupted) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.LevelInformationContract.(*_LevelInformation).getLengthInBits(ctx))

	// Simple field (corruptedNibble1)
	lengthInBits += 4

	// Simple field (corruptedNibble2)
	lengthInBits += 4

	// Simple field (corruptedNibble3)
	lengthInBits += 4

	// Simple field (corruptedNibble4)
	lengthInBits += 4

	return lengthInBits
}

func (m *_LevelInformationCorrupted) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LevelInformationCorrupted) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_LevelInformation) (__levelInformationCorrupted LevelInformationCorrupted, err error) {
	m.LevelInformationContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LevelInformationCorrupted"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LevelInformationCorrupted")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	corruptedNibble1, err := ReadSimpleField(ctx, "corruptedNibble1", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'corruptedNibble1' field"))
	}
	m.CorruptedNibble1 = corruptedNibble1

	corruptedNibble2, err := ReadSimpleField(ctx, "corruptedNibble2", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'corruptedNibble2' field"))
	}
	m.CorruptedNibble2 = corruptedNibble2

	corruptedNibble3, err := ReadSimpleField(ctx, "corruptedNibble3", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'corruptedNibble3' field"))
	}
	m.CorruptedNibble3 = corruptedNibble3

	corruptedNibble4, err := ReadSimpleField(ctx, "corruptedNibble4", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'corruptedNibble4' field"))
	}
	m.CorruptedNibble4 = corruptedNibble4

	if closeErr := readBuffer.CloseContext("LevelInformationCorrupted"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LevelInformationCorrupted")
	}

	return m, nil
}

func (m *_LevelInformationCorrupted) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LevelInformationCorrupted) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LevelInformationCorrupted"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LevelInformationCorrupted")
		}

		if err := WriteSimpleField[uint8](ctx, "corruptedNibble1", m.GetCorruptedNibble1(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
			return errors.Wrap(err, "Error serializing 'corruptedNibble1' field")
		}

		if err := WriteSimpleField[uint8](ctx, "corruptedNibble2", m.GetCorruptedNibble2(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
			return errors.Wrap(err, "Error serializing 'corruptedNibble2' field")
		}

		if err := WriteSimpleField[uint8](ctx, "corruptedNibble3", m.GetCorruptedNibble3(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
			return errors.Wrap(err, "Error serializing 'corruptedNibble3' field")
		}

		if err := WriteSimpleField[uint8](ctx, "corruptedNibble4", m.GetCorruptedNibble4(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
			return errors.Wrap(err, "Error serializing 'corruptedNibble4' field")
		}

		if popErr := writeBuffer.PopContext("LevelInformationCorrupted"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LevelInformationCorrupted")
		}
		return nil
	}
	return m.LevelInformationContract.(*_LevelInformation).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LevelInformationCorrupted) IsLevelInformationCorrupted() {}

func (m *_LevelInformationCorrupted) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LevelInformationCorrupted) deepCopy() *_LevelInformationCorrupted {
	if m == nil {
		return nil
	}
	_LevelInformationCorruptedCopy := &_LevelInformationCorrupted{
		m.LevelInformationContract.(*_LevelInformation).deepCopy(),
		m.CorruptedNibble1,
		m.CorruptedNibble2,
		m.CorruptedNibble3,
		m.CorruptedNibble4,
	}
	_LevelInformationCorruptedCopy.LevelInformationContract.(*_LevelInformation)._SubType = m
	return _LevelInformationCorruptedCopy
}

func (m *_LevelInformationCorrupted) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
