/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const ResponseTermination_CR byte = 0x0D
const ResponseTermination_LF byte = 0x0A

// ResponseTermination is the corresponding interface of ResponseTermination
type ResponseTermination interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsResponseTermination is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsResponseTermination()
	// CreateBuilder creates a ResponseTerminationBuilder
	CreateResponseTerminationBuilder() ResponseTerminationBuilder
}

// _ResponseTermination is the data-structure of this message
type _ResponseTermination struct {
}

var _ ResponseTermination = (*_ResponseTermination)(nil)

// NewResponseTermination factory function for _ResponseTermination
func NewResponseTermination() *_ResponseTermination {
	return &_ResponseTermination{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ResponseTerminationBuilder is a builder for ResponseTermination
type ResponseTerminationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ResponseTerminationBuilder
	// Build builds the ResponseTermination or returns an error if something is wrong
	Build() (ResponseTermination, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ResponseTermination
}

// NewResponseTerminationBuilder() creates a ResponseTerminationBuilder
func NewResponseTerminationBuilder() ResponseTerminationBuilder {
	return &_ResponseTerminationBuilder{_ResponseTermination: new(_ResponseTermination)}
}

type _ResponseTerminationBuilder struct {
	*_ResponseTermination

	collectedErr []error
}

var _ (ResponseTerminationBuilder) = (*_ResponseTerminationBuilder)(nil)

func (b *_ResponseTerminationBuilder) WithMandatoryFields() ResponseTerminationBuilder {
	return b
}

func (b *_ResponseTerminationBuilder) Build() (ResponseTermination, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ResponseTermination.deepCopy(), nil
}

func (b *_ResponseTerminationBuilder) MustBuild() ResponseTermination {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ResponseTerminationBuilder) DeepCopy() any {
	_copy := b.CreateResponseTerminationBuilder().(*_ResponseTerminationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateResponseTerminationBuilder creates a ResponseTerminationBuilder
func (b *_ResponseTermination) CreateResponseTerminationBuilder() ResponseTerminationBuilder {
	if b == nil {
		return NewResponseTerminationBuilder()
	}
	return &_ResponseTerminationBuilder{_ResponseTermination: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_ResponseTermination) GetCr() byte {
	return ResponseTermination_CR
}

func (m *_ResponseTermination) GetLf() byte {
	return ResponseTermination_LF
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastResponseTermination(structType any) ResponseTermination {
	if casted, ok := structType.(ResponseTermination); ok {
		return casted
	}
	if casted, ok := structType.(*ResponseTermination); ok {
		return *casted
	}
	return nil
}

func (m *_ResponseTermination) GetTypeName() string {
	return "ResponseTermination"
}

func (m *_ResponseTermination) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (cr)
	lengthInBits += 8

	// Const Field (lf)
	lengthInBits += 8

	return lengthInBits
}

func (m *_ResponseTermination) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ResponseTerminationParse(ctx context.Context, theBytes []byte) (ResponseTermination, error) {
	return ResponseTerminationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ResponseTerminationParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ResponseTermination, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ResponseTermination, error) {
		return ResponseTerminationParseWithBuffer(ctx, readBuffer)
	}
}

func ResponseTerminationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ResponseTermination, error) {
	v, err := (&_ResponseTermination{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ResponseTermination) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__responseTermination ResponseTermination, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ResponseTermination"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ResponseTermination")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	cr, err := ReadConstField[byte](ctx, "cr", ReadByte(readBuffer, 8), ResponseTermination_CR)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'cr' field"))
	}
	_ = cr

	lf, err := ReadConstField[byte](ctx, "lf", ReadByte(readBuffer, 8), ResponseTermination_LF)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lf' field"))
	}
	_ = lf

	if closeErr := readBuffer.CloseContext("ResponseTermination"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ResponseTermination")
	}

	return m, nil
}

func (m *_ResponseTermination) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ResponseTermination) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ResponseTermination"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ResponseTermination")
	}

	if err := WriteConstField(ctx, "cr", ResponseTermination_CR, WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'cr' field")
	}

	if err := WriteConstField(ctx, "lf", ResponseTermination_LF, WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'lf' field")
	}

	if popErr := writeBuffer.PopContext("ResponseTermination"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ResponseTermination")
	}
	return nil
}

func (m *_ResponseTermination) IsResponseTermination() {}

func (m *_ResponseTermination) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ResponseTermination) deepCopy() *_ResponseTermination {
	if m == nil {
		return nil
	}
	_ResponseTerminationCopy := &_ResponseTermination{}
	return _ResponseTerminationCopy
}

func (m *_ResponseTermination) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
