/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TelephonyData is the corresponding interface of TelephonyData
type TelephonyData interface {
	TelephonyDataContract
	TelephonyDataRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsTelephonyData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTelephonyData()
	// CreateBuilder creates a TelephonyDataBuilder
	CreateTelephonyDataBuilder() TelephonyDataBuilder
}

// TelephonyDataContract provides a set of functions which can be overwritten by a sub struct
type TelephonyDataContract interface {
	// GetCommandTypeContainer returns CommandTypeContainer (property field)
	GetCommandTypeContainer() TelephonyCommandTypeContainer
	// GetArgument returns Argument (property field)
	GetArgument() byte
	// GetCommandType returns CommandType (virtual field)
	GetCommandType() TelephonyCommandType
	// IsTelephonyData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTelephonyData()
	// CreateBuilder creates a TelephonyDataBuilder
	CreateTelephonyDataBuilder() TelephonyDataBuilder
}

// TelephonyDataRequirements provides a set of functions which need to be implemented by a sub struct
type TelephonyDataRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetArgument returns Argument (discriminator field)
	GetArgument() byte
	// GetCommandType returns CommandType (discriminator field)
	GetCommandType() TelephonyCommandType
}

// _TelephonyData is the data-structure of this message
type _TelephonyData struct {
	_SubType interface {
		TelephonyDataContract
		TelephonyDataRequirements
	}
	CommandTypeContainer TelephonyCommandTypeContainer
	Argument             byte
}

var _ TelephonyDataContract = (*_TelephonyData)(nil)

// NewTelephonyData factory function for _TelephonyData
func NewTelephonyData(commandTypeContainer TelephonyCommandTypeContainer, argument byte) *_TelephonyData {
	return &_TelephonyData{CommandTypeContainer: commandTypeContainer, Argument: argument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TelephonyDataBuilder is a builder for TelephonyData
type TelephonyDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(commandTypeContainer TelephonyCommandTypeContainer, argument byte) TelephonyDataBuilder
	// WithCommandTypeContainer adds CommandTypeContainer (property field)
	WithCommandTypeContainer(TelephonyCommandTypeContainer) TelephonyDataBuilder
	// WithArgument adds Argument (property field)
	WithArgument(byte) TelephonyDataBuilder
	// AsTelephonyDataLineOnHook converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataLineOnHook() TelephonyDataLineOnHookBuilder
	// AsTelephonyDataLineOffHook converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataLineOffHook() TelephonyDataLineOffHookBuilder
	// AsTelephonyDataDialOutFailure converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataDialOutFailure() TelephonyDataDialOutFailureBuilder
	// AsTelephonyDataDialInFailure converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataDialInFailure() TelephonyDataDialInFailureBuilder
	// AsTelephonyDataRinging converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataRinging() TelephonyDataRingingBuilder
	// AsTelephonyDataRecallLastNumber converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataRecallLastNumber() TelephonyDataRecallLastNumberBuilder
	// AsTelephonyDataInternetConnectionRequestMade converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataInternetConnectionRequestMade() TelephonyDataInternetConnectionRequestMadeBuilder
	// AsTelephonyDataIsolateSecondaryOutlet converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataIsolateSecondaryOutlet() TelephonyDataIsolateSecondaryOutletBuilder
	// AsTelephonyDataRecallLastNumberRequest converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataRecallLastNumberRequest() TelephonyDataRecallLastNumberRequestBuilder
	// AsTelephonyDataRejectIncomingCall converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataRejectIncomingCall() TelephonyDataRejectIncomingCallBuilder
	// AsTelephonyDataDivert converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataDivert() TelephonyDataDivertBuilder
	// AsTelephonyDataClearDiversion converts this build to a subType of TelephonyData. It is always possible to return to current builder using Done()
	AsTelephonyDataClearDiversion() TelephonyDataClearDiversionBuilder
	// Build builds the TelephonyData or returns an error if something is wrong
	PartialBuild() (TelephonyDataContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() TelephonyDataContract
	// Build builds the TelephonyData or returns an error if something is wrong
	Build() (TelephonyData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TelephonyData
}

// NewTelephonyDataBuilder() creates a TelephonyDataBuilder
func NewTelephonyDataBuilder() TelephonyDataBuilder {
	return &_TelephonyDataBuilder{_TelephonyData: new(_TelephonyData)}
}

type _TelephonyDataChildBuilder interface {
	utils.Copyable
	setParent(TelephonyDataContract)
	buildForTelephonyData() (TelephonyData, error)
}

type _TelephonyDataBuilder struct {
	*_TelephonyData

	childBuilder _TelephonyDataChildBuilder

	collectedErr []error
}

var _ (TelephonyDataBuilder) = (*_TelephonyDataBuilder)(nil)

func (b *_TelephonyDataBuilder) WithMandatoryFields(commandTypeContainer TelephonyCommandTypeContainer, argument byte) TelephonyDataBuilder {
	return b.WithCommandTypeContainer(commandTypeContainer).WithArgument(argument)
}

func (b *_TelephonyDataBuilder) WithCommandTypeContainer(commandTypeContainer TelephonyCommandTypeContainer) TelephonyDataBuilder {
	b.CommandTypeContainer = commandTypeContainer
	return b
}

func (b *_TelephonyDataBuilder) WithArgument(argument byte) TelephonyDataBuilder {
	b.Argument = argument
	return b
}

func (b *_TelephonyDataBuilder) PartialBuild() (TelephonyDataContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TelephonyData.deepCopy(), nil
}

func (b *_TelephonyDataBuilder) PartialMustBuild() TelephonyDataContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TelephonyDataBuilder) AsTelephonyDataLineOnHook() TelephonyDataLineOnHookBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataLineOnHookBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataLineOnHookBuilder().(*_TelephonyDataLineOnHookBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataLineOffHook() TelephonyDataLineOffHookBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataLineOffHookBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataLineOffHookBuilder().(*_TelephonyDataLineOffHookBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataDialOutFailure() TelephonyDataDialOutFailureBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataDialOutFailureBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataDialOutFailureBuilder().(*_TelephonyDataDialOutFailureBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataDialInFailure() TelephonyDataDialInFailureBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataDialInFailureBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataDialInFailureBuilder().(*_TelephonyDataDialInFailureBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataRinging() TelephonyDataRingingBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataRingingBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataRingingBuilder().(*_TelephonyDataRingingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataRecallLastNumber() TelephonyDataRecallLastNumberBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataRecallLastNumberBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataRecallLastNumberBuilder().(*_TelephonyDataRecallLastNumberBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataInternetConnectionRequestMade() TelephonyDataInternetConnectionRequestMadeBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataInternetConnectionRequestMadeBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataInternetConnectionRequestMadeBuilder().(*_TelephonyDataInternetConnectionRequestMadeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataIsolateSecondaryOutlet() TelephonyDataIsolateSecondaryOutletBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataIsolateSecondaryOutletBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataIsolateSecondaryOutletBuilder().(*_TelephonyDataIsolateSecondaryOutletBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataRecallLastNumberRequest() TelephonyDataRecallLastNumberRequestBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataRecallLastNumberRequestBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataRecallLastNumberRequestBuilder().(*_TelephonyDataRecallLastNumberRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataRejectIncomingCall() TelephonyDataRejectIncomingCallBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataRejectIncomingCallBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataRejectIncomingCallBuilder().(*_TelephonyDataRejectIncomingCallBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataDivert() TelephonyDataDivertBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataDivertBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataDivertBuilder().(*_TelephonyDataDivertBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) AsTelephonyDataClearDiversion() TelephonyDataClearDiversionBuilder {
	if cb, ok := b.childBuilder.(TelephonyDataClearDiversionBuilder); ok {
		return cb
	}
	cb := NewTelephonyDataClearDiversionBuilder().(*_TelephonyDataClearDiversionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_TelephonyDataBuilder) Build() (TelephonyData, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForTelephonyData()
}

func (b *_TelephonyDataBuilder) MustBuild() TelephonyData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TelephonyDataBuilder) DeepCopy() any {
	_copy := b.CreateTelephonyDataBuilder().(*_TelephonyDataBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_TelephonyDataChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTelephonyDataBuilder creates a TelephonyDataBuilder
func (b *_TelephonyData) CreateTelephonyDataBuilder() TelephonyDataBuilder {
	if b == nil {
		return NewTelephonyDataBuilder()
	}
	return &_TelephonyDataBuilder{_TelephonyData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TelephonyData) GetCommandTypeContainer() TelephonyCommandTypeContainer {
	return m.CommandTypeContainer
}

func (m *_TelephonyData) GetArgument() byte {
	return m.Argument
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_TelephonyData) GetCommandType() TelephonyCommandType {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return CastTelephonyCommandType(m.GetCommandTypeContainer().CommandType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTelephonyData(structType any) TelephonyData {
	if casted, ok := structType.(TelephonyData); ok {
		return casted
	}
	if casted, ok := structType.(*TelephonyData); ok {
		return *casted
	}
	return nil
}

func (m *_TelephonyData) GetTypeName() string {
	return "TelephonyData"
}

func (m *_TelephonyData) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (commandTypeContainer)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// Simple field (argument)
	lengthInBits += 8

	return lengthInBits
}

func (m *_TelephonyData) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_TelephonyData) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func TelephonyDataParse[T TelephonyData](ctx context.Context, theBytes []byte) (T, error) {
	return TelephonyDataParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func TelephonyDataParseWithBufferProducer[T TelephonyData]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := TelephonyDataParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func TelephonyDataParseWithBuffer[T TelephonyData](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_TelephonyData{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_TelephonyData) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__telephonyData TelephonyData, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TelephonyData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TelephonyData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(KnowsTelephonyCommandTypeContainer(ctx, readBuffer)) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "no command type could be found"})
	}

	commandTypeContainer, err := ReadEnumField[TelephonyCommandTypeContainer](ctx, "commandTypeContainer", "TelephonyCommandTypeContainer", ReadEnum(TelephonyCommandTypeContainerByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandTypeContainer' field"))
	}
	m.CommandTypeContainer = commandTypeContainer

	commandType, err := ReadVirtualField[TelephonyCommandType](ctx, "commandType", (*TelephonyCommandType)(nil), commandTypeContainer.CommandType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandType' field"))
	}
	_ = commandType

	argument, err := ReadSimpleField(ctx, "argument", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'argument' field"))
	}
	m.Argument = argument

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child TelephonyData
	switch {
	case commandType == TelephonyCommandType_EVENT && argument == 0x01: // TelephonyDataLineOnHook
		if _child, err = new(_TelephonyDataLineOnHook).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataLineOnHook for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x02: // TelephonyDataLineOffHook
		if _child, err = new(_TelephonyDataLineOffHook).parse(ctx, readBuffer, m, commandTypeContainer); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataLineOffHook for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x03: // TelephonyDataDialOutFailure
		if _child, err = new(_TelephonyDataDialOutFailure).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataDialOutFailure for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x04: // TelephonyDataDialInFailure
		if _child, err = new(_TelephonyDataDialInFailure).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataDialInFailure for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x05: // TelephonyDataRinging
		if _child, err = new(_TelephonyDataRinging).parse(ctx, readBuffer, m, commandTypeContainer); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataRinging for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x06: // TelephonyDataRecallLastNumber
		if _child, err = new(_TelephonyDataRecallLastNumber).parse(ctx, readBuffer, m, commandTypeContainer); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataRecallLastNumber for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x07: // TelephonyDataInternetConnectionRequestMade
		if _child, err = new(_TelephonyDataInternetConnectionRequestMade).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataInternetConnectionRequestMade for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x80: // TelephonyDataIsolateSecondaryOutlet
		if _child, err = new(_TelephonyDataIsolateSecondaryOutlet).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataIsolateSecondaryOutlet for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x81: // TelephonyDataRecallLastNumberRequest
		if _child, err = new(_TelephonyDataRecallLastNumberRequest).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataRecallLastNumberRequest for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x82: // TelephonyDataRejectIncomingCall
		if _child, err = new(_TelephonyDataRejectIncomingCall).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataRejectIncomingCall for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x83: // TelephonyDataDivert
		if _child, err = new(_TelephonyDataDivert).parse(ctx, readBuffer, m, commandTypeContainer); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataDivert for type-switch of TelephonyData")
		}
	case commandType == TelephonyCommandType_EVENT && argument == 0x84: // TelephonyDataClearDiversion
		if _child, err = new(_TelephonyDataClearDiversion).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TelephonyDataClearDiversion for type-switch of TelephonyData")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [commandType=%v, argument=%v]", commandType, argument)
	}

	if closeErr := readBuffer.CloseContext("TelephonyData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TelephonyData")
	}

	return _child, nil
}

func (pm *_TelephonyData) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child TelephonyData, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("TelephonyData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for TelephonyData")
	}

	if err := WriteSimpleEnumField[TelephonyCommandTypeContainer](ctx, "commandTypeContainer", "TelephonyCommandTypeContainer", m.GetCommandTypeContainer(), WriteEnum[TelephonyCommandTypeContainer, uint8](TelephonyCommandTypeContainer.GetValue, TelephonyCommandTypeContainer.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'commandTypeContainer' field")
	}
	// Virtual field
	commandType := m.GetCommandType()
	_ = commandType
	if _commandTypeErr := writeBuffer.WriteVirtual(ctx, "commandType", m.GetCommandType()); _commandTypeErr != nil {
		return errors.Wrap(_commandTypeErr, "Error serializing 'commandType' field")
	}

	if err := WriteSimpleField[byte](ctx, "argument", m.GetArgument(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'argument' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("TelephonyData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for TelephonyData")
	}
	return nil
}

func (m *_TelephonyData) IsTelephonyData() {}

func (m *_TelephonyData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TelephonyData) deepCopy() *_TelephonyData {
	if m == nil {
		return nil
	}
	_TelephonyDataCopy := &_TelephonyData{
		nil, // will be set by child
		m.CommandTypeContainer,
		m.Argument,
	}
	return _TelephonyDataCopy
}
