/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// FirmataCommandSetDigitalPinValue is the corresponding interface of FirmataCommandSetDigitalPinValue
type FirmataCommandSetDigitalPinValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	FirmataCommand
	// GetPin returns Pin (property field)
	GetPin() uint8
	// GetOn returns On (property field)
	GetOn() bool
	// IsFirmataCommandSetDigitalPinValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsFirmataCommandSetDigitalPinValue()
	// CreateBuilder creates a FirmataCommandSetDigitalPinValueBuilder
	CreateFirmataCommandSetDigitalPinValueBuilder() FirmataCommandSetDigitalPinValueBuilder
}

// _FirmataCommandSetDigitalPinValue is the data-structure of this message
type _FirmataCommandSetDigitalPinValue struct {
	FirmataCommandContract
	Pin uint8
	On  bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ FirmataCommandSetDigitalPinValue = (*_FirmataCommandSetDigitalPinValue)(nil)
var _ FirmataCommandRequirements = (*_FirmataCommandSetDigitalPinValue)(nil)

// NewFirmataCommandSetDigitalPinValue factory function for _FirmataCommandSetDigitalPinValue
func NewFirmataCommandSetDigitalPinValue(pin uint8, on bool, response bool) *_FirmataCommandSetDigitalPinValue {
	_result := &_FirmataCommandSetDigitalPinValue{
		FirmataCommandContract: NewFirmataCommand(response),
		Pin:                    pin,
		On:                     on,
	}
	_result.FirmataCommandContract.(*_FirmataCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// FirmataCommandSetDigitalPinValueBuilder is a builder for FirmataCommandSetDigitalPinValue
type FirmataCommandSetDigitalPinValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(pin uint8, on bool) FirmataCommandSetDigitalPinValueBuilder
	// WithPin adds Pin (property field)
	WithPin(uint8) FirmataCommandSetDigitalPinValueBuilder
	// WithOn adds On (property field)
	WithOn(bool) FirmataCommandSetDigitalPinValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() FirmataCommandBuilder
	// Build builds the FirmataCommandSetDigitalPinValue or returns an error if something is wrong
	Build() (FirmataCommandSetDigitalPinValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() FirmataCommandSetDigitalPinValue
}

// NewFirmataCommandSetDigitalPinValueBuilder() creates a FirmataCommandSetDigitalPinValueBuilder
func NewFirmataCommandSetDigitalPinValueBuilder() FirmataCommandSetDigitalPinValueBuilder {
	return &_FirmataCommandSetDigitalPinValueBuilder{_FirmataCommandSetDigitalPinValue: new(_FirmataCommandSetDigitalPinValue)}
}

type _FirmataCommandSetDigitalPinValueBuilder struct {
	*_FirmataCommandSetDigitalPinValue

	parentBuilder *_FirmataCommandBuilder

	collectedErr []error
}

var _ (FirmataCommandSetDigitalPinValueBuilder) = (*_FirmataCommandSetDigitalPinValueBuilder)(nil)

func (b *_FirmataCommandSetDigitalPinValueBuilder) setParent(contract FirmataCommandContract) {
	b.FirmataCommandContract = contract
	contract.(*_FirmataCommand)._SubType = b._FirmataCommandSetDigitalPinValue
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) WithMandatoryFields(pin uint8, on bool) FirmataCommandSetDigitalPinValueBuilder {
	return b.WithPin(pin).WithOn(on)
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) WithPin(pin uint8) FirmataCommandSetDigitalPinValueBuilder {
	b.Pin = pin
	return b
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) WithOn(on bool) FirmataCommandSetDigitalPinValueBuilder {
	b.On = on
	return b
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) Build() (FirmataCommandSetDigitalPinValue, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._FirmataCommandSetDigitalPinValue.deepCopy(), nil
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) MustBuild() FirmataCommandSetDigitalPinValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) Done() FirmataCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewFirmataCommandBuilder().(*_FirmataCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) buildForFirmataCommand() (FirmataCommand, error) {
	return b.Build()
}

func (b *_FirmataCommandSetDigitalPinValueBuilder) DeepCopy() any {
	_copy := b.CreateFirmataCommandSetDigitalPinValueBuilder().(*_FirmataCommandSetDigitalPinValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateFirmataCommandSetDigitalPinValueBuilder creates a FirmataCommandSetDigitalPinValueBuilder
func (b *_FirmataCommandSetDigitalPinValue) CreateFirmataCommandSetDigitalPinValueBuilder() FirmataCommandSetDigitalPinValueBuilder {
	if b == nil {
		return NewFirmataCommandSetDigitalPinValueBuilder()
	}
	return &_FirmataCommandSetDigitalPinValueBuilder{_FirmataCommandSetDigitalPinValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_FirmataCommandSetDigitalPinValue) GetCommandCode() uint8 {
	return 0x5
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_FirmataCommandSetDigitalPinValue) GetParent() FirmataCommandContract {
	return m.FirmataCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_FirmataCommandSetDigitalPinValue) GetPin() uint8 {
	return m.Pin
}

func (m *_FirmataCommandSetDigitalPinValue) GetOn() bool {
	return m.On
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastFirmataCommandSetDigitalPinValue(structType any) FirmataCommandSetDigitalPinValue {
	if casted, ok := structType.(FirmataCommandSetDigitalPinValue); ok {
		return casted
	}
	if casted, ok := structType.(*FirmataCommandSetDigitalPinValue); ok {
		return *casted
	}
	return nil
}

func (m *_FirmataCommandSetDigitalPinValue) GetTypeName() string {
	return "FirmataCommandSetDigitalPinValue"
}

func (m *_FirmataCommandSetDigitalPinValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.FirmataCommandContract.(*_FirmataCommand).getLengthInBits(ctx))

	// Simple field (pin)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (on)
	lengthInBits += 1

	return lengthInBits
}

func (m *_FirmataCommandSetDigitalPinValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_FirmataCommandSetDigitalPinValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_FirmataCommand, response bool) (__firmataCommandSetDigitalPinValue FirmataCommandSetDigitalPinValue, err error) {
	m.FirmataCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("FirmataCommandSetDigitalPinValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for FirmataCommandSetDigitalPinValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	pin, err := ReadSimpleField(ctx, "pin", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pin' field"))
	}
	m.Pin = pin

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	on, err := ReadSimpleField(ctx, "on", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'on' field"))
	}
	m.On = on

	if closeErr := readBuffer.CloseContext("FirmataCommandSetDigitalPinValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for FirmataCommandSetDigitalPinValue")
	}

	return m, nil
}

func (m *_FirmataCommandSetDigitalPinValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_FirmataCommandSetDigitalPinValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("FirmataCommandSetDigitalPinValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for FirmataCommandSetDigitalPinValue")
		}

		if err := WriteSimpleField[uint8](ctx, "pin", m.GetPin(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'pin' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "on", m.GetOn(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'on' field")
		}

		if popErr := writeBuffer.PopContext("FirmataCommandSetDigitalPinValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for FirmataCommandSetDigitalPinValue")
		}
		return nil
	}
	return m.FirmataCommandContract.(*_FirmataCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_FirmataCommandSetDigitalPinValue) IsFirmataCommandSetDigitalPinValue() {}

func (m *_FirmataCommandSetDigitalPinValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_FirmataCommandSetDigitalPinValue) deepCopy() *_FirmataCommandSetDigitalPinValue {
	if m == nil {
		return nil
	}
	_FirmataCommandSetDigitalPinValueCopy := &_FirmataCommandSetDigitalPinValue{
		m.FirmataCommandContract.(*_FirmataCommand).deepCopy(),
		m.Pin,
		m.On,
		m.reservedField0,
	}
	_FirmataCommandSetDigitalPinValueCopy.FirmataCommandContract.(*_FirmataCommand)._SubType = m
	return _FirmataCommandSetDigitalPinValueCopy
}

func (m *_FirmataCommandSetDigitalPinValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
