/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LDataFrame is the corresponding interface of LDataFrame
type LDataFrame interface {
	LDataFrameContract
	LDataFrameRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsLDataFrame is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLDataFrame()
	// CreateBuilder creates a LDataFrameBuilder
	CreateLDataFrameBuilder() LDataFrameBuilder
}

// LDataFrameContract provides a set of functions which can be overwritten by a sub struct
type LDataFrameContract interface {
	// GetFrameType returns FrameType (property field)
	GetFrameType() bool
	// GetNotRepeated returns NotRepeated (property field)
	GetNotRepeated() bool
	// GetPriority returns Priority (property field)
	GetPriority() CEMIPriority
	// GetAcknowledgeRequested returns AcknowledgeRequested (property field)
	GetAcknowledgeRequested() bool
	// GetErrorFlag returns ErrorFlag (property field)
	GetErrorFlag() bool
	// IsLDataFrame is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLDataFrame()
	// CreateBuilder creates a LDataFrameBuilder
	CreateLDataFrameBuilder() LDataFrameBuilder
}

// LDataFrameRequirements provides a set of functions which need to be implemented by a sub struct
type LDataFrameRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetNotAckFrame returns NotAckFrame (discriminator field)
	GetNotAckFrame() bool
	// GetPolling returns Polling (discriminator field)
	GetPolling() bool
}

// _LDataFrame is the data-structure of this message
type _LDataFrame struct {
	_SubType interface {
		LDataFrameContract
		LDataFrameRequirements
	}
	FrameType            bool
	NotRepeated          bool
	Priority             CEMIPriority
	AcknowledgeRequested bool
	ErrorFlag            bool
}

var _ LDataFrameContract = (*_LDataFrame)(nil)

// NewLDataFrame factory function for _LDataFrame
func NewLDataFrame(frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool) *_LDataFrame {
	return &_LDataFrame{FrameType: frameType, NotRepeated: notRepeated, Priority: priority, AcknowledgeRequested: acknowledgeRequested, ErrorFlag: errorFlag}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LDataFrameBuilder is a builder for LDataFrame
type LDataFrameBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool) LDataFrameBuilder
	// WithFrameType adds FrameType (property field)
	WithFrameType(bool) LDataFrameBuilder
	// WithNotRepeated adds NotRepeated (property field)
	WithNotRepeated(bool) LDataFrameBuilder
	// WithPriority adds Priority (property field)
	WithPriority(CEMIPriority) LDataFrameBuilder
	// WithAcknowledgeRequested adds AcknowledgeRequested (property field)
	WithAcknowledgeRequested(bool) LDataFrameBuilder
	// WithErrorFlag adds ErrorFlag (property field)
	WithErrorFlag(bool) LDataFrameBuilder
	// AsLDataExtended converts this build to a subType of LDataFrame. It is always possible to return to current builder using Done()
	AsLDataExtended() LDataExtendedBuilder
	// AsLPollData converts this build to a subType of LDataFrame. It is always possible to return to current builder using Done()
	AsLPollData() LPollDataBuilder
	// AsLDataFrameACK converts this build to a subType of LDataFrame. It is always possible to return to current builder using Done()
	AsLDataFrameACK() LDataFrameACKBuilder
	// Build builds the LDataFrame or returns an error if something is wrong
	PartialBuild() (LDataFrameContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() LDataFrameContract
	// Build builds the LDataFrame or returns an error if something is wrong
	Build() (LDataFrame, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LDataFrame
}

// NewLDataFrameBuilder() creates a LDataFrameBuilder
func NewLDataFrameBuilder() LDataFrameBuilder {
	return &_LDataFrameBuilder{_LDataFrame: new(_LDataFrame)}
}

type _LDataFrameChildBuilder interface {
	utils.Copyable
	setParent(LDataFrameContract)
	buildForLDataFrame() (LDataFrame, error)
}

type _LDataFrameBuilder struct {
	*_LDataFrame

	childBuilder _LDataFrameChildBuilder

	collectedErr []error
}

var _ (LDataFrameBuilder) = (*_LDataFrameBuilder)(nil)

func (b *_LDataFrameBuilder) WithMandatoryFields(frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool) LDataFrameBuilder {
	return b.WithFrameType(frameType).WithNotRepeated(notRepeated).WithPriority(priority).WithAcknowledgeRequested(acknowledgeRequested).WithErrorFlag(errorFlag)
}

func (b *_LDataFrameBuilder) WithFrameType(frameType bool) LDataFrameBuilder {
	b.FrameType = frameType
	return b
}

func (b *_LDataFrameBuilder) WithNotRepeated(notRepeated bool) LDataFrameBuilder {
	b.NotRepeated = notRepeated
	return b
}

func (b *_LDataFrameBuilder) WithPriority(priority CEMIPriority) LDataFrameBuilder {
	b.Priority = priority
	return b
}

func (b *_LDataFrameBuilder) WithAcknowledgeRequested(acknowledgeRequested bool) LDataFrameBuilder {
	b.AcknowledgeRequested = acknowledgeRequested
	return b
}

func (b *_LDataFrameBuilder) WithErrorFlag(errorFlag bool) LDataFrameBuilder {
	b.ErrorFlag = errorFlag
	return b
}

func (b *_LDataFrameBuilder) PartialBuild() (LDataFrameContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._LDataFrame.deepCopy(), nil
}

func (b *_LDataFrameBuilder) PartialMustBuild() LDataFrameContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LDataFrameBuilder) AsLDataExtended() LDataExtendedBuilder {
	if cb, ok := b.childBuilder.(LDataExtendedBuilder); ok {
		return cb
	}
	cb := NewLDataExtendedBuilder().(*_LDataExtendedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_LDataFrameBuilder) AsLPollData() LPollDataBuilder {
	if cb, ok := b.childBuilder.(LPollDataBuilder); ok {
		return cb
	}
	cb := NewLPollDataBuilder().(*_LPollDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_LDataFrameBuilder) AsLDataFrameACK() LDataFrameACKBuilder {
	if cb, ok := b.childBuilder.(LDataFrameACKBuilder); ok {
		return cb
	}
	cb := NewLDataFrameACKBuilder().(*_LDataFrameACKBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_LDataFrameBuilder) Build() (LDataFrame, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForLDataFrame()
}

func (b *_LDataFrameBuilder) MustBuild() LDataFrame {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LDataFrameBuilder) DeepCopy() any {
	_copy := b.CreateLDataFrameBuilder().(*_LDataFrameBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_LDataFrameChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateLDataFrameBuilder creates a LDataFrameBuilder
func (b *_LDataFrame) CreateLDataFrameBuilder() LDataFrameBuilder {
	if b == nil {
		return NewLDataFrameBuilder()
	}
	return &_LDataFrameBuilder{_LDataFrame: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LDataFrame) GetFrameType() bool {
	return m.FrameType
}

func (m *_LDataFrame) GetNotRepeated() bool {
	return m.NotRepeated
}

func (m *_LDataFrame) GetPriority() CEMIPriority {
	return m.Priority
}

func (m *_LDataFrame) GetAcknowledgeRequested() bool {
	return m.AcknowledgeRequested
}

func (m *_LDataFrame) GetErrorFlag() bool {
	return m.ErrorFlag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLDataFrame(structType any) LDataFrame {
	if casted, ok := structType.(LDataFrame); ok {
		return casted
	}
	if casted, ok := structType.(*LDataFrame); ok {
		return *casted
	}
	return nil
}

func (m *_LDataFrame) GetTypeName() string {
	return "LDataFrame"
}

func (m *_LDataFrame) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (frameType)
	lengthInBits += 1
	// Discriminator Field (polling)
	lengthInBits += 1

	// Simple field (notRepeated)
	lengthInBits += 1
	// Discriminator Field (notAckFrame)
	lengthInBits += 1

	// Simple field (priority)
	lengthInBits += 2

	// Simple field (acknowledgeRequested)
	lengthInBits += 1

	// Simple field (errorFlag)
	lengthInBits += 1

	return lengthInBits
}

func (m *_LDataFrame) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_LDataFrame) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func LDataFrameParse[T LDataFrame](ctx context.Context, theBytes []byte) (T, error) {
	return LDataFrameParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func LDataFrameParseWithBufferProducer[T LDataFrame]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := LDataFrameParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func LDataFrameParseWithBuffer[T LDataFrame](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_LDataFrame{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_LDataFrame) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__lDataFrame LDataFrame, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LDataFrame"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LDataFrame")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	frameType, err := ReadSimpleField(ctx, "frameType", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'frameType' field"))
	}
	m.FrameType = frameType

	polling, err := ReadDiscriminatorField[bool](ctx, "polling", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'polling' field"))
	}

	notRepeated, err := ReadSimpleField(ctx, "notRepeated", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notRepeated' field"))
	}
	m.NotRepeated = notRepeated

	notAckFrame, err := ReadDiscriminatorField[bool](ctx, "notAckFrame", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notAckFrame' field"))
	}

	priority, err := ReadEnumField[CEMIPriority](ctx, "priority", "CEMIPriority", ReadEnum(CEMIPriorityByValue, ReadUnsignedByte(readBuffer, uint8(2))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priority' field"))
	}
	m.Priority = priority

	acknowledgeRequested, err := ReadSimpleField(ctx, "acknowledgeRequested", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'acknowledgeRequested' field"))
	}
	m.AcknowledgeRequested = acknowledgeRequested

	errorFlag, err := ReadSimpleField(ctx, "errorFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'errorFlag' field"))
	}
	m.ErrorFlag = errorFlag

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child LDataFrame
	switch {
	case notAckFrame == bool(true) && polling == bool(false): // LDataExtended
		if _child, err = new(_LDataExtended).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LDataExtended for type-switch of LDataFrame")
		}
	case notAckFrame == bool(true) && polling == bool(true): // LPollData
		if _child, err = new(_LPollData).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LPollData for type-switch of LDataFrame")
		}
	case notAckFrame == bool(false): // LDataFrameACK
		if _child, err = new(_LDataFrameACK).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LDataFrameACK for type-switch of LDataFrame")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [notAckFrame=%v, polling=%v]", notAckFrame, polling)
	}

	if closeErr := readBuffer.CloseContext("LDataFrame"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LDataFrame")
	}

	return _child, nil
}

func (pm *_LDataFrame) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child LDataFrame, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("LDataFrame"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for LDataFrame")
	}

	if err := WriteSimpleField[bool](ctx, "frameType", m.GetFrameType(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'frameType' field")
	}

	if err := WriteDiscriminatorField(ctx, "polling", m.GetPolling(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'polling' field")
	}

	if err := WriteSimpleField[bool](ctx, "notRepeated", m.GetNotRepeated(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'notRepeated' field")
	}

	if err := WriteDiscriminatorField(ctx, "notAckFrame", m.GetNotAckFrame(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'notAckFrame' field")
	}

	if err := WriteSimpleEnumField[CEMIPriority](ctx, "priority", "CEMIPriority", m.GetPriority(), WriteEnum[CEMIPriority, uint8](CEMIPriority.GetValue, CEMIPriority.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 2))); err != nil {
		return errors.Wrap(err, "Error serializing 'priority' field")
	}

	if err := WriteSimpleField[bool](ctx, "acknowledgeRequested", m.GetAcknowledgeRequested(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'acknowledgeRequested' field")
	}

	if err := WriteSimpleField[bool](ctx, "errorFlag", m.GetErrorFlag(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'errorFlag' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("LDataFrame"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for LDataFrame")
	}
	return nil
}

func (m *_LDataFrame) IsLDataFrame() {}

func (m *_LDataFrame) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LDataFrame) deepCopy() *_LDataFrame {
	if m == nil {
		return nil
	}
	_LDataFrameCopy := &_LDataFrame{
		nil, // will be set by child
		m.FrameType,
		m.NotRepeated,
		m.Priority,
		m.AcknowledgeRequested,
		m.ErrorFlag,
	}
	return _LDataFrameCopy
}
