/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LldpSystemCapabilitiesMap is an enum
type LldpSystemCapabilitiesMap uint32

type ILldpSystemCapabilitiesMap interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapNone              LldpSystemCapabilitiesMap = 0
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapOther             LldpSystemCapabilitiesMap = 1
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRepeater          LldpSystemCapabilitiesMap = 2
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapBridge            LldpSystemCapabilitiesMap = 4
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapWlanAccessPoint   LldpSystemCapabilitiesMap = 8
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRouter            LldpSystemCapabilitiesMap = 16
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTelephone         LldpSystemCapabilitiesMap = 32
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapDocsisCableDevice LldpSystemCapabilitiesMap = 64
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapStationOnly       LldpSystemCapabilitiesMap = 128
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapCvlanComponent    LldpSystemCapabilitiesMap = 256
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapSvlanComponent    LldpSystemCapabilitiesMap = 512
	LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTwoPortMacRelay   LldpSystemCapabilitiesMap = 1024
)

var LldpSystemCapabilitiesMapValues []LldpSystemCapabilitiesMap

func init() {
	_ = errors.New
	LldpSystemCapabilitiesMapValues = []LldpSystemCapabilitiesMap{
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapNone,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapOther,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRepeater,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapBridge,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapWlanAccessPoint,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRouter,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTelephone,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapDocsisCableDevice,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapStationOnly,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapCvlanComponent,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapSvlanComponent,
		LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTwoPortMacRelay,
	}
}

func LldpSystemCapabilitiesMapByValue(value uint32) (enum LldpSystemCapabilitiesMap, ok bool) {
	switch value {
	case 0:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapNone, true
	case 1:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapOther, true
	case 1024:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTwoPortMacRelay, true
	case 128:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapStationOnly, true
	case 16:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRouter, true
	case 2:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRepeater, true
	case 256:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapCvlanComponent, true
	case 32:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTelephone, true
	case 4:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapBridge, true
	case 512:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapSvlanComponent, true
	case 64:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapDocsisCableDevice, true
	case 8:
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapWlanAccessPoint, true
	}
	return 0, false
}

func LldpSystemCapabilitiesMapByName(value string) (enum LldpSystemCapabilitiesMap, ok bool) {
	switch value {
	case "lldpSystemCapabilitiesMapNone":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapNone, true
	case "lldpSystemCapabilitiesMapOther":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapOther, true
	case "lldpSystemCapabilitiesMapTwoPortMacRelay":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTwoPortMacRelay, true
	case "lldpSystemCapabilitiesMapStationOnly":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapStationOnly, true
	case "lldpSystemCapabilitiesMapRouter":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRouter, true
	case "lldpSystemCapabilitiesMapRepeater":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRepeater, true
	case "lldpSystemCapabilitiesMapCvlanComponent":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapCvlanComponent, true
	case "lldpSystemCapabilitiesMapTelephone":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTelephone, true
	case "lldpSystemCapabilitiesMapBridge":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapBridge, true
	case "lldpSystemCapabilitiesMapSvlanComponent":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapSvlanComponent, true
	case "lldpSystemCapabilitiesMapDocsisCableDevice":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapDocsisCableDevice, true
	case "lldpSystemCapabilitiesMapWlanAccessPoint":
		return LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapWlanAccessPoint, true
	}
	return 0, false
}

func LldpSystemCapabilitiesMapKnows(value uint32) bool {
	for _, typeValue := range LldpSystemCapabilitiesMapValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastLldpSystemCapabilitiesMap(structType any) LldpSystemCapabilitiesMap {
	castFunc := func(typ any) LldpSystemCapabilitiesMap {
		if sLldpSystemCapabilitiesMap, ok := typ.(LldpSystemCapabilitiesMap); ok {
			return sLldpSystemCapabilitiesMap
		}
		return 0
	}
	return castFunc(structType)
}

func (m LldpSystemCapabilitiesMap) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m LldpSystemCapabilitiesMap) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func LldpSystemCapabilitiesMapParse(ctx context.Context, theBytes []byte) (LldpSystemCapabilitiesMap, error) {
	return LldpSystemCapabilitiesMapParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func LldpSystemCapabilitiesMapParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (LldpSystemCapabilitiesMap, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("LldpSystemCapabilitiesMap", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading LldpSystemCapabilitiesMap")
	}
	if enum, ok := LldpSystemCapabilitiesMapByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for LldpSystemCapabilitiesMap")
		return LldpSystemCapabilitiesMap(val), nil
	} else {
		return enum, nil
	}
}

func (e LldpSystemCapabilitiesMap) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e LldpSystemCapabilitiesMap) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("LldpSystemCapabilitiesMap", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e LldpSystemCapabilitiesMap) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e LldpSystemCapabilitiesMap) PLC4XEnumName() string {
	switch e {
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapNone:
		return "lldpSystemCapabilitiesMapNone"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapOther:
		return "lldpSystemCapabilitiesMapOther"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTwoPortMacRelay:
		return "lldpSystemCapabilitiesMapTwoPortMacRelay"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapStationOnly:
		return "lldpSystemCapabilitiesMapStationOnly"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRouter:
		return "lldpSystemCapabilitiesMapRouter"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapRepeater:
		return "lldpSystemCapabilitiesMapRepeater"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapCvlanComponent:
		return "lldpSystemCapabilitiesMapCvlanComponent"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapTelephone:
		return "lldpSystemCapabilitiesMapTelephone"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapBridge:
		return "lldpSystemCapabilitiesMapBridge"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapSvlanComponent:
		return "lldpSystemCapabilitiesMapSvlanComponent"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapDocsisCableDevice:
		return "lldpSystemCapabilitiesMapDocsisCableDevice"
	case LldpSystemCapabilitiesMap_lldpSystemCapabilitiesMapWlanAccessPoint:
		return "lldpSystemCapabilitiesMapWlanAccessPoint"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e LldpSystemCapabilitiesMap) String() string {
	return e.PLC4XEnumName()
}
