/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePublished is an enum
type OpcuaNodeIdServicesVariablePublished int32

type IOpcuaNodeIdServicesVariablePublished interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion                                                                          OpcuaNodeIdServicesVariablePublished = 14519
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData                                                                               OpcuaNodeIdServicesVariablePublished = 14548
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments                                                                 OpcuaNodeIdServicesVariablePublished = 14556
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments                                                                OpcuaNodeIdServicesVariablePublished = 14557
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments                                                              OpcuaNodeIdServicesVariablePublished = 14559
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments                                                             OpcuaNodeIdServicesVariablePublished = 14560
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments                                                            OpcuaNodeIdServicesVariablePublished = 14565
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments                                                           OpcuaNodeIdServicesVariablePublished = 14566
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments                                                         OpcuaNodeIdServicesVariablePublished = 14568
	OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments                                                        OpcuaNodeIdServicesVariablePublished = 14569
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier                                                                            OpcuaNodeIdServicesVariablePublished = 14586
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields                                                                                 OpcuaNodeIdServicesVariablePublished = 14587
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter                                                                                         OpcuaNodeIdServicesVariablePublished = 14588
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments                                                            OpcuaNodeIdServicesVariablePublished = 15053
	OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments                                                   OpcuaNodeIdServicesVariablePublished = 15055
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State                                                    OpcuaNodeIdServicesVariablePublished = 15224
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData                                                                               OpcuaNodeIdServicesVariablePublished = 15229
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments                                              OpcuaNodeIdServicesVariablePublished = 15483
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments                                             OpcuaNodeIdServicesVariablePublished = 15484
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments                                           OpcuaNodeIdServicesVariablePublished = 15486
	OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments                                                           OpcuaNodeIdServicesVariablePublished = 15517
	OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments                                                  OpcuaNodeIdServicesVariablePublished = 15518
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId                                                 OpcuaNodeIdServicesVariablePublished = 16720
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                         OpcuaNodeIdServicesVariablePublished = 16721
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount                                                   OpcuaNodeIdServicesVariablePublished = 16731
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId                                                                                OpcuaNodeIdServicesVariablePublished = 16759
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties                                         OpcuaNodeIdServicesVariablePublished = 17482
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel                                    OpcuaNodeIdServicesVariablePublished = 18872
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation                                    OpcuaNodeIdServicesVariablePublished = 18873
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active                             OpcuaNodeIdServicesVariablePublished = 18874
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification                     OpcuaNodeIdServicesVariablePublished = 18875
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                   OpcuaNodeIdServicesVariablePublished = 18876
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                    OpcuaNodeIdServicesVariablePublished = 18877
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError                                          OpcuaNodeIdServicesVariablePublished = 18878
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active                                   OpcuaNodeIdServicesVariablePublished = 18879
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification                           OpcuaNodeIdServicesVariablePublished = 18880
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                         OpcuaNodeIdServicesVariablePublished = 18881
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange                          OpcuaNodeIdServicesVariablePublished = 18882
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError                                            OpcuaNodeIdServicesVariablePublished = 18884
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError                                 OpcuaNodeIdServicesVariablePublished = 18886
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active                          OpcuaNodeIdServicesVariablePublished = 18887
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification                  OpcuaNodeIdServicesVariablePublished = 18888
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                OpcuaNodeIdServicesVariablePublished = 18889
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                 OpcuaNodeIdServicesVariablePublished = 18890
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                   OpcuaNodeIdServicesVariablePublished = 18891
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active            OpcuaNodeIdServicesVariablePublished = 18892
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification    OpcuaNodeIdServicesVariablePublished = 18893
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel  OpcuaNodeIdServicesVariablePublished = 18894
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange   OpcuaNodeIdServicesVariablePublished = 18895
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent                   OpcuaNodeIdServicesVariablePublished = 18896
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active            OpcuaNodeIdServicesVariablePublished = 18897
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification    OpcuaNodeIdServicesVariablePublished = 18898
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel  OpcuaNodeIdServicesVariablePublished = 18899
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange   OpcuaNodeIdServicesVariablePublished = 18900
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError                  OpcuaNodeIdServicesVariablePublished = 18901
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active           OpcuaNodeIdServicesVariablePublished = 18902
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification   OpcuaNodeIdServicesVariablePublished = 18903
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel OpcuaNodeIdServicesVariablePublished = 18904
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange  OpcuaNodeIdServicesVariablePublished = 18905
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent                        OpcuaNodeIdServicesVariablePublished = 18906
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active                 OpcuaNodeIdServicesVariablePublished = 18907
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification         OpcuaNodeIdServicesVariablePublished = 18908
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel       OpcuaNodeIdServicesVariablePublished = 18909
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange        OpcuaNodeIdServicesVariablePublished = 18910
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod                      OpcuaNodeIdServicesVariablePublished = 18911
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active               OpcuaNodeIdServicesVariablePublished = 18912
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification       OpcuaNodeIdServicesVariablePublished = 18913
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 18914
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange      OpcuaNodeIdServicesVariablePublished = 18915
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages                      OpcuaNodeIdServicesVariablePublished = 18917
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active               OpcuaNodeIdServicesVariablePublished = 18918
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification       OpcuaNodeIdServicesVariablePublished = 18919
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel     OpcuaNodeIdServicesVariablePublished = 18920
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange      OpcuaNodeIdServicesVariablePublished = 18921
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber                    OpcuaNodeIdServicesVariablePublished = 18922
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel   OpcuaNodeIdServicesVariablePublished = 18923
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode                               OpcuaNodeIdServicesVariablePublished = 18924
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel              OpcuaNodeIdServicesVariablePublished = 18925
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion                             OpcuaNodeIdServicesVariablePublished = 18926
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariablePublished = 18927
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion                             OpcuaNodeIdServicesVariablePublished = 18928
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel            OpcuaNodeIdServicesVariablePublished = 18929
	OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet                                                                                 OpcuaNodeIdServicesVariablePublished = 25521
)

var OpcuaNodeIdServicesVariablePublishedValues []OpcuaNodeIdServicesVariablePublished

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePublishedValues = []OpcuaNodeIdServicesVariablePublished{
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel,
		OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet,
	}
}

func OpcuaNodeIdServicesVariablePublishedByValue(value int32) (enum OpcuaNodeIdServicesVariablePublished, ok bool) {
	switch value {
	case 14519:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion, true
	case 14548:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData, true
	case 14556:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments, true
	case 14557:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments, true
	case 14559:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments, true
	case 14560:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments, true
	case 14565:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments, true
	case 14566:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments, true
	case 14568:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments, true
	case 14569:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments, true
	case 14586:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier, true
	case 14587:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields, true
	case 14588:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter, true
	case 15053:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments, true
	case 15055:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments, true
	case 15224:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State, true
	case 15229:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData, true
	case 15483:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments, true
	case 15484:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments, true
	case 15486:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case 15517:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments, true
	case 15518:
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments, true
	case 16720:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case 16721:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case 16731:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case 16759:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId, true
	case 17482:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case 18872:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case 18873:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case 18874:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case 18875:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case 18876:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case 18877:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case 18878:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case 18879:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case 18880:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case 18881:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case 18882:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case 18884:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case 18886:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case 18887:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case 18888:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case 18889:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case 18890:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case 18891:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case 18892:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case 18893:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case 18894:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case 18895:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case 18896:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case 18897:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case 18898:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case 18899:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case 18900:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case 18901:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case 18902:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case 18903:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case 18904:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case 18905:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case 18906:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case 18907:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case 18908:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case 18909:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case 18910:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case 18911:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case 18912:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case 18913:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case 18914:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case 18915:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case 18917:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case 18918:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case 18919:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case 18920:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case 18921:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case 18922:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case 18923:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case 18924:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case 18925:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case 18926:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case 18927:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case 18928:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case 18929:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case 25521:
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePublishedByName(value string) (enum OpcuaNodeIdServicesVariablePublished, ok bool) {
	switch value {
	case "PublishedDataSetType_ConfigurationVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion, true
	case "PublishedDataItemsType_PublishedData":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData, true
	case "PublishedDataItemsType_AddVariables_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments, true
	case "PublishedDataItemsType_AddVariables_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments, true
	case "PublishedDataItemsType_RemoveVariables_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments, true
	case "PublishedDataItemsType_RemoveVariables_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments, true
	case "PublishedDataItemsAddVariablesMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments, true
	case "PublishedDataItemsAddVariablesMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments, true
	case "PublishedDataItemsRemoveVariablesMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments, true
	case "PublishedDataItemsRemoveVariablesMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments, true
	case "PublishedEventsType_PubSubEventNotifier":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier, true
	case "PublishedEventsType_SelectedFields":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields, true
	case "PublishedEventsType_Filter":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter, true
	case "PublishedEventsType_ModifyFieldSelection_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments, true
	case "PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Status_State":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State, true
	case "PublishedDataSetType_DataSetMetaData":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData, true
	case "PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments, true
	case "PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments, true
	case "PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments, true
	case "PublishedEventsType_ModifyFieldSelection_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments, true
	case "PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount, true
	case "PublishedDataSetType_DataSetClassId":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel, true
	case "PublishedDataSetType_CyclicDataSet":
		return OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePublishedKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePublishedValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePublished(structType any) OpcuaNodeIdServicesVariablePublished {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePublished {
		if sOpcuaNodeIdServicesVariablePublished, ok := typ.(OpcuaNodeIdServicesVariablePublished); ok {
			return sOpcuaNodeIdServicesVariablePublished
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePublished) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePublished) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePublishedParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePublished, error) {
	return OpcuaNodeIdServicesVariablePublishedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePublishedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePublished, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePublished", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePublished")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePublishedByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePublished")
		return OpcuaNodeIdServicesVariablePublished(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePublished) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePublished) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePublished", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariablePublished) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePublished) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ConfigurationVersion:
		return "PublishedDataSetType_ConfigurationVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_PublishedData:
		return "PublishedDataItemsType_PublishedData"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_InputArguments:
		return "PublishedDataItemsType_AddVariables_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_AddVariables_OutputArguments:
		return "PublishedDataItemsType_AddVariables_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_InputArguments:
		return "PublishedDataItemsType_RemoveVariables_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsType_RemoveVariables_OutputArguments:
		return "PublishedDataItemsType_RemoveVariables_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_InputArguments:
		return "PublishedDataItemsAddVariablesMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsAddVariablesMethodType_OutputArguments:
		return "PublishedDataItemsAddVariablesMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_InputArguments:
		return "PublishedDataItemsRemoveVariablesMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataItemsRemoveVariablesMethodType_OutputArguments:
		return "PublishedDataItemsRemoveVariablesMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_PubSubEventNotifier:
		return "PublishedEventsType_PubSubEventNotifier"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_SelectedFields:
		return "PublishedEventsType_SelectedFields"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_Filter:
		return "PublishedEventsType_Filter"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_InputArguments:
		return "PublishedEventsType_ModifyFieldSelection_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments:
		return "PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Status_State:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Status_State"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetMetaData:
		return "PublishedDataSetType_DataSetMetaData"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments:
		return "PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments:
		return "PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments:
		return "PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsType_ModifyFieldSelection_OutputArguments:
		return "PublishedEventsType_ModifyFieldSelection_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments:
		return "PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetClassId:
		return "PublishedDataSetType_DataSetClassId"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel"
	case OpcuaNodeIdServicesVariablePublished_PublishedDataSetType_CyclicDataSet:
		return "PublishedDataSetType_CyclicDataSet"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePublished) String() string {
	return e.PLC4XEnumName()
}
