/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PublishRequest is the corresponding interface of PublishRequest
type PublishRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRequestHeader returns RequestHeader (property field)
	GetRequestHeader() RequestHeader
	// GetSubscriptionAcknowledgements returns SubscriptionAcknowledgements (property field)
	GetSubscriptionAcknowledgements() []SubscriptionAcknowledgement
	// IsPublishRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPublishRequest()
	// CreateBuilder creates a PublishRequestBuilder
	CreatePublishRequestBuilder() PublishRequestBuilder
}

// _PublishRequest is the data-structure of this message
type _PublishRequest struct {
	ExtensionObjectDefinitionContract
	RequestHeader                RequestHeader
	SubscriptionAcknowledgements []SubscriptionAcknowledgement
}

var _ PublishRequest = (*_PublishRequest)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PublishRequest)(nil)

// NewPublishRequest factory function for _PublishRequest
func NewPublishRequest(requestHeader RequestHeader, subscriptionAcknowledgements []SubscriptionAcknowledgement) *_PublishRequest {
	if requestHeader == nil {
		panic("requestHeader of type RequestHeader for PublishRequest must not be nil")
	}
	_result := &_PublishRequest{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RequestHeader:                     requestHeader,
		SubscriptionAcknowledgements:      subscriptionAcknowledgements,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PublishRequestBuilder is a builder for PublishRequest
type PublishRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(requestHeader RequestHeader, subscriptionAcknowledgements []SubscriptionAcknowledgement) PublishRequestBuilder
	// WithRequestHeader adds RequestHeader (property field)
	WithRequestHeader(RequestHeader) PublishRequestBuilder
	// WithRequestHeaderBuilder adds RequestHeader (property field) which is build by the builder
	WithRequestHeaderBuilder(func(RequestHeaderBuilder) RequestHeaderBuilder) PublishRequestBuilder
	// WithSubscriptionAcknowledgements adds SubscriptionAcknowledgements (property field)
	WithSubscriptionAcknowledgements(...SubscriptionAcknowledgement) PublishRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PublishRequest or returns an error if something is wrong
	Build() (PublishRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PublishRequest
}

// NewPublishRequestBuilder() creates a PublishRequestBuilder
func NewPublishRequestBuilder() PublishRequestBuilder {
	return &_PublishRequestBuilder{_PublishRequest: new(_PublishRequest)}
}

type _PublishRequestBuilder struct {
	*_PublishRequest

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (PublishRequestBuilder) = (*_PublishRequestBuilder)(nil)

func (b *_PublishRequestBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PublishRequest
}

func (b *_PublishRequestBuilder) WithMandatoryFields(requestHeader RequestHeader, subscriptionAcknowledgements []SubscriptionAcknowledgement) PublishRequestBuilder {
	return b.WithRequestHeader(requestHeader).WithSubscriptionAcknowledgements(subscriptionAcknowledgements...)
}

func (b *_PublishRequestBuilder) WithRequestHeader(requestHeader RequestHeader) PublishRequestBuilder {
	b.RequestHeader = requestHeader
	return b
}

func (b *_PublishRequestBuilder) WithRequestHeaderBuilder(builderSupplier func(RequestHeaderBuilder) RequestHeaderBuilder) PublishRequestBuilder {
	builder := builderSupplier(b.RequestHeader.CreateRequestHeaderBuilder())
	var err error
	b.RequestHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "RequestHeaderBuilder failed"))
	}
	return b
}

func (b *_PublishRequestBuilder) WithSubscriptionAcknowledgements(subscriptionAcknowledgements ...SubscriptionAcknowledgement) PublishRequestBuilder {
	b.SubscriptionAcknowledgements = subscriptionAcknowledgements
	return b
}

func (b *_PublishRequestBuilder) Build() (PublishRequest, error) {
	if b.RequestHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'requestHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._PublishRequest.deepCopy(), nil
}

func (b *_PublishRequestBuilder) MustBuild() PublishRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PublishRequestBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PublishRequestBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PublishRequestBuilder) DeepCopy() any {
	_copy := b.CreatePublishRequestBuilder().(*_PublishRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreatePublishRequestBuilder creates a PublishRequestBuilder
func (b *_PublishRequest) CreatePublishRequestBuilder() PublishRequestBuilder {
	if b == nil {
		return NewPublishRequestBuilder()
	}
	return &_PublishRequestBuilder{_PublishRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PublishRequest) GetExtensionId() int32 {
	return int32(826)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PublishRequest) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PublishRequest) GetRequestHeader() RequestHeader {
	return m.RequestHeader
}

func (m *_PublishRequest) GetSubscriptionAcknowledgements() []SubscriptionAcknowledgement {
	return m.SubscriptionAcknowledgements
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPublishRequest(structType any) PublishRequest {
	if casted, ok := structType.(PublishRequest); ok {
		return casted
	}
	if casted, ok := structType.(*PublishRequest); ok {
		return *casted
	}
	return nil
}

func (m *_PublishRequest) GetTypeName() string {
	return "PublishRequest"
}

func (m *_PublishRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (requestHeader)
	lengthInBits += m.RequestHeader.GetLengthInBits(ctx)

	// Implicit Field (noOfSubscriptionAcknowledgements)
	lengthInBits += 32

	// Array field
	if len(m.SubscriptionAcknowledgements) > 0 {
		for _curItem, element := range m.SubscriptionAcknowledgements {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SubscriptionAcknowledgements), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PublishRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PublishRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__publishRequest PublishRequest, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PublishRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PublishRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	requestHeader, err := ReadSimpleField[RequestHeader](ctx, "requestHeader", ReadComplex[RequestHeader](ExtensionObjectDefinitionParseWithBufferProducer[RequestHeader]((int32)(int32(391))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestHeader' field"))
	}
	m.RequestHeader = requestHeader

	noOfSubscriptionAcknowledgements, err := ReadImplicitField[int32](ctx, "noOfSubscriptionAcknowledgements", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSubscriptionAcknowledgements' field"))
	}
	_ = noOfSubscriptionAcknowledgements

	subscriptionAcknowledgements, err := ReadCountArrayField[SubscriptionAcknowledgement](ctx, "subscriptionAcknowledgements", ReadComplex[SubscriptionAcknowledgement](ExtensionObjectDefinitionParseWithBufferProducer[SubscriptionAcknowledgement]((int32)(int32(823))), readBuffer), uint64(noOfSubscriptionAcknowledgements))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subscriptionAcknowledgements' field"))
	}
	m.SubscriptionAcknowledgements = subscriptionAcknowledgements

	if closeErr := readBuffer.CloseContext("PublishRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PublishRequest")
	}

	return m, nil
}

func (m *_PublishRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PublishRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PublishRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PublishRequest")
		}

		if err := WriteSimpleField[RequestHeader](ctx, "requestHeader", m.GetRequestHeader(), WriteComplex[RequestHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestHeader' field")
		}
		noOfSubscriptionAcknowledgements := int32(utils.InlineIf(bool((m.GetSubscriptionAcknowledgements()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSubscriptionAcknowledgements()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSubscriptionAcknowledgements", noOfSubscriptionAcknowledgements, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSubscriptionAcknowledgements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "subscriptionAcknowledgements", m.GetSubscriptionAcknowledgements(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'subscriptionAcknowledgements' field")
		}

		if popErr := writeBuffer.PopContext("PublishRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PublishRequest")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PublishRequest) IsPublishRequest() {}

func (m *_PublishRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PublishRequest) deepCopy() *_PublishRequest {
	if m == nil {
		return nil
	}
	_PublishRequestCopy := &_PublishRequest{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[RequestHeader](m.RequestHeader),
		utils.DeepCopySlice[SubscriptionAcknowledgement, SubscriptionAcknowledgement](m.SubscriptionAcknowledgements),
	}
	_PublishRequestCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PublishRequestCopy
}

func (m *_PublishRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
