/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetAuthenticationPolicy implements Message {

  // Properties.
  protected final BACnetAuthenticationPolicyList policy;
  protected final BACnetContextTagBoolean orderEnforced;
  protected final BACnetContextTagUnsignedInteger timeout;

  public BACnetAuthenticationPolicy(
      BACnetAuthenticationPolicyList policy,
      BACnetContextTagBoolean orderEnforced,
      BACnetContextTagUnsignedInteger timeout) {
    super();
    this.policy = policy;
    this.orderEnforced = orderEnforced;
    this.timeout = timeout;
  }

  public BACnetAuthenticationPolicyList getPolicy() {
    return policy;
  }

  public BACnetContextTagBoolean getOrderEnforced() {
    return orderEnforced;
  }

  public BACnetContextTagUnsignedInteger getTimeout() {
    return timeout;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetAuthenticationPolicy");

    // Simple Field (policy)
    writeSimpleField("policy", policy, writeComplex(writeBuffer));

    // Simple Field (orderEnforced)
    writeSimpleField("orderEnforced", orderEnforced, writeComplex(writeBuffer));

    // Simple Field (timeout)
    writeSimpleField("timeout", timeout, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetAuthenticationPolicy");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetAuthenticationPolicy _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (policy)
    lengthInBits += policy.getLengthInBits();

    // Simple field (orderEnforced)
    lengthInBits += orderEnforced.getLengthInBits();

    // Simple field (timeout)
    lengthInBits += timeout.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetAuthenticationPolicy staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetAuthenticationPolicy");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetAuthenticationPolicyList policy =
        readSimpleField(
            "policy",
            readComplex(
                () -> BACnetAuthenticationPolicyList.staticParse(readBuffer, (short) (0)),
                readBuffer));

    BACnetContextTagBoolean orderEnforced =
        readSimpleField(
            "orderEnforced",
            readComplex(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    BACnetContextTagUnsignedInteger timeout =
        readSimpleField(
            "timeout",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    readBuffer.closeContext("BACnetAuthenticationPolicy");
    // Create the instance
    BACnetAuthenticationPolicy _bACnetAuthenticationPolicy;
    _bACnetAuthenticationPolicy = new BACnetAuthenticationPolicy(policy, orderEnforced, timeout);
    return _bACnetAuthenticationPolicy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetAuthenticationPolicy)) {
      return false;
    }
    BACnetAuthenticationPolicy that = (BACnetAuthenticationPolicy) o;
    return (getPolicy() == that.getPolicy())
        && (getOrderEnforced() == that.getOrderEnforced())
        && (getTimeout() == that.getTimeout())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPolicy(), getOrderEnforced(), getTimeout());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
