/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class BVLC implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getBvlcFunction();

  // Constant values.
  public static final Short BACNETTYPE = 0x81;

  public BVLC() {
    super();
  }

  public int getBvlcPayloadLength() {
    return (int) ((getLengthInBytes()) - (4));
  }

  public short getBacnetType() {
    return BACNETTYPE;
  }

  protected abstract void serializeBVLCChild(WriteBuffer writeBuffer) throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BVLC");

    // Const Field (bacnetType)
    writeConstField(
        "bacnetType",
        BACNETTYPE,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Discriminator Field (bvlcFunction) (Used as input to a switch field)
    writeDiscriminatorField(
        "bvlcFunction",
        getBvlcFunction(),
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (bvlcLength) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int bvlcLength = (int) (getLengthInBytes());
    writeImplicitField(
        "bvlcLength",
        bvlcLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    int bvlcPayloadLength = getBvlcPayloadLength();
    writeBuffer.writeVirtual("bvlcPayloadLength", bvlcPayloadLength);

    // Switch field (Serialize the sub-type)
    serializeBVLCChild(writeBuffer);

    writeBuffer.popContext("BVLC");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BVLC _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (bacnetType)
    lengthInBits += 8;

    // Discriminator Field (bvlcFunction)
    lengthInBits += 8;

    // Implicit Field (bvlcLength)
    lengthInBits += 16;

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static BVLC staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BVLC");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short bacnetType =
        readConstField(
            "bacnetType",
            readUnsignedShort(readBuffer, 8),
            BVLC.BACNETTYPE,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short bvlcFunction =
        readDiscriminatorField(
            "bvlcFunction",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int bvlcLength =
        readImplicitField(
            "bvlcLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
    int bvlcPayloadLength =
        readVirtualField(
            "bvlcPayloadLength",
            int.class,
            (bvlcLength) - (4),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    BVLCBuilder builder = null;
    if (EvaluationHelper.equals(bvlcFunction, (short) 0x00)) {
      builder = BVLCResult.staticParseBVLCBuilder(readBuffer);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x01)) {
      builder =
          BVLCWriteBroadcastDistributionTable.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x02)) {
      builder = BVLCReadBroadcastDistributionTable.staticParseBVLCBuilder(readBuffer);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x03)) {
      builder =
          BVLCReadBroadcastDistributionTableAck.staticParseBVLCBuilder(
              readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x04)) {
      builder = BVLCForwardedNPDU.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x05)) {
      builder = BVLCRegisterForeignDevice.staticParseBVLCBuilder(readBuffer);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x06)) {
      builder = BVLCReadForeignDeviceTable.staticParseBVLCBuilder(readBuffer);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x07)) {
      builder = BVLCReadForeignDeviceTableAck.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x08)) {
      builder = BVLCDeleteForeignDeviceTableEntry.staticParseBVLCBuilder(readBuffer);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x09)) {
      builder =
          BVLCDistributeBroadcastToNetwork.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x0A)) {
      builder = BVLCOriginalUnicastNPDU.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x0B)) {
      builder = BVLCOriginalBroadcastNPDU.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    } else if (EvaluationHelper.equals(bvlcFunction, (short) 0x0C)) {
      builder = BVLCSecureBVLL.staticParseBVLCBuilder(readBuffer, bvlcPayloadLength);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "bvlcFunction="
              + bvlcFunction
              + "]");
    }

    readBuffer.closeContext("BVLC");
    // Create the instance
    BVLC _bVLC = builder.build();
    return _bVLC;
  }

  public interface BVLCBuilder {
    BVLC build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BVLC)) {
      return false;
    }
    BVLC that = (BVLC) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
