/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ErrorReportingDataGeneric extends ErrorReportingData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final ErrorReportingSystemCategory systemCategory;
  protected final boolean mostRecent;
  protected final boolean acknowledge;
  protected final boolean mostSevere;
  protected final ErrorReportingSeverity severity;
  protected final short deviceId;
  protected final short errorData1;
  protected final short errorData2;

  public ErrorReportingDataGeneric(
      ErrorReportingCommandTypeContainer commandTypeContainer,
      ErrorReportingSystemCategory systemCategory,
      boolean mostRecent,
      boolean acknowledge,
      boolean mostSevere,
      ErrorReportingSeverity severity,
      short deviceId,
      short errorData1,
      short errorData2) {
    super(commandTypeContainer);
    this.systemCategory = systemCategory;
    this.mostRecent = mostRecent;
    this.acknowledge = acknowledge;
    this.mostSevere = mostSevere;
    this.severity = severity;
    this.deviceId = deviceId;
    this.errorData1 = errorData1;
    this.errorData2 = errorData2;
  }

  public ErrorReportingSystemCategory getSystemCategory() {
    return systemCategory;
  }

  public boolean getMostRecent() {
    return mostRecent;
  }

  public boolean getAcknowledge() {
    return acknowledge;
  }

  public boolean getMostSevere() {
    return mostSevere;
  }

  public ErrorReportingSeverity getSeverity() {
    return severity;
  }

  public short getDeviceId() {
    return deviceId;
  }

  public short getErrorData1() {
    return errorData1;
  }

  public short getErrorData2() {
    return errorData2;
  }

  public boolean getIsMostSevereError() {
    return (boolean) (getMostSevere());
  }

  public boolean getIsMostRecentError() {
    return (boolean) (getMostRecent());
  }

  public boolean getIsMostRecentAndMostSevere() {
    return (boolean) ((getIsMostRecentError()) && (getIsMostSevereError()));
  }

  @Override
  protected void serializeErrorReportingDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ErrorReportingDataGeneric");

    // Simple Field (systemCategory)
    writeSimpleField("systemCategory", systemCategory, writeComplex(writeBuffer));

    // Simple Field (mostRecent)
    writeSimpleField("mostRecent", mostRecent, writeBoolean(writeBuffer));

    // Simple Field (acknowledge)
    writeSimpleField("acknowledge", acknowledge, writeBoolean(writeBuffer));

    // Simple Field (mostSevere)
    writeSimpleField("mostSevere", mostSevere, writeBoolean(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isMostSevereError = getIsMostSevereError();
    writeBuffer.writeVirtual("isMostSevereError", isMostSevereError);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isMostRecentError = getIsMostRecentError();
    writeBuffer.writeVirtual("isMostRecentError", isMostRecentError);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isMostRecentAndMostSevere = getIsMostRecentAndMostSevere();
    writeBuffer.writeVirtual("isMostRecentAndMostSevere", isMostRecentAndMostSevere);

    // Simple Field (severity)
    writeSimpleEnumField(
        "severity",
        "ErrorReportingSeverity",
        severity,
        writeEnum(
            ErrorReportingSeverity::getValue,
            ErrorReportingSeverity::name,
            writeUnsignedByte(writeBuffer, 3)));

    // Simple Field (deviceId)
    writeSimpleField("deviceId", deviceId, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (errorData1)
    writeSimpleField("errorData1", errorData1, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (errorData2)
    writeSimpleField("errorData2", errorData2, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("ErrorReportingDataGeneric");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ErrorReportingDataGeneric _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (systemCategory)
    lengthInBits += systemCategory.getLengthInBits();

    // Simple field (mostRecent)
    lengthInBits += 1;

    // Simple field (acknowledge)
    lengthInBits += 1;

    // Simple field (mostSevere)
    lengthInBits += 1;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Simple field (severity)
    lengthInBits += 3;

    // Simple field (deviceId)
    lengthInBits += 8;

    // Simple field (errorData1)
    lengthInBits += 8;

    // Simple field (errorData2)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ErrorReportingDataBuilder staticParseErrorReportingDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("ErrorReportingDataGeneric");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ErrorReportingSystemCategory systemCategory =
        readSimpleField(
            "systemCategory",
            readComplex(() -> ErrorReportingSystemCategory.staticParse(readBuffer), readBuffer));

    boolean mostRecent = readSimpleField("mostRecent", readBoolean(readBuffer));

    boolean acknowledge = readSimpleField("acknowledge", readBoolean(readBuffer));

    boolean mostSevere = readSimpleField("mostSevere", readBoolean(readBuffer));
    // Validation
    if (!((mostRecent) || (mostSevere))) {
      throw new ParseValidationException("Invalid Error condition");
    }
    boolean isMostSevereError = readVirtualField("isMostSevereError", boolean.class, mostSevere);
    boolean isMostRecentError = readVirtualField("isMostRecentError", boolean.class, mostRecent);
    boolean isMostRecentAndMostSevere =
        readVirtualField(
            "isMostRecentAndMostSevere", boolean.class, (isMostRecentError) && (isMostSevereError));

    ErrorReportingSeverity severity =
        readEnumField(
            "severity",
            "ErrorReportingSeverity",
            readEnum(ErrorReportingSeverity::enumForValue, readUnsignedByte(readBuffer, 3)));

    short deviceId = readSimpleField("deviceId", readUnsignedShort(readBuffer, 8));

    short errorData1 = readSimpleField("errorData1", readUnsignedShort(readBuffer, 8));

    short errorData2 = readSimpleField("errorData2", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("ErrorReportingDataGeneric");
    // Create the instance
    return new ErrorReportingDataGenericBuilderImpl(
        systemCategory,
        mostRecent,
        acknowledge,
        mostSevere,
        severity,
        deviceId,
        errorData1,
        errorData2);
  }

  public static class ErrorReportingDataGenericBuilderImpl
      implements ErrorReportingData.ErrorReportingDataBuilder {
    private final ErrorReportingSystemCategory systemCategory;
    private final boolean mostRecent;
    private final boolean acknowledge;
    private final boolean mostSevere;
    private final ErrorReportingSeverity severity;
    private final short deviceId;
    private final short errorData1;
    private final short errorData2;

    public ErrorReportingDataGenericBuilderImpl(
        ErrorReportingSystemCategory systemCategory,
        boolean mostRecent,
        boolean acknowledge,
        boolean mostSevere,
        ErrorReportingSeverity severity,
        short deviceId,
        short errorData1,
        short errorData2) {
      this.systemCategory = systemCategory;
      this.mostRecent = mostRecent;
      this.acknowledge = acknowledge;
      this.mostSevere = mostSevere;
      this.severity = severity;
      this.deviceId = deviceId;
      this.errorData1 = errorData1;
      this.errorData2 = errorData2;
    }

    public ErrorReportingDataGeneric build(
        ErrorReportingCommandTypeContainer commandTypeContainer) {
      ErrorReportingDataGeneric errorReportingDataGeneric =
          new ErrorReportingDataGeneric(
              commandTypeContainer,
              systemCategory,
              mostRecent,
              acknowledge,
              mostSevere,
              severity,
              deviceId,
              errorData1,
              errorData2);
      return errorReportingDataGeneric;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ErrorReportingDataGeneric)) {
      return false;
    }
    ErrorReportingDataGeneric that = (ErrorReportingDataGeneric) o;
    return (getSystemCategory() == that.getSystemCategory())
        && (getMostRecent() == that.getMostRecent())
        && (getAcknowledge() == that.getAcknowledge())
        && (getMostSevere() == that.getMostSevere())
        && (getSeverity() == that.getSeverity())
        && (getDeviceId() == that.getDeviceId())
        && (getErrorData1() == that.getErrorData1())
        && (getErrorData2() == that.getErrorData2())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSystemCategory(),
        getMostRecent(),
        getAcknowledge(),
        getMostSevere(),
        getSeverity(),
        getDeviceId(),
        getErrorData1(),
        getErrorData2());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
