/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum MeasurementCommandTypeContainer {
  MeasurementCommandChannelMeasurementData(
      (short) 0x0E, (byte) 6, MeasurementCommandType.MEASUREMENT_EVENT);
  private static final Map<Short, MeasurementCommandTypeContainer> map;

  static {
    map = new HashMap<>();
    for (MeasurementCommandTypeContainer value : MeasurementCommandTypeContainer.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final byte numBytes;
  private final MeasurementCommandType commandType;

  MeasurementCommandTypeContainer(short value, byte numBytes, MeasurementCommandType commandType) {
    this.value = value;
    this.numBytes = numBytes;
    this.commandType = commandType;
  }

  public short getValue() {
    return value;
  }

  public byte getNumBytes() {
    return numBytes;
  }

  public static MeasurementCommandTypeContainer firstEnumForFieldNumBytes(byte fieldValue) {
    for (MeasurementCommandTypeContainer _val : MeasurementCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<MeasurementCommandTypeContainer> enumsForFieldNumBytes(byte fieldValue) {
    List<MeasurementCommandTypeContainer> _values = new ArrayList<>();
    for (MeasurementCommandTypeContainer _val : MeasurementCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public MeasurementCommandType getCommandType() {
    return commandType;
  }

  public static MeasurementCommandTypeContainer firstEnumForFieldCommandType(
      MeasurementCommandType fieldValue) {
    for (MeasurementCommandTypeContainer _val : MeasurementCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<MeasurementCommandTypeContainer> enumsForFieldCommandType(
      MeasurementCommandType fieldValue) {
    List<MeasurementCommandTypeContainer> _values = new ArrayList<>();
    for (MeasurementCommandTypeContainer _val : MeasurementCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static MeasurementCommandTypeContainer enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
