/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * Describes the contents of the node data
 */
@JsonPropertyOrder({
  MetaData.JSON_PROPERTY_NODE_CLASS,
  MetaData.JSON_PROPERTY_OPERATIONS,
  MetaData.JSON_PROPERTY_DESCRIPTION,
  MetaData.JSON_PROPERTY_DESCRIPTION_URL,
  MetaData.JSON_PROPERTY_DISPLAY_NAME,
  MetaData.JSON_PROPERTY_DISPLAY_FORMAT,
  MetaData.JSON_PROPERTY_UNIT,
  MetaData.JSON_PROPERTY_EXTENSIONS,
  MetaData.JSON_PROPERTY_REFERENCES
})
@JsonTypeName("MetaData")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class MetaData {
  public static final String JSON_PROPERTY_NODE_CLASS = "nodeClass";
  private NodeClass nodeClass;

  public static final String JSON_PROPERTY_OPERATIONS = "operations";
  private AllowedOperations operations;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DESCRIPTION_URL = "descriptionUrl";
  private String descriptionUrl;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DISPLAY_FORMAT = "displayFormat";
  private String displayFormat;

  public static final String JSON_PROPERTY_UNIT = "unit";
  private String unit;

  public static final String JSON_PROPERTY_EXTENSIONS = "extensions";
  private List<Extension> extensions = new ArrayList<>();

  public static final String JSON_PROPERTY_REFERENCES = "references";
  private List<Reference> references = new ArrayList<>();

  public MetaData() {
  }

  public MetaData nodeClass(NodeClass nodeClass) {
    
    this.nodeClass = nodeClass;
    return this;
  }

   /**
   * Get nodeClass
   * @return nodeClass
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NODE_CLASS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NodeClass getNodeClass() {
    return nodeClass;
  }


  @JsonProperty(JSON_PROPERTY_NODE_CLASS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNodeClass(NodeClass nodeClass) {
    this.nodeClass = nodeClass;
  }


  public MetaData operations(AllowedOperations operations) {
    
    this.operations = operations;
    return this;
  }

   /**
   * Get operations
   * @return operations
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AllowedOperations getOperations() {
    return operations;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOperations(AllowedOperations operations) {
    this.operations = operations;
  }


  public MetaData description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public MetaData descriptionUrl(String descriptionUrl) {
    
    this.descriptionUrl = descriptionUrl;
    return this;
  }

   /**
   * Get descriptionUrl
   * @return descriptionUrl
  **/
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DESCRIPTION_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionUrl() {
    return descriptionUrl;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptionUrl(String descriptionUrl) {
    this.descriptionUrl = descriptionUrl;
  }


  public MetaData displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public MetaData displayFormat(String displayFormat) {
    
    this.displayFormat = displayFormat;
    return this;
  }

   /**
   * Get displayFormat
   * @return displayFormat
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPLAY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayFormat() {
    return displayFormat;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayFormat(String displayFormat) {
    this.displayFormat = displayFormat;
  }


  public MetaData unit(String unit) {
    
    this.unit = unit;
    return this;
  }

   /**
   * Get unit
   * @return unit
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUnit() {
    return unit;
  }


  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnit(String unit) {
    this.unit = unit;
  }


  public MetaData extensions(List<Extension> extensions) {
    
    this.extensions = extensions;
    return this;
  }

  public MetaData addExtensionsItem(Extension extensionsItem) {
    if (this.extensions == null) {
      this.extensions = new ArrayList<>();
    }
    this.extensions.add(extensionsItem);
    return this;
  }

   /**
   * Get extensions
   * @return extensions
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXTENSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Extension> getExtensions() {
    return extensions;
  }


  @JsonProperty(JSON_PROPERTY_EXTENSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtensions(List<Extension> extensions) {
    this.extensions = extensions;
  }


  public MetaData references(List<Reference> references) {
    
    this.references = references;
    return this;
  }

  public MetaData addReferencesItem(Reference referencesItem) {
    if (this.references == null) {
      this.references = new ArrayList<>();
    }
    this.references.add(referencesItem);
    return this;
  }

   /**
   * Get references
   * @return references
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Reference> getReferences() {
    return references;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferences(List<Reference> references) {
    this.references = references;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetaData MetaData = (MetaData) o;
    return Objects.equals(this.nodeClass, MetaData.nodeClass) &&
        Objects.equals(this.operations, MetaData.operations) &&
        Objects.equals(this.description, MetaData.description) &&
        Objects.equals(this.descriptionUrl, MetaData.descriptionUrl) &&
        Objects.equals(this.displayName, MetaData.displayName) &&
        Objects.equals(this.displayFormat, MetaData.displayFormat) &&
        Objects.equals(this.unit, MetaData.unit) &&
        Objects.equals(this.extensions, MetaData.extensions) &&
        Objects.equals(this.references, MetaData.references);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nodeClass, operations, description, descriptionUrl, displayName, displayFormat, unit, extensions, references);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetaData {\n");
    sb.append("    nodeClass: ").append(toIndentedString(nodeClass)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    descriptionUrl: ").append(toIndentedString(descriptionUrl)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    displayFormat: ").append(toIndentedString(displayFormat)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    extensions: ").append(toIndentedString(extensions)).append("\n");
    sb.append("    references: ").append(toIndentedString(references)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `nodeClass` to the URL query string
    if (getNodeClass() != null) {
      try {
        joiner.add(String.format("%snodeClass%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNodeClass()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `operations` to the URL query string
    if (getOperations() != null) {
      joiner.add(getOperations().toUrlQueryString(prefix + "operations" + suffix));
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `descriptionUrl` to the URL query string
    if (getDescriptionUrl() != null) {
      try {
        joiner.add(String.format("%sdescriptionUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescriptionUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `displayName` to the URL query string
    if (getDisplayName() != null) {
      try {
        joiner.add(String.format("%sdisplayName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDisplayName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `displayFormat` to the URL query string
    if (getDisplayFormat() != null) {
      try {
        joiner.add(String.format("%sdisplayFormat%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDisplayFormat()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unit` to the URL query string
    if (getUnit() != null) {
      try {
        joiner.add(String.format("%sunit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `extensions` to the URL query string
    if (getExtensions() != null) {
      for (int i = 0; i < getExtensions().size(); i++) {
        if (getExtensions().get(i) != null) {
          joiner.add(getExtensions().get(i).toUrlQueryString(String.format("%sextensions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `references` to the URL query string
    if (getReferences() != null) {
      for (int i = 0; i < getReferences().size(); i++) {
        if (getReferences().get(i) != null) {
          joiner.add(getReferences().get(i).toUrlQueryString(String.format("%sreferences%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

