/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PortSegmentExtended extends PortSegmentType implements Message {

  // Accessors for discriminator values.
  public Boolean getExtendedLinkAddress() {
    return (boolean) true;
  }

  // Properties.
  protected final byte port;
  protected final short linkAddressSize;
  protected final String address;

  public PortSegmentExtended(byte port, short linkAddressSize, String address) {
    super();
    this.port = port;
    this.linkAddressSize = linkAddressSize;
    this.address = address;
  }

  public byte getPort() {
    return port;
  }

  public short getLinkAddressSize() {
    return linkAddressSize;
  }

  public String getAddress() {
    return address;
  }

  public short getPaddingByte() {
    return (short) ((getLinkAddressSize()) % (2));
  }

  @Override
  protected void serializePortSegmentTypeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PortSegmentExtended");

    // Simple Field (port)
    writeSimpleField("port", port, writeUnsignedByte(writeBuffer, 4));

    // Simple Field (linkAddressSize)
    writeSimpleField("linkAddressSize", linkAddressSize, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short paddingByte = getPaddingByte();
    writeBuffer.writeVirtual("paddingByte", paddingByte);

    // Simple Field (address)
    writeSimpleField(
        "address",
        address,
        writeString(writeBuffer, (((linkAddressSize) * (8))) + (((paddingByte) * (8)))));

    writeBuffer.popContext("PortSegmentExtended");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PortSegmentExtended _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (port)
    lengthInBits += 4;

    // Simple field (linkAddressSize)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (address)
    lengthInBits += (((getLinkAddressSize()) * (8))) + (((getPaddingByte()) * (8)));

    return lengthInBits;
  }

  public static PortSegmentTypeBuilder staticParsePortSegmentTypeBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PortSegmentExtended");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte port = readSimpleField("port", readUnsignedByte(readBuffer, 4));

    short linkAddressSize = readSimpleField("linkAddressSize", readUnsignedShort(readBuffer, 8));
    short paddingByte = readVirtualField("paddingByte", short.class, (linkAddressSize) % (2));

    String address =
        readSimpleField(
            "address",
            readString(readBuffer, (((linkAddressSize) * (8))) + (((paddingByte) * (8)))));

    readBuffer.closeContext("PortSegmentExtended");
    // Create the instance
    return new PortSegmentExtendedBuilderImpl(port, linkAddressSize, address);
  }

  public static class PortSegmentExtendedBuilderImpl
      implements PortSegmentType.PortSegmentTypeBuilder {
    private final byte port;
    private final short linkAddressSize;
    private final String address;

    public PortSegmentExtendedBuilderImpl(byte port, short linkAddressSize, String address) {
      this.port = port;
      this.linkAddressSize = linkAddressSize;
      this.address = address;
    }

    public PortSegmentExtended build() {
      PortSegmentExtended portSegmentExtended =
          new PortSegmentExtended(port, linkAddressSize, address);
      return portSegmentExtended;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PortSegmentExtended)) {
      return false;
    }
    PortSegmentExtended that = (PortSegmentExtended) o;
    return (getPort() == that.getPort())
        && (getLinkAddressSize() == that.getLinkAddressSize())
        && (getAddress() == that.getAddress())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPort(), getLinkAddressSize(), getAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
