/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApduDataExtAuthorizeResponse extends ApduDataExt implements Message {

  // Accessors for discriminator values.
  public Byte getExtApciType() {
    return (byte) 0x12;
  }

  // Properties.
  protected final short level;

  public ApduDataExtAuthorizeResponse(short level) {
    super();
    this.level = level;
  }

  public short getLevel() {
    return level;
  }

  @Override
  protected void serializeApduDataExtChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApduDataExtAuthorizeResponse");

    // Simple Field (level)
    writeSimpleField("level", level, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("ApduDataExtAuthorizeResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApduDataExtAuthorizeResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (level)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ApduDataExtBuilder staticParseApduDataExtBuilder(
      ReadBuffer readBuffer, Short length) throws ParseException {
    readBuffer.pullContext("ApduDataExtAuthorizeResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short level = readSimpleField("level", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("ApduDataExtAuthorizeResponse");
    // Create the instance
    return new ApduDataExtAuthorizeResponseBuilderImpl(level);
  }

  public static class ApduDataExtAuthorizeResponseBuilderImpl
      implements ApduDataExt.ApduDataExtBuilder {
    private final short level;

    public ApduDataExtAuthorizeResponseBuilderImpl(short level) {
      this.level = level;
    }

    public ApduDataExtAuthorizeResponse build() {
      ApduDataExtAuthorizeResponse apduDataExtAuthorizeResponse =
          new ApduDataExtAuthorizeResponse(level);
      return apduDataExtAuthorizeResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApduDataExtAuthorizeResponse)) {
      return false;
    }
    ApduDataExtAuthorizeResponse that = (ApduDataExtAuthorizeResponse) o;
    return (getLevel() == that.getLevel()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getLevel());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
