/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CertificateGroupDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15438;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final NodeId purpose;
  protected final List<NodeId> certificateTypes;
  protected final List<Boolean> isCertificateAssigned;
  protected final TrustListValidationOptions validationOptions;

  public CertificateGroupDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      NodeId purpose,
      List<NodeId> certificateTypes,
      List<Boolean> isCertificateAssigned,
      TrustListValidationOptions validationOptions) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.purpose = purpose;
    this.certificateTypes = certificateTypes;
    this.isCertificateAssigned = isCertificateAssigned;
    this.validationOptions = validationOptions;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public NodeId getPurpose() {
    return purpose;
  }

  public List<NodeId> getCertificateTypes() {
    return certificateTypes;
  }

  public List<Boolean> getIsCertificateAssigned() {
    return isCertificateAssigned;
  }

  public TrustListValidationOptions getValidationOptions() {
    return validationOptions;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CertificateGroupDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Simple Field (purpose)
    writeSimpleField("purpose", purpose, writeComplex(writeBuffer));

    // Implicit Field (noOfCertificateTypes) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfCertificateTypes =
        (int) ((((getCertificateTypes()) == (null)) ? -(1) : COUNT(getCertificateTypes())));
    writeImplicitField(
        "noOfCertificateTypes", noOfCertificateTypes, writeSignedInt(writeBuffer, 32));

    // Array Field (certificateTypes)
    writeComplexTypeArrayField("certificateTypes", certificateTypes, writeBuffer);

    // Implicit Field (noOfIsCertificateAssigned) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfIsCertificateAssigned =
        (int)
            ((((getIsCertificateAssigned()) == (null)) ? -(1) : COUNT(getIsCertificateAssigned())));
    writeImplicitField(
        "noOfIsCertificateAssigned", noOfIsCertificateAssigned, writeSignedInt(writeBuffer, 32));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Array Field (isCertificateAssigned)
    writeSimpleTypeArrayField(
        "isCertificateAssigned", isCertificateAssigned, writeBoolean(writeBuffer));

    // Simple Field (validationOptions)
    writeSimpleEnumField(
        "validationOptions",
        "TrustListValidationOptions",
        validationOptions,
        writeEnum(
            TrustListValidationOptions::getValue,
            TrustListValidationOptions::name,
            writeUnsignedLong(writeBuffer, 32)));

    writeBuffer.popContext("CertificateGroupDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CertificateGroupDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (purpose)
    lengthInBits += purpose.getLengthInBits();

    // Implicit Field (noOfCertificateTypes)
    lengthInBits += 32;

    // Array field
    if (certificateTypes != null) {
      int i = 0;
      for (NodeId element : certificateTypes) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= certificateTypes.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfIsCertificateAssigned)
    lengthInBits += 32;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Array field
    if (isCertificateAssigned != null) {
      lengthInBits += 1 * isCertificateAssigned.size();
    }

    // Simple field (validationOptions)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("CertificateGroupDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    NodeId purpose =
        readSimpleField("purpose", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    int noOfCertificateTypes =
        readImplicitField("noOfCertificateTypes", readSignedInt(readBuffer, 32));

    List<NodeId> certificateTypes =
        readCountArrayField(
            "certificateTypes",
            readComplex(() -> NodeId.staticParse(readBuffer), readBuffer),
            noOfCertificateTypes);

    int noOfIsCertificateAssigned =
        readImplicitField("noOfIsCertificateAssigned", readSignedInt(readBuffer, 32));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    List<Boolean> isCertificateAssigned =
        readCountArrayField(
            "isCertificateAssigned", readBoolean(readBuffer), noOfIsCertificateAssigned);

    TrustListValidationOptions validationOptions =
        readEnumField(
            "validationOptions",
            "TrustListValidationOptions",
            readEnum(TrustListValidationOptions::enumForValue, readUnsignedLong(readBuffer, 32)));

    readBuffer.closeContext("CertificateGroupDataType");
    // Create the instance
    return new CertificateGroupDataTypeBuilderImpl(
        name,
        recordProperties,
        purpose,
        certificateTypes,
        isCertificateAssigned,
        validationOptions);
  }

  public static class CertificateGroupDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final NodeId purpose;
    private final List<NodeId> certificateTypes;
    private final List<Boolean> isCertificateAssigned;
    private final TrustListValidationOptions validationOptions;

    public CertificateGroupDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        NodeId purpose,
        List<NodeId> certificateTypes,
        List<Boolean> isCertificateAssigned,
        TrustListValidationOptions validationOptions) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.purpose = purpose;
      this.certificateTypes = certificateTypes;
      this.isCertificateAssigned = isCertificateAssigned;
      this.validationOptions = validationOptions;
    }

    public CertificateGroupDataType build() {
      CertificateGroupDataType certificateGroupDataType =
          new CertificateGroupDataType(
              name,
              recordProperties,
              purpose,
              certificateTypes,
              isCertificateAssigned,
              validationOptions);
      return certificateGroupDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CertificateGroupDataType)) {
      return false;
    }
    CertificateGroupDataType that = (CertificateGroupDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getPurpose() == that.getPurpose())
        && (getCertificateTypes() == that.getCertificateTypes())
        && (getIsCertificateAssigned() == that.getIsCertificateAssigned())
        && (getValidationOptions() == that.getValidationOptions())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getPurpose(),
        getCertificateTypes(),
        getIsCertificateAssigned(),
        getValidationOptions());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
