/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class ExtensionObjectDefinition implements Message {

  // Abstract accessors for discriminator values.
  public abstract Integer getExtensionId();

  public ExtensionObjectDefinition() {
    super();
  }

  protected abstract void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ExtensionObjectDefinition");

    // Switch field (Serialize the sub-type)
    serializeExtensionObjectDefinitionChild(writeBuffer);

    writeBuffer.popContext("ExtensionObjectDefinition");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ExtensionObjectDefinition _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static ExtensionObjectDefinition staticParse(ReadBuffer readBuffer, Integer extensionId)
      throws ParseException {
    readBuffer.pullContext("ExtensionObjectDefinition");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    ExtensionObjectDefinitionBuilder builder = null;
    if (EvaluationHelper.equals(extensionId, (int) 0)) {
      builder = NullExtension.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12758)) {
      builder = Union.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14535)) {
      builder = KeyValuePair.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 16315)) {
      builder =
          AdditionalParametersType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 17550)) {
      builder =
          EphemeralKeyType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15530)) {
      builder = EndpointType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32423)) {
      builder =
          BitFieldDefinition.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18808)) {
      builder = RationalNumber.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18809)) {
      builder = OpcuaVector.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18811)) {
      builder =
          CartesianCoordinates.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18813)) {
      builder = Orientation.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18815)) {
      builder = Frame.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15636)) {
      builder =
          IdentityMappingRuleType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23500)) {
      builder =
          CurrencyUnitType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32436)) {
      builder =
          AnnotationDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32437)) {
      builder =
          LinearConversionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32440)) {
      builder =
          QuantityDimension.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12556)) {
      builder =
          TrustListDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15436)) {
      builder =
          BaseConfigurationDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15437)) {
      builder =
          BaseConfigurationRecordDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15438)) {
      builder =
          CertificateGroupDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15540)) {
      builder =
          ConfigurationUpdateTargetType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32287)) {
      builder =
          TransactionErrorType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15551)) {
      builder =
          ApplicationConfigurationDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15558)) {
      builder =
          ApplicationIdentityDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15559)) {
      builder =
          EndpointDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15560)) {
      builder =
          ServerEndpointDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15561)) {
      builder =
          SecuritySettingsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15562)) {
      builder =
          UserTokenSettingsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19447)) {
      builder =
          AuthorizationServiceConfigurationDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15536)) {
      builder =
          DataTypeSchemaHeader.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14527)) {
      builder =
          DataTypeDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15489)) {
      builder =
          StructureDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15490)) {
      builder =
          EnumDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15007)) {
      builder =
          SimpleTypeDescription.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15008)) {
      builder =
          UABinaryFileDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 24107)) {
      builder =
          PortableQualifiedName.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 24108)) {
      builder = PortableNodeId.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 24109)) {
      builder =
          UnsignedRationalNumber.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14525)) {
      builder =
          DataSetMetaDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14526)) {
      builder = FieldMetaData.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14595)) {
      builder =
          ConfigurationVersionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15580)) {
      builder =
          PublishedDataSetDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15582)) {
      builder =
          PublishedDataSetSourceDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14275)) {
      builder =
          PublishedVariableDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15583)) {
      builder =
          PublishedDataItemsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15584)) {
      builder =
          PublishedEventsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 25271)) {
      builder =
          PublishedDataSetCustomSourceDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18595)) {
      builder =
          ActionTargetDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18596)) {
      builder =
          PublishedActionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18599)) {
      builder =
          ActionMethodDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18795)) {
      builder =
          PublishedActionMethodDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15599)) {
      builder =
          DataSetWriterDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15600)) {
      builder =
          DataSetWriterTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15607)) {
      builder =
          DataSetWriterMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15611)) {
      builder =
          PubSubGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15482)) {
      builder =
          WriterGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15613)) {
      builder =
          WriterGroupTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15618)) {
      builder =
          WriterGroupMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15619)) {
      builder =
          PubSubConnectionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15620)) {
      builder =
          ConnectionTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15504)) {
      builder =
          NetworkAddressDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15512)) {
      builder =
          NetworkAddressUrlDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15522)) {
      builder =
          ReaderGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15623)) {
      builder =
          ReaderGroupTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15624)) {
      builder =
          ReaderGroupMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15625)) {
      builder =
          DataSetReaderDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15630)) {
      builder =
          DataSetReaderTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15631)) {
      builder =
          DataSetReaderMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15632)) {
      builder =
          SubscribedDataSetDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15633)) {
      builder =
          TargetVariablesDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 14746)) {
      builder =
          FieldTargetDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15637)) {
      builder =
          SubscribedDataSetMirrorDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15532)) {
      builder =
          PubSubConfigurationDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23601)) {
      builder =
          StandaloneSubscribedDataSetRefDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23602)) {
      builder =
          StandaloneSubscribedDataSetDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23603)) {
      builder =
          SecurityGroupDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 25272)) {
      builder =
          PubSubKeyPushTargetDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23604)) {
      builder =
          PubSubConfiguration2DataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15647)) {
      builder =
          UadpWriterGroupMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15654)) {
      builder =
          UadpDataSetWriterMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15655)) {
      builder =
          UadpDataSetReaderMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15659)) {
      builder =
          JsonWriterGroupMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15666)) {
      builder =
          JsonDataSetWriterMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15667)) {
      builder =
          JsonDataSetReaderMessageDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23605)) {
      builder = QosDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23606)) {
      builder =
          TransmitQosDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23607)) {
      builder =
          TransmitQosPriorityDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23610)) {
      builder =
          ReceiveQosDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23611)) {
      builder =
          ReceiveQosPriorityDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 17469)) {
      builder =
          DatagramConnectionTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23614)) {
      builder =
          DatagramConnectionTransport2DataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15534)) {
      builder =
          DatagramWriterGroupTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23615)) {
      builder =
          DatagramWriterGroupTransport2DataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23616)) {
      builder =
          DatagramDataSetReaderTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18796)) {
      builder =
          DtlsPubSubConnectionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15009)) {
      builder =
          BrokerConnectionTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15669)) {
      builder =
          BrokerWriterGroupTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15671)) {
      builder =
          BrokerDataSetWriterTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15672)) {
      builder =
          BrokerDataSetReaderTransportDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 25521)) {
      builder =
          PubSubConfigurationRefDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 25522)) {
      builder =
          PubSubConfigurationValueDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19313)) {
      builder =
          JsonNetworkMessage.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19314)) {
      builder =
          JsonDataSetMessage.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19315)) {
      builder =
          JsonDataSetMetaDataMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19316)) {
      builder =
          JsonApplicationDescriptionMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19317)) {
      builder =
          JsonServerEndpointsMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19318)) {
      builder =
          JsonStatusMessage.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19319)) {
      builder =
          JsonPubSubConnectionMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19320)) {
      builder =
          JsonActionMetaDataMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19321)) {
      builder =
          JsonActionResponderMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19322)) {
      builder =
          JsonActionNetworkMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19323)) {
      builder =
          JsonActionRequestMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19324)) {
      builder =
          JsonActionResponseMessage.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23470)) {
      builder =
          AliasNameDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 24283)) {
      builder =
          UserManagementDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 25222)) {
      builder =
          PriorityMappingEntryType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18955)) {
      builder =
          LldpManagementAddressTxPortType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18956)) {
      builder =
          LldpManagementAddressType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18957)) {
      builder = LldpTlvType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32661)) {
      builder =
          ReferenceDescriptionDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32662)) {
      builder =
          ReferenceListEntryDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19363)) {
      builder = LogRecord.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19747)) {
      builder =
          LogRecordsDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19748)) {
      builder =
          SpanContextDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19749)) {
      builder =
          TraceContextDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 19750)) {
      builder = NameValuePair.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 98)) {
      builder =
          RolePermissionType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 99)) {
      builder =
          DataTypeDefinition.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 103)) {
      builder = StructureField.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 101)) {
      builder =
          StructureDefinition.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 102)) {
      builder = EnumDefinition.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 298)) {
      builder = Argument.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 7596)) {
      builder = EnumValueType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 104)) {
      builder = EnumField.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12757)) {
      builder = OptionSet.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 8914)) {
      builder =
          TimeZoneDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 310)) {
      builder =
          ApplicationDescription.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 391)) {
      builder = RequestHeader.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 394)) {
      builder = ResponseHeader.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 397)) {
      builder = ServiceFault.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 15903)) {
      builder =
          SessionlessInvokeRequestType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 21001)) {
      builder =
          SessionlessInvokeResponseType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 422)) {
      builder =
          FindServersRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 425)) {
      builder =
          FindServersResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12191)) {
      builder =
          ServerOnNetwork.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12192)) {
      builder =
          FindServersOnNetworkRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12193)) {
      builder =
          FindServersOnNetworkResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 306)) {
      builder =
          UserTokenPolicy.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 314)) {
      builder =
          EndpointDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 428)) {
      builder =
          GetEndpointsRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 431)) {
      builder =
          GetEndpointsResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 434)) {
      builder =
          RegisteredServer.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 437)) {
      builder =
          RegisterServerRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 440)) {
      builder =
          RegisterServerResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12892)) {
      builder =
          DiscoveryConfiguration.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12893)) {
      builder =
          MdnsDiscoveryConfiguration.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12195)) {
      builder =
          RegisterServer2Request.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12196)) {
      builder =
          RegisterServer2Response.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 443)) {
      builder =
          ChannelSecurityToken.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 446)) {
      builder =
          OpenSecureChannelRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 449)) {
      builder =
          OpenSecureChannelResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 452)) {
      builder =
          CloseSecureChannelRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 455)) {
      builder =
          CloseSecureChannelResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 346)) {
      builder =
          SignedSoftwareCertificate.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 458)) {
      builder = SignatureData.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 461)) {
      builder =
          CreateSessionRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 464)) {
      builder =
          CreateSessionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 318)) {
      builder =
          UserIdentityToken.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 321)) {
      builder =
          AnonymousIdentityToken.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 324)) {
      builder =
          UserNameIdentityToken.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 327)) {
      builder =
          X509IdentityToken.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 940)) {
      builder =
          IssuedIdentityToken.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 467)) {
      builder =
          ActivateSessionRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 470)) {
      builder =
          ActivateSessionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 473)) {
      builder =
          CloseSessionRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 476)) {
      builder =
          CloseSessionResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 479)) {
      builder = CancelRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 482)) {
      builder = CancelResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 351)) {
      builder = NodeAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 354)) {
      builder =
          ObjectAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 357)) {
      builder =
          VariableAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 360)) {
      builder =
          MethodAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 363)) {
      builder =
          ObjectTypeAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 366)) {
      builder =
          VariableTypeAttributes.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 369)) {
      builder =
          ReferenceTypeAttributes.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 372)) {
      builder =
          DataTypeAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 375)) {
      builder = ViewAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 17608)) {
      builder =
          GenericAttributeValue.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 17609)) {
      builder =
          GenericAttributes.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 378)) {
      builder = AddNodesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 485)) {
      builder = AddNodesResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 488)) {
      builder =
          AddNodesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 491)) {
      builder =
          AddNodesResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 381)) {
      builder =
          AddReferencesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 494)) {
      builder =
          AddReferencesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 497)) {
      builder =
          AddReferencesResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 384)) {
      builder =
          DeleteNodesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 500)) {
      builder =
          DeleteNodesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 503)) {
      builder =
          DeleteNodesResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 387)) {
      builder =
          DeleteReferencesItem.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 506)) {
      builder =
          DeleteReferencesRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 509)) {
      builder =
          DeleteReferencesResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 513)) {
      builder =
          ViewDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 516)) {
      builder =
          BrowseDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 520)) {
      builder =
          ReferenceDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 524)) {
      builder = BrowseResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 527)) {
      builder = BrowseRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 530)) {
      builder = BrowseResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 533)) {
      builder =
          BrowseNextRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 536)) {
      builder =
          BrowseNextResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 539)) {
      builder =
          RelativePathElement.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 542)) {
      builder = RelativePath.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 545)) {
      builder = BrowsePath.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 548)) {
      builder =
          BrowsePathTarget.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 551)) {
      builder =
          BrowsePathResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 554)) {
      builder =
          TranslateBrowsePathsToNodeIdsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 557)) {
      builder =
          TranslateBrowsePathsToNodeIdsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 560)) {
      builder =
          RegisterNodesRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 563)) {
      builder =
          RegisterNodesResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 566)) {
      builder =
          UnregisterNodesRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 569)) {
      builder =
          UnregisterNodesResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 333)) {
      builder =
          EndpointConfiguration.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 572)) {
      builder =
          QueryDataDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 575)) {
      builder =
          NodeTypeDescription.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 579)) {
      builder = QueryDataSet.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 582)) {
      builder = NodeReference.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 585)) {
      builder =
          ContentFilterElement.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 588)) {
      builder = ContentFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 591)) {
      builder = FilterOperand.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 594)) {
      builder = ElementOperand.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 597)) {
      builder = LiteralOperand.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 600)) {
      builder =
          AttributeOperand.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 603)) {
      builder =
          SimpleAttributeOperand.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 606)) {
      builder =
          ContentFilterElementResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 609)) {
      builder =
          ContentFilterResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 612)) {
      builder = ParsingResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 615)) {
      builder =
          QueryFirstRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 618)) {
      builder =
          QueryFirstResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 621)) {
      builder =
          QueryNextRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 624)) {
      builder =
          QueryNextResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 628)) {
      builder = ReadValueId.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 631)) {
      builder = ReadRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 634)) {
      builder = ReadResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 637)) {
      builder =
          HistoryReadValueId.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 640)) {
      builder =
          HistoryReadResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 643)) {
      builder =
          HistoryReadDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 646)) {
      builder =
          ReadEventDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32801)) {
      builder =
          ReadEventDetails2.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18650)) {
      builder =
          SortRuleElement.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 18651)) {
      builder =
          ReadEventDetailsSorted.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 649)) {
      builder =
          ReadRawModifiedDetails.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 652)) {
      builder =
          ReadProcessedDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 655)) {
      builder =
          ReadAtTimeDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 23499)) {
      builder =
          ReadAnnotationDataDetails.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 658)) {
      builder = HistoryData.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 11218)) {
      builder =
          ModificationInfo.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 11219)) {
      builder =
          HistoryModifiedData.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 661)) {
      builder = HistoryEvent.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 32826)) {
      builder =
          HistoryModifiedEvent.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 664)) {
      builder =
          HistoryReadRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 667)) {
      builder =
          HistoryReadResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 670)) {
      builder = WriteValue.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 673)) {
      builder = WriteRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 676)) {
      builder = WriteResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 679)) {
      builder =
          HistoryUpdateDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 682)) {
      builder =
          UpdateDataDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 11297)) {
      builder =
          UpdateStructureDataDetails.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 685)) {
      builder =
          UpdateEventDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 688)) {
      builder =
          DeleteRawModifiedDetails.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 691)) {
      builder =
          DeleteAtTimeDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 694)) {
      builder =
          DeleteEventDetails.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 697)) {
      builder =
          HistoryUpdateResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 700)) {
      builder =
          HistoryUpdateRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 703)) {
      builder =
          HistoryUpdateResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 706)) {
      builder =
          CallMethodRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 709)) {
      builder =
          CallMethodResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 712)) {
      builder = CallRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 715)) {
      builder = CallResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 721)) {
      builder =
          MonitoringFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 724)) {
      builder =
          DataChangeFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 727)) {
      builder = EventFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 950)) {
      builder =
          AggregateConfiguration.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 730)) {
      builder =
          AggregateFilter.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 733)) {
      builder =
          MonitoringFilterResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 736)) {
      builder =
          EventFilterResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 739)) {
      builder =
          AggregateFilterResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 742)) {
      builder =
          MonitoringParameters.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 745)) {
      builder =
          MonitoredItemCreateRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 748)) {
      builder =
          MonitoredItemCreateResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 751)) {
      builder =
          CreateMonitoredItemsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 754)) {
      builder =
          CreateMonitoredItemsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 757)) {
      builder =
          MonitoredItemModifyRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 760)) {
      builder =
          MonitoredItemModifyResult.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 763)) {
      builder =
          ModifyMonitoredItemsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 766)) {
      builder =
          ModifyMonitoredItemsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 769)) {
      builder =
          SetMonitoringModeRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 772)) {
      builder =
          SetMonitoringModeResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 775)) {
      builder =
          SetTriggeringRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 778)) {
      builder =
          SetTriggeringResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 781)) {
      builder =
          DeleteMonitoredItemsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 784)) {
      builder =
          DeleteMonitoredItemsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 787)) {
      builder =
          CreateSubscriptionRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 790)) {
      builder =
          CreateSubscriptionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 793)) {
      builder =
          ModifySubscriptionRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 796)) {
      builder =
          ModifySubscriptionResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 799)) {
      builder =
          SetPublishingModeRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 802)) {
      builder =
          SetPublishingModeResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 805)) {
      builder =
          NotificationMessage.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 947)) {
      builder =
          NotificationData.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 811)) {
      builder =
          DataChangeNotification.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 808)) {
      builder =
          MonitoredItemNotification.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 916)) {
      builder =
          EventNotificationList.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 919)) {
      builder = EventFieldList.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 922)) {
      builder =
          HistoryEventFieldList.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 820)) {
      builder =
          StatusChangeNotification.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 823)) {
      builder =
          SubscriptionAcknowledgement.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 826)) {
      builder = PublishRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 829)) {
      builder =
          PublishResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 832)) {
      builder =
          RepublishRequest.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 835)) {
      builder =
          RepublishResponse.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 838)) {
      builder = TransferResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 841)) {
      builder =
          TransferSubscriptionsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 844)) {
      builder =
          TransferSubscriptionsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 847)) {
      builder =
          DeleteSubscriptionsRequest.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 850)) {
      builder =
          DeleteSubscriptionsResponse.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 340)) {
      builder = BuildInfo.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 855)) {
      builder =
          RedundantServerDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 11945)) {
      builder =
          EndpointUrlListDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 11946)) {
      builder =
          NetworkGroupDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 858)) {
      builder =
          SamplingIntervalDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 861)) {
      builder =
          ServerDiagnosticsSummaryDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 864)) {
      builder =
          ServerStatusDataType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 867)) {
      builder =
          SessionDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 870)) {
      builder =
          SessionSecurityDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 873)) {
      builder =
          ServiceCounterDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 301)) {
      builder = StatusResult.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 876)) {
      builder =
          SubscriptionDiagnosticsDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 879)) {
      builder =
          ModelChangeStructureDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 899)) {
      builder =
          SemanticChangeStructureDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 886)) {
      builder = Range.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 889)) {
      builder = EUInformation.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12173)) {
      builder =
          ComplexNumberType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12174)) {
      builder =
          DoubleComplexNumberType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12081)) {
      builder =
          AxisInformation.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 12082)) {
      builder = XVType.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 896)) {
      builder =
          ProgramDiagnosticDataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 24035)) {
      builder =
          ProgramDiagnostic2DataType.staticParseExtensionObjectDefinitionBuilder(
              readBuffer, extensionId);
    } else if (EvaluationHelper.equals(extensionId, (int) 893)) {
      builder = Annotation.staticParseExtensionObjectDefinitionBuilder(readBuffer, extensionId);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "extensionId="
              + extensionId
              + "]");
    }

    readBuffer.closeContext("ExtensionObjectDefinition");
    // Create the instance
    ExtensionObjectDefinition _extensionObjectDefinition = builder.build();
    return _extensionObjectDefinition;
  }

  public interface ExtensionObjectDefinitionBuilder {
    ExtensionObjectDefinition build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ExtensionObjectDefinition)) {
      return false;
    }
    ExtensionObjectDefinition that = (ExtensionObjectDefinition) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
