/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum FilterOperator {
  filterOperatorEquals((long) 0L),
  filterOperatorIsNull((long) 1L),
  filterOperatorGreaterThan((long) 2L),
  filterOperatorLessThan((long) 3L),
  filterOperatorGreaterThanOrEqual((long) 4L),
  filterOperatorLessThanOrEqual((long) 5L),
  filterOperatorLike((long) 6L),
  filterOperatorNot((long) 7L),
  filterOperatorBetween((long) 8L),
  filterOperatorInList((long) 9L),
  filterOperatorAnd((long) 10L),
  filterOperatorOr((long) 11L),
  filterOperatorCast((long) 12L),
  filterOperatorInView((long) 13L),
  filterOperatorOfType((long) 14L),
  filterOperatorRelatedTo((long) 15L),
  filterOperatorBitwiseAnd((long) 16L),
  filterOperatorBitwiseOr((long) 17L);
  private static final Map<Long, FilterOperator> map;

  static {
    map = new HashMap<>();
    for (FilterOperator value : FilterOperator.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  FilterOperator(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static FilterOperator enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
