/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageLastTighteningResultDataRev1
    extends OpenProtocolMessageLastTighteningResultData implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 1;
  }

  // Constant values.
  public static final Integer BLOCKIDCELLID = 1;
  public static final Integer BLOCKIDCHANNELID = 2;
  public static final Integer BLOCKIDTORQUECONTROLLERNAME = 3;
  public static final Integer BLOCKIDVINNUMBER = 4;
  public static final Integer BLOCKIDJOBID = 5;
  public static final Integer BLOCKIDPARAMETERSETID = 6;
  public static final Integer BLOCKIDBATCHSIZE = 7;
  public static final Integer BLOCKIDBATCHCOUNTER = 8;
  public static final Integer BLOCKIDTIGHTENINGSTATUS = 9;
  public static final Integer BLOCKIDTORQUESTATUS = 10;
  public static final Integer BLOCKIDANGLESTATUS = 11;
  public static final Integer BLOCKIDTORQUEMINLIMIT = 12;
  public static final Integer BLOCKIDTORQUEMAXLIMIT = 13;
  public static final Integer BLOCKIDTORQUEFINALTARGET = 14;
  public static final Integer BLOCKIDTORQUE = 15;
  public static final Integer BLOCKIDANGLEMIN = 16;
  public static final Integer BLOCKIDANGLEMAX = 17;
  public static final Integer BLOCKIDFINALANGLETARGET = 18;
  public static final Integer BLOCKIDANGLE = 19;
  public static final Integer BLOCKIDTIMESTAMP = 20;
  public static final Integer BLOCKIDDATETIMEOFLASTCHANGEINDPARAMETERSETSETTINGS = 21;
  public static final Integer BLOCKIDBATCHSTATUS = 22;
  public static final Integer BLOCKIDTIGHTENINGID = 23;

  // Properties.
  protected final long cellId;
  protected final int channelId;
  protected final String torqueControllerName;
  protected final String vinNumber;
  protected final int jobId;
  protected final int parameterSetId;
  protected final long batchSize;
  protected final long batchCounter;
  protected final NokOk tighteningStatus;
  protected final Status torqueStatus;
  protected final Status angleStatus;
  protected final long torqueMinLimit;
  protected final long torqueMaxLimit;
  protected final long torqueFinalTarget;
  protected final long torque;
  protected final long angleMin;
  protected final long angleMax;
  protected final long finalAngleTarget;
  protected final long angle;
  protected final String timeStamp;
  protected final String dateTimeOfLastChangeIndParameterSetSettings;
  protected final BatchStatus batchStatus;
  protected final String tighteningId;

  public OpenProtocolMessageLastTighteningResultDataRev1(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      long cellId,
      int channelId,
      String torqueControllerName,
      String vinNumber,
      int jobId,
      int parameterSetId,
      long batchSize,
      long batchCounter,
      NokOk tighteningStatus,
      Status torqueStatus,
      Status angleStatus,
      long torqueMinLimit,
      long torqueMaxLimit,
      long torqueFinalTarget,
      long torque,
      long angleMin,
      long angleMax,
      long finalAngleTarget,
      long angle,
      String timeStamp,
      String dateTimeOfLastChangeIndParameterSetSettings,
      BatchStatus batchStatus,
      String tighteningId) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.cellId = cellId;
    this.channelId = channelId;
    this.torqueControllerName = torqueControllerName;
    this.vinNumber = vinNumber;
    this.jobId = jobId;
    this.parameterSetId = parameterSetId;
    this.batchSize = batchSize;
    this.batchCounter = batchCounter;
    this.tighteningStatus = tighteningStatus;
    this.torqueStatus = torqueStatus;
    this.angleStatus = angleStatus;
    this.torqueMinLimit = torqueMinLimit;
    this.torqueMaxLimit = torqueMaxLimit;
    this.torqueFinalTarget = torqueFinalTarget;
    this.torque = torque;
    this.angleMin = angleMin;
    this.angleMax = angleMax;
    this.finalAngleTarget = finalAngleTarget;
    this.angle = angle;
    this.timeStamp = timeStamp;
    this.dateTimeOfLastChangeIndParameterSetSettings = dateTimeOfLastChangeIndParameterSetSettings;
    this.batchStatus = batchStatus;
    this.tighteningId = tighteningId;
  }

  public long getCellId() {
    return cellId;
  }

  public int getChannelId() {
    return channelId;
  }

  public String getTorqueControllerName() {
    return torqueControllerName;
  }

  public String getVinNumber() {
    return vinNumber;
  }

  public int getJobId() {
    return jobId;
  }

  public int getParameterSetId() {
    return parameterSetId;
  }

  public long getBatchSize() {
    return batchSize;
  }

  public long getBatchCounter() {
    return batchCounter;
  }

  public NokOk getTighteningStatus() {
    return tighteningStatus;
  }

  public Status getTorqueStatus() {
    return torqueStatus;
  }

  public Status getAngleStatus() {
    return angleStatus;
  }

  public long getTorqueMinLimit() {
    return torqueMinLimit;
  }

  public long getTorqueMaxLimit() {
    return torqueMaxLimit;
  }

  public long getTorqueFinalTarget() {
    return torqueFinalTarget;
  }

  public long getTorque() {
    return torque;
  }

  public long getAngleMin() {
    return angleMin;
  }

  public long getAngleMax() {
    return angleMax;
  }

  public long getFinalAngleTarget() {
    return finalAngleTarget;
  }

  public long getAngle() {
    return angle;
  }

  public String getTimeStamp() {
    return timeStamp;
  }

  public String getDateTimeOfLastChangeIndParameterSetSettings() {
    return dateTimeOfLastChangeIndParameterSetSettings;
  }

  public BatchStatus getBatchStatus() {
    return batchStatus;
  }

  public String getTighteningId() {
    return tighteningId;
  }

  public int getBlockIdCellId() {
    return BLOCKIDCELLID;
  }

  public int getBlockIdChannelId() {
    return BLOCKIDCHANNELID;
  }

  public int getBlockIdTorqueControllerName() {
    return BLOCKIDTORQUECONTROLLERNAME;
  }

  public int getBlockIdVinNumber() {
    return BLOCKIDVINNUMBER;
  }

  public int getBlockIdJobId() {
    return BLOCKIDJOBID;
  }

  public int getBlockIdParameterSetId() {
    return BLOCKIDPARAMETERSETID;
  }

  public int getBlockIdBatchSize() {
    return BLOCKIDBATCHSIZE;
  }

  public int getBlockIdBatchCounter() {
    return BLOCKIDBATCHCOUNTER;
  }

  public int getBlockIdTighteningStatus() {
    return BLOCKIDTIGHTENINGSTATUS;
  }

  public int getBlockIdTorqueStatus() {
    return BLOCKIDTORQUESTATUS;
  }

  public int getBlockIdAngleStatus() {
    return BLOCKIDANGLESTATUS;
  }

  public int getBlockIdTorqueMinLimit() {
    return BLOCKIDTORQUEMINLIMIT;
  }

  public int getBlockIdTorqueMaxLimit() {
    return BLOCKIDTORQUEMAXLIMIT;
  }

  public int getBlockIdTorqueFinalTarget() {
    return BLOCKIDTORQUEFINALTARGET;
  }

  public int getBlockIdTorque() {
    return BLOCKIDTORQUE;
  }

  public int getBlockIdAngleMin() {
    return BLOCKIDANGLEMIN;
  }

  public int getBlockIdAngleMax() {
    return BLOCKIDANGLEMAX;
  }

  public int getBlockIdFinalAngleTarget() {
    return BLOCKIDFINALANGLETARGET;
  }

  public int getBlockIdAngle() {
    return BLOCKIDANGLE;
  }

  public int getBlockIdTimeStamp() {
    return BLOCKIDTIMESTAMP;
  }

  public int getBlockIdDateTimeOfLastChangeIndParameterSetSettings() {
    return BLOCKIDDATETIMEOFLASTCHANGEINDPARAMETERSETSETTINGS;
  }

  public int getBlockIdBatchStatus() {
    return BLOCKIDBATCHSTATUS;
  }

  public int getBlockIdTighteningId() {
    return BLOCKIDTIGHTENINGID;
  }

  @Override
  protected void serializeOpenProtocolMessageLastTighteningResultDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageLastTighteningResultDataRev1");

    // Const Field (blockIdCellId)
    writeConstField(
        "blockIdCellId",
        BLOCKIDCELLID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (cellId)
    writeSimpleField(
        "cellId", cellId, writeUnsignedLong(writeBuffer, 32), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdChannelId)
    writeConstField(
        "blockIdChannelId",
        BLOCKIDCHANNELID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (channelId)
    writeSimpleField(
        "channelId",
        channelId,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueControllerName)
    writeConstField(
        "blockIdTorqueControllerName",
        BLOCKIDTORQUECONTROLLERNAME,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueControllerName)
    writeSimpleField(
        "torqueControllerName",
        torqueControllerName,
        writeString(writeBuffer, 200),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdVinNumber)
    writeConstField(
        "blockIdVinNumber",
        BLOCKIDVINNUMBER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (vinNumber)
    writeSimpleField(
        "vinNumber", vinNumber, writeString(writeBuffer, 200), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdJobId)
    writeConstField(
        "blockIdJobId",
        BLOCKIDJOBID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (jobId)
    writeSimpleField(
        "jobId", jobId, writeUnsignedInt(writeBuffer, 16), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdParameterSetId)
    writeConstField(
        "blockIdParameterSetId",
        BLOCKIDPARAMETERSETID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (parameterSetId)
    writeSimpleField(
        "parameterSetId",
        parameterSetId,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchSize)
    writeConstField(
        "blockIdBatchSize",
        BLOCKIDBATCHSIZE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchSize)
    writeSimpleField(
        "batchSize",
        batchSize,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchCounter)
    writeConstField(
        "blockIdBatchCounter",
        BLOCKIDBATCHCOUNTER,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchCounter)
    writeSimpleField(
        "batchCounter",
        batchCounter,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningStatus)
    writeConstField(
        "blockIdTighteningStatus",
        BLOCKIDTIGHTENINGSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningStatus)
    writeSimpleEnumField(
        "tighteningStatus",
        "NokOk",
        tighteningStatus,
        writeEnum(NokOk::getValue, NokOk::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueStatus)
    writeConstField(
        "blockIdTorqueStatus",
        BLOCKIDTORQUESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueStatus)
    writeSimpleEnumField(
        "torqueStatus",
        "Status",
        torqueStatus,
        writeEnum(Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleStatus)
    writeConstField(
        "blockIdAngleStatus",
        BLOCKIDANGLESTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleStatus)
    writeSimpleEnumField(
        "angleStatus",
        "Status",
        angleStatus,
        writeEnum(Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueMinLimit)
    writeConstField(
        "blockIdTorqueMinLimit",
        BLOCKIDTORQUEMINLIMIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueMinLimit)
    writeSimpleField(
        "torqueMinLimit",
        torqueMinLimit,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueMaxLimit)
    writeConstField(
        "blockIdTorqueMaxLimit",
        BLOCKIDTORQUEMAXLIMIT,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueMaxLimit)
    writeSimpleField(
        "torqueMaxLimit",
        torqueMaxLimit,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorqueFinalTarget)
    writeConstField(
        "blockIdTorqueFinalTarget",
        BLOCKIDTORQUEFINALTARGET,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueFinalTarget)
    writeSimpleField(
        "torqueFinalTarget",
        torqueFinalTarget,
        writeUnsignedLong(writeBuffer, 48),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTorque)
    writeConstField(
        "blockIdTorque",
        BLOCKIDTORQUE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torque)
    writeSimpleField(
        "torque", torque, writeUnsignedLong(writeBuffer, 48), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleMin)
    writeConstField(
        "blockIdAngleMin",
        BLOCKIDANGLEMIN,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleMin)
    writeSimpleField(
        "angleMin", angleMin, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngleMax)
    writeConstField(
        "blockIdAngleMax",
        BLOCKIDANGLEMAX,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleMax)
    writeSimpleField(
        "angleMax", angleMax, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdFinalAngleTarget)
    writeConstField(
        "blockIdFinalAngleTarget",
        BLOCKIDFINALANGLETARGET,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (finalAngleTarget)
    writeSimpleField(
        "finalAngleTarget",
        finalAngleTarget,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdAngle)
    writeConstField(
        "blockIdAngle",
        BLOCKIDANGLE,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angle)
    writeSimpleField(
        "angle", angle, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTimeStamp)
    writeConstField(
        "blockIdTimeStamp",
        BLOCKIDTIMESTAMP,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (timeStamp)
    writeSimpleField(
        "timeStamp", timeStamp, writeString(writeBuffer, 152), WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdDateTimeOfLastChangeIndParameterSetSettings)
    writeConstField(
        "blockIdDateTimeOfLastChangeIndParameterSetSettings",
        BLOCKIDDATETIMEOFLASTCHANGEINDPARAMETERSETSETTINGS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (dateTimeOfLastChangeIndParameterSetSettings)
    writeSimpleField(
        "dateTimeOfLastChangeIndParameterSetSettings",
        dateTimeOfLastChangeIndParameterSetSettings,
        writeString(writeBuffer, 152),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdBatchStatus)
    writeConstField(
        "blockIdBatchStatus",
        BLOCKIDBATCHSTATUS,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchStatus)
    writeSimpleEnumField(
        "batchStatus",
        "BatchStatus",
        batchStatus,
        writeEnum(BatchStatus::getValue, BatchStatus::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Const Field (blockIdTighteningId)
    writeConstField(
        "blockIdTighteningId",
        BLOCKIDTIGHTENINGID,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningId)
    writeSimpleField(
        "tighteningId",
        tighteningId,
        writeString(writeBuffer, 80),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageLastTighteningResultDataRev1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageLastTighteningResultDataRev1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (blockIdCellId)
    lengthInBits += 16;

    // Simple field (cellId)
    lengthInBits += 32;

    // Const Field (blockIdChannelId)
    lengthInBits += 16;

    // Simple field (channelId)
    lengthInBits += 16;

    // Const Field (blockIdTorqueControllerName)
    lengthInBits += 16;

    // Simple field (torqueControllerName)
    lengthInBits += 200;

    // Const Field (blockIdVinNumber)
    lengthInBits += 16;

    // Simple field (vinNumber)
    lengthInBits += 200;

    // Const Field (blockIdJobId)
    lengthInBits += 16;

    // Simple field (jobId)
    lengthInBits += 16;

    // Const Field (blockIdParameterSetId)
    lengthInBits += 16;

    // Simple field (parameterSetId)
    lengthInBits += 24;

    // Const Field (blockIdBatchSize)
    lengthInBits += 16;

    // Simple field (batchSize)
    lengthInBits += 32;

    // Const Field (blockIdBatchCounter)
    lengthInBits += 16;

    // Simple field (batchCounter)
    lengthInBits += 32;

    // Const Field (blockIdTighteningStatus)
    lengthInBits += 16;

    // Simple field (tighteningStatus)
    lengthInBits += 8;

    // Const Field (blockIdTorqueStatus)
    lengthInBits += 16;

    // Simple field (torqueStatus)
    lengthInBits += 8;

    // Const Field (blockIdAngleStatus)
    lengthInBits += 16;

    // Simple field (angleStatus)
    lengthInBits += 8;

    // Const Field (blockIdTorqueMinLimit)
    lengthInBits += 16;

    // Simple field (torqueMinLimit)
    lengthInBits += 48;

    // Const Field (blockIdTorqueMaxLimit)
    lengthInBits += 16;

    // Simple field (torqueMaxLimit)
    lengthInBits += 48;

    // Const Field (blockIdTorqueFinalTarget)
    lengthInBits += 16;

    // Simple field (torqueFinalTarget)
    lengthInBits += 48;

    // Const Field (blockIdTorque)
    lengthInBits += 16;

    // Simple field (torque)
    lengthInBits += 48;

    // Const Field (blockIdAngleMin)
    lengthInBits += 16;

    // Simple field (angleMin)
    lengthInBits += 40;

    // Const Field (blockIdAngleMax)
    lengthInBits += 16;

    // Simple field (angleMax)
    lengthInBits += 40;

    // Const Field (blockIdFinalAngleTarget)
    lengthInBits += 16;

    // Simple field (finalAngleTarget)
    lengthInBits += 40;

    // Const Field (blockIdAngle)
    lengthInBits += 16;

    // Simple field (angle)
    lengthInBits += 40;

    // Const Field (blockIdTimeStamp)
    lengthInBits += 16;

    // Simple field (timeStamp)
    lengthInBits += 152;

    // Const Field (blockIdDateTimeOfLastChangeIndParameterSetSettings)
    lengthInBits += 16;

    // Simple field (dateTimeOfLastChangeIndParameterSetSettings)
    lengthInBits += 152;

    // Const Field (blockIdBatchStatus)
    lengthInBits += 16;

    // Simple field (batchStatus)
    lengthInBits += 8;

    // Const Field (blockIdTighteningId)
    lengthInBits += 16;

    // Simple field (tighteningId)
    lengthInBits += 80;

    return lengthInBits;
  }

  public static OpenProtocolMessageLastTighteningResultDataBuilder
      staticParseOpenProtocolMessageLastTighteningResultDataBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageLastTighteningResultDataRev1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockIdCellId =
        readConstField(
            "blockIdCellId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDCELLID,
            WithOption.WithEncoding("ASCII"));

    long cellId =
        readSimpleField(
            "cellId", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdChannelId =
        readConstField(
            "blockIdChannelId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDCHANNELID,
            WithOption.WithEncoding("ASCII"));

    int channelId =
        readSimpleField(
            "channelId", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueControllerName =
        readConstField(
            "blockIdTorqueControllerName",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTORQUECONTROLLERNAME,
            WithOption.WithEncoding("ASCII"));

    String torqueControllerName =
        readSimpleField(
            "torqueControllerName", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdVinNumber =
        readConstField(
            "blockIdVinNumber",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDVINNUMBER,
            WithOption.WithEncoding("ASCII"));

    String vinNumber =
        readSimpleField("vinNumber", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int blockIdJobId =
        readConstField(
            "blockIdJobId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDJOBID,
            WithOption.WithEncoding("ASCII"));

    int jobId =
        readSimpleField("jobId", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    int blockIdParameterSetId =
        readConstField(
            "blockIdParameterSetId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDPARAMETERSETID,
            WithOption.WithEncoding("ASCII"));

    int parameterSetId =
        readSimpleField(
            "parameterSetId", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    int blockIdBatchSize =
        readConstField(
            "blockIdBatchSize",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDBATCHSIZE,
            WithOption.WithEncoding("ASCII"));

    long batchSize =
        readSimpleField(
            "batchSize", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdBatchCounter =
        readConstField(
            "blockIdBatchCounter",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDBATCHCOUNTER,
            WithOption.WithEncoding("ASCII"));

    long batchCounter =
        readSimpleField(
            "batchCounter", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    int blockIdTighteningStatus =
        readConstField(
            "blockIdTighteningStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTIGHTENINGSTATUS,
            WithOption.WithEncoding("ASCII"));

    NokOk tighteningStatus =
        readEnumField(
            "tighteningStatus",
            "NokOk",
            readEnum(NokOk::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorqueStatus =
        readConstField(
            "blockIdTorqueStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTORQUESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status torqueStatus =
        readEnumField(
            "torqueStatus",
            "Status",
            readEnum(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdAngleStatus =
        readConstField(
            "blockIdAngleStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDANGLESTATUS,
            WithOption.WithEncoding("ASCII"));

    Status angleStatus =
        readEnumField(
            "angleStatus",
            "Status",
            readEnum(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorqueMinLimit =
        readConstField(
            "blockIdTorqueMinLimit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTORQUEMINLIMIT,
            WithOption.WithEncoding("ASCII"));

    long torqueMinLimit =
        readSimpleField(
            "torqueMinLimit", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueMaxLimit =
        readConstField(
            "blockIdTorqueMaxLimit",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTORQUEMAXLIMIT,
            WithOption.WithEncoding("ASCII"));

    long torqueMaxLimit =
        readSimpleField(
            "torqueMaxLimit", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdTorqueFinalTarget =
        readConstField(
            "blockIdTorqueFinalTarget",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTORQUEFINALTARGET,
            WithOption.WithEncoding("ASCII"));

    long torqueFinalTarget =
        readSimpleField(
            "torqueFinalTarget",
            readUnsignedLong(readBuffer, 48),
            WithOption.WithEncoding("ASCII"));

    int blockIdTorque =
        readConstField(
            "blockIdTorque",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTORQUE,
            WithOption.WithEncoding("ASCII"));

    long torque =
        readSimpleField(
            "torque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    int blockIdAngleMin =
        readConstField(
            "blockIdAngleMin",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDANGLEMIN,
            WithOption.WithEncoding("ASCII"));

    long angleMin =
        readSimpleField(
            "angleMin", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdAngleMax =
        readConstField(
            "blockIdAngleMax",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDANGLEMAX,
            WithOption.WithEncoding("ASCII"));

    long angleMax =
        readSimpleField(
            "angleMax", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdFinalAngleTarget =
        readConstField(
            "blockIdFinalAngleTarget",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDFINALANGLETARGET,
            WithOption.WithEncoding("ASCII"));

    long finalAngleTarget =
        readSimpleField(
            "finalAngleTarget", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdAngle =
        readConstField(
            "blockIdAngle",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDANGLE,
            WithOption.WithEncoding("ASCII"));

    long angle =
        readSimpleField(
            "angle", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int blockIdTimeStamp =
        readConstField(
            "blockIdTimeStamp",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTIMESTAMP,
            WithOption.WithEncoding("ASCII"));

    String timeStamp =
        readSimpleField("timeStamp", readString(readBuffer, 152), WithOption.WithEncoding("ASCII"));

    int blockIdDateTimeOfLastChangeIndParameterSetSettings =
        readConstField(
            "blockIdDateTimeOfLastChangeIndParameterSetSettings",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1
                .BLOCKIDDATETIMEOFLASTCHANGEINDPARAMETERSETSETTINGS,
            WithOption.WithEncoding("ASCII"));

    String dateTimeOfLastChangeIndParameterSetSettings =
        readSimpleField(
            "dateTimeOfLastChangeIndParameterSetSettings",
            readString(readBuffer, 152),
            WithOption.WithEncoding("ASCII"));

    int blockIdBatchStatus =
        readConstField(
            "blockIdBatchStatus",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDBATCHSTATUS,
            WithOption.WithEncoding("ASCII"));

    BatchStatus batchStatus =
        readEnumField(
            "batchStatus",
            "BatchStatus",
            readEnum(BatchStatus::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    int blockIdTighteningId =
        readConstField(
            "blockIdTighteningId",
            readUnsignedInt(readBuffer, 16),
            OpenProtocolMessageLastTighteningResultDataRev1.BLOCKIDTIGHTENINGID,
            WithOption.WithEncoding("ASCII"));

    String tighteningId =
        readSimpleField(
            "tighteningId", readString(readBuffer, 80), WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageLastTighteningResultDataRev1");
    // Create the instance
    return new OpenProtocolMessageLastTighteningResultDataRev1BuilderImpl(
        cellId,
        channelId,
        torqueControllerName,
        vinNumber,
        jobId,
        parameterSetId,
        batchSize,
        batchCounter,
        tighteningStatus,
        torqueStatus,
        angleStatus,
        torqueMinLimit,
        torqueMaxLimit,
        torqueFinalTarget,
        torque,
        angleMin,
        angleMax,
        finalAngleTarget,
        angle,
        timeStamp,
        dateTimeOfLastChangeIndParameterSetSettings,
        batchStatus,
        tighteningId);
  }

  public static class OpenProtocolMessageLastTighteningResultDataRev1BuilderImpl
      implements OpenProtocolMessageLastTighteningResultData
          .OpenProtocolMessageLastTighteningResultDataBuilder {
    private final long cellId;
    private final int channelId;
    private final String torqueControllerName;
    private final String vinNumber;
    private final int jobId;
    private final int parameterSetId;
    private final long batchSize;
    private final long batchCounter;
    private final NokOk tighteningStatus;
    private final Status torqueStatus;
    private final Status angleStatus;
    private final long torqueMinLimit;
    private final long torqueMaxLimit;
    private final long torqueFinalTarget;
    private final long torque;
    private final long angleMin;
    private final long angleMax;
    private final long finalAngleTarget;
    private final long angle;
    private final String timeStamp;
    private final String dateTimeOfLastChangeIndParameterSetSettings;
    private final BatchStatus batchStatus;
    private final String tighteningId;

    public OpenProtocolMessageLastTighteningResultDataRev1BuilderImpl(
        long cellId,
        int channelId,
        String torqueControllerName,
        String vinNumber,
        int jobId,
        int parameterSetId,
        long batchSize,
        long batchCounter,
        NokOk tighteningStatus,
        Status torqueStatus,
        Status angleStatus,
        long torqueMinLimit,
        long torqueMaxLimit,
        long torqueFinalTarget,
        long torque,
        long angleMin,
        long angleMax,
        long finalAngleTarget,
        long angle,
        String timeStamp,
        String dateTimeOfLastChangeIndParameterSetSettings,
        BatchStatus batchStatus,
        String tighteningId) {
      this.cellId = cellId;
      this.channelId = channelId;
      this.torqueControllerName = torqueControllerName;
      this.vinNumber = vinNumber;
      this.jobId = jobId;
      this.parameterSetId = parameterSetId;
      this.batchSize = batchSize;
      this.batchCounter = batchCounter;
      this.tighteningStatus = tighteningStatus;
      this.torqueStatus = torqueStatus;
      this.angleStatus = angleStatus;
      this.torqueMinLimit = torqueMinLimit;
      this.torqueMaxLimit = torqueMaxLimit;
      this.torqueFinalTarget = torqueFinalTarget;
      this.torque = torque;
      this.angleMin = angleMin;
      this.angleMax = angleMax;
      this.finalAngleTarget = finalAngleTarget;
      this.angle = angle;
      this.timeStamp = timeStamp;
      this.dateTimeOfLastChangeIndParameterSetSettings =
          dateTimeOfLastChangeIndParameterSetSettings;
      this.batchStatus = batchStatus;
      this.tighteningId = tighteningId;
    }

    public OpenProtocolMessageLastTighteningResultDataRev1 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageLastTighteningResultDataRev1
          openProtocolMessageLastTighteningResultDataRev1 =
              new OpenProtocolMessageLastTighteningResultDataRev1(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  cellId,
                  channelId,
                  torqueControllerName,
                  vinNumber,
                  jobId,
                  parameterSetId,
                  batchSize,
                  batchCounter,
                  tighteningStatus,
                  torqueStatus,
                  angleStatus,
                  torqueMinLimit,
                  torqueMaxLimit,
                  torqueFinalTarget,
                  torque,
                  angleMin,
                  angleMax,
                  finalAngleTarget,
                  angle,
                  timeStamp,
                  dateTimeOfLastChangeIndParameterSetSettings,
                  batchStatus,
                  tighteningId);
      return openProtocolMessageLastTighteningResultDataRev1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageLastTighteningResultDataRev1)) {
      return false;
    }
    OpenProtocolMessageLastTighteningResultDataRev1 that =
        (OpenProtocolMessageLastTighteningResultDataRev1) o;
    return (getCellId() == that.getCellId())
        && (getChannelId() == that.getChannelId())
        && (getTorqueControllerName() == that.getTorqueControllerName())
        && (getVinNumber() == that.getVinNumber())
        && (getJobId() == that.getJobId())
        && (getParameterSetId() == that.getParameterSetId())
        && (getBatchSize() == that.getBatchSize())
        && (getBatchCounter() == that.getBatchCounter())
        && (getTighteningStatus() == that.getTighteningStatus())
        && (getTorqueStatus() == that.getTorqueStatus())
        && (getAngleStatus() == that.getAngleStatus())
        && (getTorqueMinLimit() == that.getTorqueMinLimit())
        && (getTorqueMaxLimit() == that.getTorqueMaxLimit())
        && (getTorqueFinalTarget() == that.getTorqueFinalTarget())
        && (getTorque() == that.getTorque())
        && (getAngleMin() == that.getAngleMin())
        && (getAngleMax() == that.getAngleMax())
        && (getFinalAngleTarget() == that.getFinalAngleTarget())
        && (getAngle() == that.getAngle())
        && (getTimeStamp() == that.getTimeStamp())
        && (getDateTimeOfLastChangeIndParameterSetSettings()
            == that.getDateTimeOfLastChangeIndParameterSetSettings())
        && (getBatchStatus() == that.getBatchStatus())
        && (getTighteningId() == that.getTighteningId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getCellId(),
        getChannelId(),
        getTorqueControllerName(),
        getVinNumber(),
        getJobId(),
        getParameterSetId(),
        getBatchSize(),
        getBatchCounter(),
        getTighteningStatus(),
        getTorqueStatus(),
        getAngleStatus(),
        getTorqueMinLimit(),
        getTorqueMaxLimit(),
        getTorqueFinalTarget(),
        getTorque(),
        getAngleMin(),
        getAngleMax(),
        getFinalAngleTarget(),
        getAngle(),
        getTimeStamp(),
        getDateTimeOfLastChangeIndParameterSetSettings(),
        getBatchStatus(),
        getTighteningId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
