/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class VariableDataField implements Message {

  // Properties.
  protected final long parameterId;
  protected final int dataType;
  protected final int unit;
  protected final int stepNumber;
  protected final byte[] dataValue;

  public VariableDataField(
      long parameterId, int dataType, int unit, int stepNumber, byte[] dataValue) {
    super();
    this.parameterId = parameterId;
    this.dataType = dataType;
    this.unit = unit;
    this.stepNumber = stepNumber;
    this.dataValue = dataValue;
  }

  public long getParameterId() {
    return parameterId;
  }

  public int getDataType() {
    return dataType;
  }

  public int getUnit() {
    return unit;
  }

  public int getStepNumber() {
    return stepNumber;
  }

  public byte[] getDataValue() {
    return dataValue;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("VariableDataField");

    // Simple Field (parameterId)
    writeSimpleField(
        "parameterId",
        parameterId,
        writeUnsignedLong(writeBuffer, 40),
        WithOption.WithEncoding("ASCII"));

    // Implicit Field (length) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int length = (int) (COUNT(getDataValue()));
    writeImplicitField(
        "length", length, writeUnsignedInt(writeBuffer, 24), WithOption.WithEncoding("ASCII"));

    // Simple Field (dataType)
    writeSimpleField(
        "dataType", dataType, writeUnsignedInt(writeBuffer, 16), WithOption.WithEncoding("ASCII"));

    // Simple Field (unit)
    writeSimpleField(
        "unit", unit, writeUnsignedInt(writeBuffer, 24), WithOption.WithEncoding("ASCII"));

    // Simple Field (stepNumber)
    writeSimpleField(
        "stepNumber",
        stepNumber,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Array Field (dataValue)
    writeByteArrayField(
        "dataValue", dataValue, writeByteArray(writeBuffer, 8), WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("VariableDataField");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    VariableDataField _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (parameterId)
    lengthInBits += 40;

    // Implicit Field (length)
    lengthInBits += 24;

    // Simple field (dataType)
    lengthInBits += 16;

    // Simple field (unit)
    lengthInBits += 24;

    // Simple field (stepNumber)
    lengthInBits += 24;

    // Array field
    if (dataValue != null) {
      lengthInBits += 8 * dataValue.length;
    }

    return lengthInBits;
  }

  public static VariableDataField staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("VariableDataField");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long parameterId =
        readSimpleField(
            "parameterId", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    int length =
        readImplicitField(
            "length", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    int dataType =
        readSimpleField(
            "dataType", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    int unit =
        readSimpleField("unit", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    int stepNumber =
        readSimpleField(
            "stepNumber", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    byte[] dataValue =
        readBuffer.readByteArray(
            "dataValue", Math.toIntExact(length), WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("VariableDataField");
    // Create the instance
    VariableDataField _variableDataField;
    _variableDataField = new VariableDataField(parameterId, dataType, unit, stepNumber, dataValue);
    return _variableDataField;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof VariableDataField)) {
      return false;
    }
    VariableDataField that = (VariableDataField) o;
    return (getParameterId() == that.getParameterId())
        && (getDataType() == that.getDataType())
        && (getUnit() == that.getUnit())
        && (getStepNumber() == that.getStepNumber())
        && (getDataValue() == that.getDataValue())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getParameterId(), getDataType(), getUnit(), getStepNumber(), getDataValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
