/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class Plc4xTag implements Message {

  // Properties.
  protected final String name;
  protected final String tagQuery;

  public Plc4xTag(String name, String tagQuery) {
    super();
    this.name = name;
    this.tagQuery = tagQuery;
  }

  public String getName() {
    return name;
  }

  public String getTagQuery() {
    return tagQuery;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Plc4xTag");

    // Implicit Field (nameLen) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    short nameLen = (short) (STR_LEN(getName()));
    writeImplicitField("nameLen", nameLen, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (name)
    writeSimpleField("name", name, writeString(writeBuffer, (nameLen) * (8)));

    // Implicit Field (tagQueryLen) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    short tagQueryLen = (short) (STR_LEN(getTagQuery()));
    writeImplicitField("tagQueryLen", tagQueryLen, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (tagQuery)
    writeSimpleField("tagQuery", tagQuery, writeString(writeBuffer, (tagQueryLen) * (8)));

    writeBuffer.popContext("Plc4xTag");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    Plc4xTag _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (nameLen)
    lengthInBits += 8;

    // Simple field (name)
    lengthInBits += (STR_LEN(getName())) * (8);

    // Implicit Field (tagQueryLen)
    lengthInBits += 8;

    // Simple field (tagQuery)
    lengthInBits += (STR_LEN(getTagQuery())) * (8);

    return lengthInBits;
  }

  public static Plc4xTag staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("Plc4xTag");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short nameLen = readImplicitField("nameLen", readUnsignedShort(readBuffer, 8));

    String name = readSimpleField("name", readString(readBuffer, (nameLen) * (8)));

    short tagQueryLen = readImplicitField("tagQueryLen", readUnsignedShort(readBuffer, 8));

    String tagQuery = readSimpleField("tagQuery", readString(readBuffer, (tagQueryLen) * (8)));

    readBuffer.closeContext("Plc4xTag");
    // Create the instance
    Plc4xTag _plc4xTag;
    _plc4xTag = new Plc4xTag(name, tagQuery);
    return _plc4xTag;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Plc4xTag)) {
      return false;
    }
    Plc4xTag that = (Plc4xTag) o;
    return (getName() == that.getName()) && (getTagQuery() == that.getTagQuery()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getName(), getTagQuery());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
