/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class Plc4xTagResponse implements Message {

  // Properties.
  protected final Plc4xTag tag;
  protected final Plc4xResponseCode responseCode;

  public Plc4xTagResponse(Plc4xTag tag, Plc4xResponseCode responseCode) {
    super();
    this.tag = tag;
    this.responseCode = responseCode;
  }

  public Plc4xTag getTag() {
    return tag;
  }

  public Plc4xResponseCode getResponseCode() {
    return responseCode;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Plc4xTagResponse");

    // Simple Field (tag)
    writeSimpleField("tag", tag, writeComplex(writeBuffer));

    // Simple Field (responseCode)
    writeSimpleEnumField(
        "responseCode",
        "Plc4xResponseCode",
        responseCode,
        writeEnum(
            Plc4xResponseCode::getValue,
            Plc4xResponseCode::name,
            writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("Plc4xTagResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    Plc4xTagResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (tag)
    lengthInBits += tag.getLengthInBits();

    // Simple field (responseCode)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static Plc4xTagResponse staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("Plc4xTagResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Plc4xTag tag =
        readSimpleField("tag", readComplex(() -> Plc4xTag.staticParse(readBuffer), readBuffer));

    Plc4xResponseCode responseCode =
        readEnumField(
            "responseCode",
            "Plc4xResponseCode",
            readEnum(Plc4xResponseCode::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("Plc4xTagResponse");
    // Create the instance
    Plc4xTagResponse _plc4xTagResponse;
    _plc4xTagResponse = new Plc4xTagResponse(tag, responseCode);
    return _plc4xTagResponse;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Plc4xTagResponse)) {
      return false;
    }
    Plc4xTagResponse that = (Plc4xTagResponse) o;
    return (getTag() == that.getTag()) && (getResponseCode() == that.getResponseCode()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTag(), getResponseCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
