/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_ModuleDiffBlockApi_Module implements Message {

  // Properties.
  protected final int slotNumber;
  protected final long moduleIdentNumber;
  protected final PnIoCm_ModuleState moduleState;
  protected final List<PnIoCm_ModuleDiffBlockApi_Submodule> submodules;

  public PnIoCm_ModuleDiffBlockApi_Module(
      int slotNumber,
      long moduleIdentNumber,
      PnIoCm_ModuleState moduleState,
      List<PnIoCm_ModuleDiffBlockApi_Submodule> submodules) {
    super();
    this.slotNumber = slotNumber;
    this.moduleIdentNumber = moduleIdentNumber;
    this.moduleState = moduleState;
    this.submodules = submodules;
  }

  public int getSlotNumber() {
    return slotNumber;
  }

  public long getModuleIdentNumber() {
    return moduleIdentNumber;
  }

  public PnIoCm_ModuleState getModuleState() {
    return moduleState;
  }

  public List<PnIoCm_ModuleDiffBlockApi_Submodule> getSubmodules() {
    return submodules;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_ModuleDiffBlockApi_Module");

    // Simple Field (slotNumber)
    writeSimpleField(
        "slotNumber",
        slotNumber,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (moduleIdentNumber)
    writeSimpleField(
        "moduleIdentNumber",
        moduleIdentNumber,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (moduleState)
    writeSimpleEnumField(
        "moduleState",
        "PnIoCm_ModuleState",
        moduleState,
        writeEnum(
            PnIoCm_ModuleState::getValue,
            PnIoCm_ModuleState::name,
            writeUnsignedInt(writeBuffer, 16)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (numSubmodules) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numSubmodules = (int) (COUNT(getSubmodules()));
    writeImplicitField(
        "numSubmodules",
        numSubmodules,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (submodules)
    writeComplexTypeArrayField(
        "submodules", submodules, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_ModuleDiffBlockApi_Module");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_ModuleDiffBlockApi_Module _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (slotNumber)
    lengthInBits += 16;

    // Simple field (moduleIdentNumber)
    lengthInBits += 32;

    // Simple field (moduleState)
    lengthInBits += 16;

    // Implicit Field (numSubmodules)
    lengthInBits += 16;

    // Array field
    if (submodules != null) {
      int i = 0;
      for (PnIoCm_ModuleDiffBlockApi_Submodule element : submodules) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= submodules.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PnIoCm_ModuleDiffBlockApi_Module staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_ModuleDiffBlockApi_Module");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int slotNumber =
        readSimpleField(
            "slotNumber",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long moduleIdentNumber =
        readSimpleField(
            "moduleIdentNumber",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_ModuleState moduleState =
        readEnumField(
            "moduleState",
            "PnIoCm_ModuleState",
            readEnum(PnIoCm_ModuleState::enumForValue, readUnsignedInt(readBuffer, 16)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int numSubmodules =
        readImplicitField(
            "numSubmodules",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<PnIoCm_ModuleDiffBlockApi_Submodule> submodules =
        readCountArrayField(
            "submodules",
            readComplex(
                () -> PnIoCm_ModuleDiffBlockApi_Submodule.staticParse(readBuffer), readBuffer),
            numSubmodules,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_ModuleDiffBlockApi_Module");
    // Create the instance
    PnIoCm_ModuleDiffBlockApi_Module _pnIoCm_ModuleDiffBlockApi_Module;
    _pnIoCm_ModuleDiffBlockApi_Module =
        new PnIoCm_ModuleDiffBlockApi_Module(
            slotNumber, moduleIdentNumber, moduleState, submodules);
    return _pnIoCm_ModuleDiffBlockApi_Module;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_ModuleDiffBlockApi_Module)) {
      return false;
    }
    PnIoCm_ModuleDiffBlockApi_Module that = (PnIoCm_ModuleDiffBlockApi_Module) o;
    return (getSlotNumber() == that.getSlotNumber())
        && (getModuleIdentNumber() == that.getModuleIdentNumber())
        && (getModuleState() == that.getModuleState())
        && (getSubmodules() == that.getSubmodules())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSlotNumber(), getModuleIdentNumber(), getModuleState(), getSubmodules());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
