/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class COTPPacketData extends COTPPacket implements Message {

  // Accessors for discriminator values.
  public Short getTpduCode() {
    return (short) 0xF0;
  }

  // Properties.
  protected final boolean eot;
  protected final byte tpduRef;

  public COTPPacketData(
      List<COTPParameter> parameters, S7Message payload, boolean eot, byte tpduRef) {
    super(parameters, payload);
    this.eot = eot;
    this.tpduRef = tpduRef;
  }

  public boolean getEot() {
    return eot;
  }

  public byte getTpduRef() {
    return tpduRef;
  }

  @Override
  protected void serializeCOTPPacketChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("COTPPacketData");

    // Simple Field (eot)
    writeSimpleField("eot", eot, writeBoolean(writeBuffer));

    // Simple Field (tpduRef)
    writeSimpleField("tpduRef", tpduRef, writeUnsignedByte(writeBuffer, 7));

    writeBuffer.popContext("COTPPacketData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    COTPPacketData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (eot)
    lengthInBits += 1;

    // Simple field (tpduRef)
    lengthInBits += 7;

    return lengthInBits;
  }

  public static COTPPacketBuilder staticParseCOTPPacketBuilder(
      ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
    readBuffer.pullContext("COTPPacketData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean eot = readSimpleField("eot", readBoolean(readBuffer));

    byte tpduRef = readSimpleField("tpduRef", readUnsignedByte(readBuffer, 7));

    readBuffer.closeContext("COTPPacketData");
    // Create the instance
    return new COTPPacketDataBuilderImpl(eot, tpduRef);
  }

  public static class COTPPacketDataBuilderImpl implements COTPPacket.COTPPacketBuilder {
    private final boolean eot;
    private final byte tpduRef;

    public COTPPacketDataBuilderImpl(boolean eot, byte tpduRef) {
      this.eot = eot;
      this.tpduRef = tpduRef;
    }

    public COTPPacketData build(List<COTPParameter> parameters, S7Message payload) {
      COTPPacketData cOTPPacketData = new COTPPacketData(parameters, payload, eot, tpduRef);
      return cOTPPacketData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof COTPPacketData)) {
      return false;
    }
    COTPPacketData that = (COTPPacketData) o;
    return (getEot() == that.getEot())
        && (getTpduRef() == that.getTpduRef())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getEot(), getTpduRef());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
