/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.
using org.apache.plc4net.types;

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public enum KnxInterfaceObjectType
    {
        OT_UNKNOWN = 0,
        OT_GENERAL = 1,
        OT_DEVICE = 2,
        OT_ADDRESS_TABLE = 3,
        OT_ASSOCIATION_TABLE = 4,
        OT_APPLICATION_PROGRAM = 5,
        OT_INTERACE_PROGRAM = 6,
        OT_EIBOBJECT_ASSOCIATATION_TABLE = 7,
        OT_ROUTER = 8,
        OT_LTE_ADDRESS_ROUTING_TABLE = 9,
        OT_CEMI_SERVER = 10,
        OT_GROUP_OBJECT_TABLE = 11,
        OT_POLLING_MASTER = 12,
        OT_KNXIP_PARAMETER = 13,
        OT_FILE_SERVER = 14,
        OT_SECURITY = 15,
        OT_RF_MEDIUM = 16,
        OT_INDOOR_BRIGHTNESS_SENSOR = 17,
        OT_INDOOR_LUMINANCE_SENSOR = 18,
        OT_LIGHT_SWITCHING_ACTUATOR_BASIC = 19,
        OT_DIMMING_ACTUATOR_BASIC = 20,
        OT_DIMMING_SENSOR_BASIC = 21,
        OT_SWITCHING_SENSOR_BASIC = 22,
        OT_SUNBLIND_ACTUATOR_BASIC = 23,
        OT_SUNBLIND_SENSOR_BASIC = 24,
    }

    public static class KnxInterfaceObjectTypeInfo
    {

        public static string Code(this KnxInterfaceObjectType value)
        {
            switch (value)
            {
                case KnxInterfaceObjectType.OT_UNKNOWN: { /* '0' */
                    return "U";
                }
                case KnxInterfaceObjectType.OT_GENERAL: { /* '1' */
                    return "G";
                }
                case KnxInterfaceObjectType.OT_CEMI_SERVER: { /* '10' */
                    return "8";
                }
                case KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE: { /* '11' */
                    return "9";
                }
                case KnxInterfaceObjectType.OT_POLLING_MASTER: { /* '12' */
                    return "10";
                }
                case KnxInterfaceObjectType.OT_KNXIP_PARAMETER: { /* '13' */
                    return "11";
                }
                case KnxInterfaceObjectType.OT_FILE_SERVER: { /* '14' */
                    return "13";
                }
                case KnxInterfaceObjectType.OT_SECURITY: { /* '15' */
                    return "17";
                }
                case KnxInterfaceObjectType.OT_RF_MEDIUM: { /* '16' */
                    return "19";
                }
                case KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR: { /* '17' */
                    return "409";
                }
                case KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR: { /* '18' */
                    return "410";
                }
                case KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC: { /* '19' */
                    return "417";
                }
                case KnxInterfaceObjectType.OT_DEVICE: { /* '2' */
                    return "0";
                }
                case KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC: { /* '20' */
                    return "418";
                }
                case KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC: { /* '21' */
                    return "420";
                }
                case KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC: { /* '22' */
                    return "421";
                }
                case KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC: { /* '23' */
                    return "800";
                }
                case KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC: { /* '24' */
                    return "801";
                }
                case KnxInterfaceObjectType.OT_ADDRESS_TABLE: { /* '3' */
                    return "1";
                }
                case KnxInterfaceObjectType.OT_ASSOCIATION_TABLE: { /* '4' */
                    return "2";
                }
                case KnxInterfaceObjectType.OT_APPLICATION_PROGRAM: { /* '5' */
                    return "3";
                }
                case KnxInterfaceObjectType.OT_INTERACE_PROGRAM: { /* '6' */
                    return "4";
                }
                case KnxInterfaceObjectType.OT_EIBOBJECT_ASSOCIATATION_TABLE: { /* '7' */
                    return "5";
                }
                case KnxInterfaceObjectType.OT_ROUTER: { /* '8' */
                    return "6";
                }
                case KnxInterfaceObjectType.OT_LTE_ADDRESS_ROUTING_TABLE: { /* '9' */
                    return "7";
                }
                default: {
                    return null;
                }
            }
        }

        public static string Name(this KnxInterfaceObjectType value)
        {
            switch (value)
            {
                case KnxInterfaceObjectType.OT_UNKNOWN: { /* '0' */
                    return "Unknown Interface Object Type";
                }
                case KnxInterfaceObjectType.OT_GENERAL: { /* '1' */
                    return "General Interface Object Type";
                }
                case KnxInterfaceObjectType.OT_CEMI_SERVER: { /* '10' */
                    return "cEMI Server Object";
                }
                case KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE: { /* '11' */
                    return "Group Object Table Object";
                }
                case KnxInterfaceObjectType.OT_POLLING_MASTER: { /* '12' */
                    return "Polling Master";
                }
                case KnxInterfaceObjectType.OT_KNXIP_PARAMETER: { /* '13' */
                    return "KNXnet/IP Parameter Object";
                }
                case KnxInterfaceObjectType.OT_FILE_SERVER: { /* '14' */
                    return "File Server Object";
                }
                case KnxInterfaceObjectType.OT_SECURITY: { /* '15' */
                    return "Security Object";
                }
                case KnxInterfaceObjectType.OT_RF_MEDIUM: { /* '16' */
                    return "RF Medium Object";
                }
                case KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR: { /* '17' */
                    return "Indoor Brightness Sensor";
                }
                case KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR: { /* '18' */
                    return "Indoor Luminance Sensor";
                }
                case KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC: { /* '19' */
                    return "Light Switching Actuator Basic";
                }
                case KnxInterfaceObjectType.OT_DEVICE: { /* '2' */
                    return "Device Object";
                }
                case KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC: { /* '20' */
                    return "Dimming Actuator Basic";
                }
                case KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC: { /* '21' */
                    return "Dimming   Sensor Basic";
                }
                case KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC: { /* '22' */
                    return "Switching Sensor Basic";
                }
                case KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC: { /* '23' */
                    return "Sunblind Actuator Basic";
                }
                case KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC: { /* '24' */
                    return "Sunblind Sensor Basic";
                }
                case KnxInterfaceObjectType.OT_ADDRESS_TABLE: { /* '3' */
                    return "Addresstable Object";
                }
                case KnxInterfaceObjectType.OT_ASSOCIATION_TABLE: { /* '4' */
                    return "Associationtable Object";
                }
                case KnxInterfaceObjectType.OT_APPLICATION_PROGRAM: { /* '5' */
                    return "Applicationprogram Object";
                }
                case KnxInterfaceObjectType.OT_INTERACE_PROGRAM: { /* '6' */
                    return "Interfaceprogram Object";
                }
                case KnxInterfaceObjectType.OT_EIBOBJECT_ASSOCIATATION_TABLE: { /* '7' */
                    return "KNX-Object Associationtable Object";
                }
                case KnxInterfaceObjectType.OT_ROUTER: { /* '8' */
                    return "Router Object";
                }
                case KnxInterfaceObjectType.OT_LTE_ADDRESS_ROUTING_TABLE: { /* '9' */
                    return "LTE Address Routing Table Object";
                }
                default: {
                    return null;
                }
            }
        }
    }

}

