
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

 // Code generated by code-generation. DO NOT EDIT.

[type BACnetDaysOfWeekTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit monday         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit tuesday         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit wednesday         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]
    [virtual    bit thursday         '(COUNT(payload.data)>3)?payload.data[3]:false'          ]
    [virtual    bit friday         '(COUNT(payload.data)>4)?payload.data[4]:false'          ]
    [virtual    bit saturday         '(COUNT(payload.data)>5)?payload.data[5]:false'          ]
    [virtual    bit sunday         '(COUNT(payload.data)>6)?payload.data[6]:false'          ]

]

[type BACnetEventTransitionBitsTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit toOffnormal         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit toFault         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit toNormal         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]

]

[type BACnetLimitEnableTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit lowLimitEnable         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit highLimitEnable         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]

]

[type BACnetLogStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit logDisabled         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit bufferPurged         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit logInterrupted         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]

]

[type BACnetObjectTypesSupportedTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit timeValue         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit notificationForwarder         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit alertEnrollment         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]
    [virtual    bit channel         '(COUNT(payload.data)>3)?payload.data[3]:false'          ]
    [virtual    bit lightingOutput         '(COUNT(payload.data)>4)?payload.data[4]:false'          ]
    [virtual    bit binaryLightingOutput         '(COUNT(payload.data)>5)?payload.data[5]:false'          ]
    [virtual    bit networkPort         '(COUNT(payload.data)>6)?payload.data[6]:false'          ]
    [virtual    bit elevatorGroup         '(COUNT(payload.data)>7)?payload.data[7]:false'          ]
    [virtual    bit escalator         '(COUNT(payload.data)>8)?payload.data[8]:false'          ]
    [virtual    bit lift         '(COUNT(payload.data)>9)?payload.data[9]:false'          ]

]

[type BACnetResultFlagsTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit firstItem         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit lastItem         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit moreItems         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]

]

[type BACnetServicesSupportedTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit writeGroup         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit subscribeCovPropertyMultiple         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit confirmedCovNotificationMultiple         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]
    [virtual    bit unconfirmedCovNotificationMultiple         '(COUNT(payload.data)>3)?payload.data[3]:false'          ]
    [virtual    bit whoIs         '(COUNT(payload.data)>4)?payload.data[4]:false'          ]
    [virtual    bit readRange         '(COUNT(payload.data)>5)?payload.data[5]:false'          ]
    [virtual    bit utcTimeSynchronization         '(COUNT(payload.data)>6)?payload.data[6]:false'          ]
    [virtual    bit lifeSafetyOperation         '(COUNT(payload.data)>7)?payload.data[7]:false'          ]
    [virtual    bit subscribeCovProperty         '(COUNT(payload.data)>8)?payload.data[8]:false'          ]
    [virtual    bit getEventInformation         '(COUNT(payload.data)>9)?payload.data[9]:false'          ]

]

[type BACnetStatusFlagsTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [simple BACnetTagPayloadBitString('header.actualLength')
                    payload                                                                                     ]
    [virtual    bit inAlarm         '(COUNT(payload.data)>0)?payload.data[0]:false'          ]
    [virtual    bit fault         '(COUNT(payload.data)>1)?payload.data[1]:false'          ]
    [virtual    bit overridden         '(COUNT(payload.data)>2)?payload.data[2]:false'          ]
    [virtual    bit outOfService         '(COUNT(payload.data)>3)?payload.data[3]:false'          ]

]

