/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.NoFactoryForCategoryException;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.plugin.ConfiguredObjectTypeFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.UnresolvedConfiguredObject;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ConfiguredObjectFactoryImpl
implements ConfiguredObjectFactory {
    private final Map<String, String> _defaultTypes = new HashMap<String, String>();
    private final Map<String, Map<String, ConfiguredObjectTypeFactory>> _allFactories = new HashMap<String, Map<String, ConfiguredObjectTypeFactory>>();
    private final Map<String, Collection<String>> _supportedTypes = new HashMap<String, Collection<String>>();
    private final Model _model;

    public ConfiguredObjectFactoryImpl(Model model) {
        this._model = model;
        QpidServiceLoader serviceLoader = new QpidServiceLoader();
        Iterable<ConfiguredObjectTypeFactory> allFactories = serviceLoader.instancesOf(ConfiguredObjectTypeFactory.class);
        for (ConfiguredObjectTypeFactory factory : allFactories) {
            Class categoryClass = factory.getCategoryClass();
            String categoryName = categoryClass.getSimpleName();
            Map<String, ConfiguredObjectTypeFactory> categoryFactories = this._allFactories.get(categoryName);
            if (categoryFactories == null) {
                categoryFactories = new HashMap<String, ConfiguredObjectTypeFactory>();
                this._allFactories.put(categoryName, categoryFactories);
                this._supportedTypes.put(categoryName, new ArrayList());
                ManagedObject annotation = categoryClass.getAnnotation(ManagedObject.class);
                if (annotation != null && !"".equals(annotation.defaultType())) {
                    this._defaultTypes.put(categoryName, annotation.defaultType());
                } else {
                    this._defaultTypes.put(categoryName, categoryName);
                }
            }
            if (categoryFactories.put(factory.getType(), factory) != null) {
                throw new ServerScopedRuntimeException("Misconfiguration - there is more than one factory defined for class " + categoryName + " with type " + factory.getType());
            }
            if (factory.getType() == null) continue;
            this._supportedTypes.get(categoryName).add(factory.getType());
        }
    }

    @Override
    public <X extends ConfiguredObject<X>> UnresolvedConfiguredObject<X> recover(ConfiguredObjectRecord record, ConfiguredObject<?> parent) {
        ConfiguredObjectTypeFactory<X> factory;
        String category = record.getType();
        String type = (String)record.getAttributes().get("type");
        if (type == null || "".equals(type)) {
            type = this.getOnlyValidChildTypeIfKnown(parent, category);
        }
        if ((factory = this.getConfiguredObjectTypeFactory(category, type)) == null) {
            throw new NoFactoryForTypeException(category, type);
        }
        return factory.recover(this, record, parent);
    }

    private String getOnlyValidChildTypeIfKnown(ConfiguredObject<?> parent, String category) {
        Collection<String> validChildTypes;
        if (parent != null && (validChildTypes = this._model.getTypeRegistry().getValidChildTypes(parent.getTypeClass(), category)) != null && validChildTypes.size() == 1) {
            return validChildTypes.iterator().next();
        }
        return null;
    }

    @Override
    public <X extends ConfiguredObject<X>> X create(Class<X> clazz, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        ConfiguredObjectTypeFactory<X> factory = this.getConfiguredObjectTypeFactory(clazz, attributes, parent);
        return factory.create(this, attributes, parent);
    }

    @Override
    public <X extends ConfiguredObject<X>> CompletableFuture<X> createAsync(Class<X> clazz, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        ConfiguredObjectTypeFactory<X> factory = this.getConfiguredObjectTypeFactory(clazz, attributes, parent);
        return factory.createAsync(this, attributes, parent);
    }

    private <X extends ConfiguredObject<X>> ConfiguredObjectTypeFactory<X> getConfiguredObjectTypeFactory(Class<X> categoryClass, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        ConfiguredObjectTypeFactory<X> factory;
        String category = categoryClass.getSimpleName();
        Map<String, ConfiguredObjectTypeFactory> categoryFactories = this._allFactories.get(category);
        if (categoryFactories == null) {
            throw new NoFactoryForCategoryException(category);
        }
        String type = (String)attributes.get("type");
        if (type != null) {
            factory = this.getConfiguredObjectTypeFactory(category, type);
            if (factory == null) {
                throw new NoFactoryForTypeException(category, type);
            }
        } else {
            factory = this.getConfiguredObjectTypeFactory(category, this.getOnlyValidChildTypeIfKnown(parent, category));
        }
        return factory;
    }

    @Override
    public <X extends ConfiguredObject<X>> ConfiguredObjectTypeFactory<X> getConfiguredObjectTypeFactory(String category, String type) {
        Map<String, ConfiguredObjectTypeFactory> categoryFactories = this._allFactories.get(category);
        if (categoryFactories == null) {
            throw new NoFactoryForCategoryException(category);
        }
        ConfiguredObjectTypeFactory factory = categoryFactories.get(type);
        if (factory == null) {
            if (type == null || "".equals(type.trim())) {
                factory = categoryFactories.get(this._defaultTypes.get(category));
            }
            if (factory == null) {
                throw new NoFactoryForTypeException(category, type);
            }
        }
        return factory;
    }

    @Override
    public Collection<String> getSupportedTypes(Class<? extends ConfiguredObject> category) {
        return Collections.unmodifiableCollection(this._supportedTypes.get(category.getSimpleName()));
    }

    @Override
    public Model getModel() {
        return this._model;
    }
}

