/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AbstractCaseAwareGroupProvider;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.adapter.FileBasedGroupProvider;
import org.apache.qpid.server.security.group.FileGroupDatabase;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedGroupProviderImpl
extends AbstractCaseAwareGroupProvider<FileBasedGroupProviderImpl>
implements FileBasedGroupProvider<FileBasedGroupProviderImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedGroupProviderImpl.class);
    public static final String GROUP_FILE_PROVIDER_TYPE = "GroupFile";
    private final Container<?> _container;
    private FileGroupDatabase _groupDatabase;
    @ManagedAttributeField
    private String _path;

    @ManagedObjectFactoryConstructor
    public FileBasedGroupProviderImpl(Map<String, Object> attributes, Container<?> container) {
        super(container, attributes);
        this._container = container;
    }

    @Override
    public void onValidate() {
        Collection<GroupProvider> groupProviders = this._container.getChildren(GroupProvider.class);
        for (GroupProvider provider : groupProviders) {
            if (!(provider instanceof FileBasedGroupProvider) || provider == this) continue;
            try {
                if (!new File(this.getPath()).getCanonicalPath().equals(new File(((FileBasedGroupProvider)provider).getPath()).getCanonicalPath())) continue;
                throw new IllegalConfigurationException("Cannot have two group providers using the same file: " + this.getPath());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid path", e);
            }
        }
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        FileGroupDatabase groupDatabase = new FileGroupDatabase(this);
        try {
            groupDatabase.setGroupFile(this.getPath());
        }
        catch (IOException | RuntimeException e) {
            if (e instanceof IllegalConfigurationException) {
                throw (IllegalConfigurationException)e;
            }
            throw new IllegalConfigurationException(String.format("Cannot load groups from '%s'", this.getPath()), e);
        }
        this._groupDatabase = groupDatabase;
        Set<Principal> groups = this.getGroupPrincipals();
        ArrayList<GroupAdapter> principals = new ArrayList<GroupAdapter>(groups.size());
        for (Principal group : groups) {
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            UUID id = UUID.randomUUID();
            attrMap.put("id", id);
            attrMap.put("name", group.getName());
            GroupAdapter groupAdapter = new GroupAdapter((Map<String, Object>)attrMap);
            principals.add(groupAdapter);
            groupAdapter.registerWithParents();
            groupAdapter.openAsync();
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        File file = new File(this._path);
        if (!file.exists()) {
            File parent = file.getAbsoluteFile().getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IllegalConfigurationException(String.format("Cannot create groups file at '%s'", this._path));
            }
            try {
                String posixFileAttributes = this.getContextValue(String.class, "qpid.default_posix_file_permissions");
                new FileHelper().createNewFile(file, posixFileAttributes);
            }
            catch (IOException e) {
                throw new IllegalConfigurationException(String.format("Cannot create groups file at '%s'", this._path), e);
            }
        }
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        File groupsFile = new File(this._path);
        if (groupsFile.exists()) {
            if (!groupsFile.canRead()) {
                throw new IllegalConfigurationException(String.format("Cannot read groups file '%s'. Please check permissions.", this._path));
            }
            FileGroupDatabase groupDatabase = new FileGroupDatabase(this);
            try {
                groupDatabase.setGroupFile(this._path);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException(String.format("Cannot load groups from '%s'", this._path), e);
            }
        }
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    protected <C extends ConfiguredObject> CompletableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        if (childClass == Group.class) {
            String groupName = (String)attributes.get("name");
            if (this.getState() != State.ACTIVE) {
                throw new IllegalConfigurationException(String.format("Group provider '%s' is not activated. Cannot create a group.", this.getName()));
            }
            this._groupDatabase.createGroup(groupName);
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            UUID id = UUID.randomUUID();
            attrMap.put("id", id);
            attrMap.put("name", groupName);
            GroupAdapter groupAdapter = new GroupAdapter((Map<String, Object>)attrMap);
            groupAdapter.create();
            return CompletableFuture.completedFuture(groupAdapter);
        }
        return super.addChildAsync(childClass, attributes);
    }

    private Set<Principal> getGroupPrincipals() {
        Set<String> groups;
        Set<String> set = groups = this._groupDatabase == null ? Set.of() : this._groupDatabase.getAllGroups();
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String groupName : groups) {
            principals.add(new GroupPrincipal(groupName, this));
        }
        return principals;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> activate() {
        if (this._groupDatabase != null) {
            this.setState(State.ACTIVE);
        } else if (this.getAncestor(SystemConfig.class).isManagementMode()) {
            LOGGER.warn("Failed to activate group provider: {}", (Object)this.getName());
        } else {
            throw new IllegalConfigurationException(String.format("Cannot load groups from '%s'", this.getPath()));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> onDelete() {
        return this.closeChildren().whenCompleteAsync((result, throwable) -> {
            File file = new File(this.getPath());
            if (file.exists() && !file.delete()) {
                throw new IllegalConfigurationException(String.format("Cannot delete group file '%s'", file));
            }
        }, (Executor)this.getTaskExecutor());
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private CompletableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Set<Principal> getGroupPrincipalsForUser(Principal userPrincipal) {
        Set<String> groups;
        Set<String> set = groups = this._groupDatabase == null ? Set.of() : this._groupDatabase.getGroupsForUser(userPrincipal.getName());
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String groupName : groups) {
            principals.add(new GroupPrincipal(groupName, this));
        }
        return principals;
    }

    private class GroupAdapter
    extends AbstractConfiguredObject<GroupAdapter>
    implements Group<GroupAdapter> {
        public GroupAdapter(Map<String, Object> attributes) {
            super(FileBasedGroupProviderImpl.this, attributes);
        }

        @Override
        public void onValidate() {
            super.onValidate();
            if (!this.isDurable()) {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
            }
        }

        @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.ACTIVE)
        private CompletableFuture<Void> activate() {
            this.setState(State.ACTIVE);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        protected void onOpen() {
            super.onOpen();
            Set<String> usersInGroup = FileBasedGroupProviderImpl.this._groupDatabase.getUsersInGroup(this.getName());
            ArrayList<GroupMemberAdapter> members = new ArrayList<GroupMemberAdapter>();
            for (String username : usersInGroup) {
                UUID id = UUID.randomUUID();
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                attrMap.put("id", id);
                attrMap.put("name", username);
                GroupMemberAdapter groupMemberAdapter = new GroupMemberAdapter((Map<String, Object>)attrMap);
                groupMemberAdapter.registerWithParents();
                groupMemberAdapter.openAsync();
                members.add(groupMemberAdapter);
            }
        }

        @Override
        protected <C extends ConfiguredObject> CompletableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
            if (childClass == GroupMember.class) {
                String memberName = (String)attributes.get("name");
                FileBasedGroupProviderImpl.this._groupDatabase.addUserToGroup(memberName, this.getName());
                UUID id = UUID.randomUUID();
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                attrMap.put("id", id);
                attrMap.put("name", memberName);
                GroupMemberAdapter groupMemberAdapter = new GroupMemberAdapter((Map<String, Object>)attrMap);
                groupMemberAdapter.create();
                return CompletableFuture.completedFuture(groupMemberAdapter);
            }
            return super.addChildAsync(childClass, attributes);
        }

        @Override
        protected CompletableFuture<Void> onDelete() {
            FileBasedGroupProviderImpl.this._groupDatabase.removeGroup(this.getName());
            return super.onDelete();
        }

        private class GroupMemberAdapter
        extends AbstractConfiguredObject<GroupMemberAdapter>
        implements GroupMember<GroupMemberAdapter> {
            public GroupMemberAdapter(Map<String, Object> attrMap) {
                super(GroupAdapter.this, attrMap);
            }

            @Override
            public void onValidate() {
                super.onValidate();
                if (!this.isDurable()) {
                    throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
                }
            }

            @Override
            public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
                return Collections.emptySet();
            }

            @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.ACTIVE)
            private CompletableFuture<Void> activate() {
                this.setState(State.ACTIVE);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            protected CompletableFuture<Void> onDelete() {
                FileBasedGroupProviderImpl.this._groupDatabase.removeUserFromGroup(this.getName(), GroupAdapter.this.getName());
                return super.onDelete();
            }
        }
    }
}

