/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.crammd5;

import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.crammd5.AbstractCramMd5Negotiator;
import org.apache.qpid.server.util.Strings;

public class CramMd5Base64HexNegotiator
extends AbstractCramMd5Negotiator {
    public static final String MECHANISM = "CRAM-MD5-HEX";
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final AbstractCramMd5Negotiator.PasswordTransformer BASE64_HEX_PASSWORD_TRANSFORMER = passwordData -> {
        char[] cArray;
        byte[] passwordBytes = Strings.decodeCharArray(passwordData, "CRAM MD5 hex password");
        char[] password = new char[passwordBytes.length * 2];
        try {
            for (int i = 0; i < passwordBytes.length; ++i) {
                password[2 * i] = HEX_CHARACTERS[(passwordBytes[i] & 0xF0) >> 4];
                password[2 * i + 1] = HEX_CHARACTERS[passwordBytes[i] & 0xF];
            }
            cArray = password;
        }
        catch (Throwable throwable) {
            Strings.clearByteArray(new byte[][]{passwordBytes});
            throw throwable;
        }
        Strings.clearByteArray(new byte[][]{passwordBytes});
        return cArray;
    };

    public CramMd5Base64HexNegotiator(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider, String localFQDN, PasswordSource passwordSource) {
        super(authenticationProvider, localFQDN, passwordSource, BASE64_HEX_PASSWORD_TRANSFORMER);
    }
}

